/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.state;

import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerLatencyComparator;
import com.allanbank.mongodb.client.state.ServerSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LatencyServerSelector
implements ServerSelector {
    private final Cluster myCluster;
    private final boolean myWritableOnly;

    public LatencyServerSelector(Cluster cluster, boolean bl) {
        this.myCluster = cluster;
        this.myWritableOnly = bl;
    }

    @Override
    public List<Server> pickServers() {
        List<Server> list = this.myWritableOnly ? this.myCluster.getWritableServers() : this.myCluster.getServers();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        list = new ArrayList<Server>(list);
        Collections.sort(list, ServerLatencyComparator.COMPARATOR);
        return list;
    }
}

