/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.state;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.client.callback.FutureReplyCallback;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.client.state.Server;
import java.util.List;

public class ServerUpdateCallback
extends FutureReplyCallback {
    private final Server myServer;

    public ServerUpdateCallback(Server server) {
        this.myServer = server;
    }

    @Override
    public void callback(Reply reply) {
        if (this.myServer != null) {
            this.update(reply);
        }
        super.callback(reply);
    }

    @Override
    public void exception(Throwable throwable) {
        if (this.myServer != null) {
            this.myServer.requestFailed();
        }
        super.exception(throwable);
    }

    private void update(Reply reply) {
        List<Document> list;
        if (reply != null && (list = reply.getResults()).size() >= 1) {
            Document document = list.get(0);
            this.myServer.update(document);
        }
    }
}

