/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.error;

import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.VersionRange;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ServerVersionException
extends MongoDbException {
    private static final long serialVersionUID = -8577756570001826274L;
    private final Version myActualVersion;
    private transient Message myMessage;
    private final String myOperation;
    private final VersionRange myRange;

    private static String message(String string, VersionRange versionRange, Version version) {
        if (Version.VERSION_0.equals(versionRange.getLowerBounds())) {
            return "Attempted to send the '" + string + "' operation to a version " + version + " server but the operation is only supported " + "before version " + versionRange.getUpperBounds() + ".";
        }
        if (Version.UNKNOWN.equals(versionRange.getUpperBounds())) {
            return "Attempted to send the '" + string + "' operation to a version " + version + " server but the operation is only supported " + "after version " + versionRange.getLowerBounds() + ".";
        }
        return "Attempted to send the '" + string + "' operation to a version " + version + " server but the operation is only supported " + "from version " + versionRange.getLowerBounds() + " to " + versionRange.getUpperBounds() + ".";
    }

    public ServerVersionException(String string, VersionRange versionRange, Version version, Message message) {
        super(ServerVersionException.message(string, versionRange, version));
        this.myOperation = string;
        this.myActualVersion = version;
        this.myRange = versionRange;
        this.myMessage = message;
    }

    public Version getActualVersion() {
        return this.myActualVersion;
    }

    public Version getMaximumVersion() {
        return this.myRange.getUpperBounds();
    }

    public String getOperation() {
        return this.myOperation;
    }

    public Version getRequiredVersion() {
        return this.myRange.getLowerBounds();
    }

    public Message getSentMessage() {
        return this.myMessage;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.myMessage = null;
    }
}

