/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.util;

import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;

public final class IOUtils {
    private static final char[] BASE_64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final byte[] CHAR_TO_BASE_64_BITS = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final byte[] CHAR_TO_HEX_NIBBLE;
    private static final char[] HEX_CHARS;
    private static final Log LOG;

    public static byte[] base64ToBytes(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        int n5 = n4 / 4;
        if (4 * n5 != n4) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int n6 = 0;
        int n7 = n5;
        if (n4 != 0) {
            if (string.charAt(n4 - 1) == '=') {
                ++n6;
                --n7;
            }
            if (string.charAt(n4 - 2) == '=') {
                ++n6;
            }
        }
        byte[] byArray = new byte[3 * n5 - n6];
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = IOUtils.alphabetToBits(CHAR_TO_BASE_64_BITS, string.charAt(n8++));
            n = IOUtils.alphabetToBits(CHAR_TO_BASE_64_BITS, string.charAt(n8++));
            int n10 = IOUtils.alphabetToBits(CHAR_TO_BASE_64_BITS, string.charAt(n8++));
            int n11 = IOUtils.alphabetToBits(CHAR_TO_BASE_64_BITS, string.charAt(n8++));
            byArray[n9++] = (byte)((n2 << 2) + (n >> 4));
            byArray[n9++] = (byte)((n << 4) + (n10 >> 2));
            byArray[n9++] = (byte)((n10 << 6) + n11);
        }
        if (n6 != 0) {
            n3 = IOUtils.alphabetToBits(CHAR_TO_BASE_64_BITS, string.charAt(n8++));
            n2 = IOUtils.alphabetToBits(CHAR_TO_BASE_64_BITS, string.charAt(n8++));
            byArray[n9++] = (byte)((n3 << 2) + (n2 >> 4));
            if (n6 == 1) {
                n = IOUtils.alphabetToBits(CHAR_TO_BASE_64_BITS, string.charAt(n8++));
                byArray[n9++] = (byte)((n2 << 4) + (n >> 2));
            }
        }
        return byArray;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            IOUtils.close(closeable, Level.FINE, "I/O Exception closing: " + closeable.getClass().getSimpleName());
        }
    }

    public static void close(Closeable closeable, Level level, String string) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                LOG.log(level, string);
            }
        }
    }

    public static byte[] hexToBytes(String string) {
        String string2 = string.trim();
        int n = string2.length();
        if ((n & 1) == 1) {
            throw new IllegalArgumentException("A hex string must be an even number of characters: '" + string2 + "'");
        }
        byte[] byArray = new byte[n >> 1];
        for (int i = 0; i < n; i += 2) {
            int n2 = IOUtils.alphabetToBits(CHAR_TO_HEX_NIBBLE, string2.charAt(i));
            int n3 = IOUtils.alphabetToBits(CHAR_TO_HEX_NIBBLE, string2.charAt(i + 1));
            byArray[i >> 1] = (byte)((n2 << 4 & 0xF0) + (n3 & 0xF));
        }
        return byArray;
    }

    public static String toBase64(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4 = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(4 * ((n4 + 2) / 3));
        int n5 = 0;
        int n6 = n4 / 3;
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = byArray[n5++] & 0xFF;
            n = byArray[n5++] & 0xFF;
            int n7 = byArray[n5++] & 0xFF;
            stringBuffer.append(BASE_64_CHARS[n2 >> 2]);
            stringBuffer.append(BASE_64_CHARS[n2 << 4 & 0x3F | n >> 4]);
            stringBuffer.append(BASE_64_CHARS[n << 2 & 0x3F | n7 >> 6]);
            stringBuffer.append(BASE_64_CHARS[n7 & 0x3F]);
        }
        n3 = n4 - 3 * n6;
        if (n3 > 0) {
            n2 = byArray[n5++] & 0xFF;
            stringBuffer.append(BASE_64_CHARS[n2 >> 2]);
            if (n3 == 1) {
                stringBuffer.append(BASE_64_CHARS[n2 << 4 & 0x3F]);
                stringBuffer.append("==");
            } else {
                n = byArray[n5++] & 0xFF;
                stringBuffer.append(BASE_64_CHARS[n2 << 4 & 0x3F | n >> 4]);
                stringBuffer.append(BASE_64_CHARS[n << 2 & 0x3F]);
                stringBuffer.append('=');
            }
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(HEX_CHARS[by >> 4 & 0xF]);
            stringBuilder.append(HEX_CHARS[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    private static int alphabetToBits(byte[] byArray, char c) {
        int n = -1;
        if (c < byArray.length) {
            n = byArray[c];
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid character in the encoded string: '" + c + "'.");
        }
        return n;
    }

    private IOUtils() {
    }

    static {
        HEX_CHARS = "0123456789abcdef".toCharArray();
        LOG = LogFactory.getLog(IOUtils.class);
        CHAR_TO_HEX_NIBBLE = new byte[128];
        Arrays.fill(CHAR_TO_HEX_NIBBLE, (byte)-1);
        IOUtils.CHAR_TO_HEX_NIBBLE[48] = 0;
        IOUtils.CHAR_TO_HEX_NIBBLE[49] = 1;
        IOUtils.CHAR_TO_HEX_NIBBLE[50] = 2;
        IOUtils.CHAR_TO_HEX_NIBBLE[51] = 3;
        IOUtils.CHAR_TO_HEX_NIBBLE[52] = 4;
        IOUtils.CHAR_TO_HEX_NIBBLE[53] = 5;
        IOUtils.CHAR_TO_HEX_NIBBLE[54] = 6;
        IOUtils.CHAR_TO_HEX_NIBBLE[55] = 7;
        IOUtils.CHAR_TO_HEX_NIBBLE[56] = 8;
        IOUtils.CHAR_TO_HEX_NIBBLE[57] = 9;
        IOUtils.CHAR_TO_HEX_NIBBLE[97] = 10;
        IOUtils.CHAR_TO_HEX_NIBBLE[98] = 11;
        IOUtils.CHAR_TO_HEX_NIBBLE[99] = 12;
        IOUtils.CHAR_TO_HEX_NIBBLE[100] = 13;
        IOUtils.CHAR_TO_HEX_NIBBLE[101] = 14;
        IOUtils.CHAR_TO_HEX_NIBBLE[102] = 15;
        IOUtils.CHAR_TO_HEX_NIBBLE[65] = 10;
        IOUtils.CHAR_TO_HEX_NIBBLE[66] = 11;
        IOUtils.CHAR_TO_HEX_NIBBLE[67] = 12;
        IOUtils.CHAR_TO_HEX_NIBBLE[68] = 13;
        IOUtils.CHAR_TO_HEX_NIBBLE[69] = 14;
        IOUtils.CHAR_TO_HEX_NIBBLE[70] = 15;
    }
}

