/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class ServerNameUtils {
    public static final int DEFAULT_PORT = 27017;
    public static final int IPV6_LENGTH = 16;
    private static final Pattern IPV6_ELLIPSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^(?:[0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4}$");

    public static String normalize(InetSocketAddress inetSocketAddress) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = inetSocketAddress.isUnresolved() ? inetSocketAddress.getHostName() : inetSocketAddress.getAddress().getHostName();
        if (IPV6_ELLIPSED_PATTERN.matcher(string).matches() || IPV6_PATTERN.matcher(string).matches()) {
            stringBuilder.append('[');
            stringBuilder.append(string);
            stringBuilder.append(']');
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(':');
        stringBuilder.append(inetSocketAddress.getPort());
        return stringBuilder.toString();
    }

    public static String normalize(String string) {
        String string2 = string;
        int n = 27017;
        int n2 = string.indexOf(91);
        int n3 = string.lastIndexOf(93);
        int n4 = string.lastIndexOf(58);
        if (n2 == 0 && n3 > 0) {
            String string3;
            if (n4 == n3 + 1) {
                string3 = string.substring(n4 + 1);
                try {
                    Integer.parseInt(string3);
                    return string;
                }
                catch (NumberFormatException numberFormatException) {
                    n = 27017;
                }
            }
            string3 = string.substring(0, n3 + 1);
            return string3 + ":" + n;
        }
        if (0 <= n4) {
            Object object;
            int n5 = string.lastIndexOf(58, n4 - 1);
            if (0 <= n5) {
                try {
                    object = InetAddress.getByName(string);
                    byte[] byArray = ((InetAddress)object).getAddress();
                    if (byArray.length == 16) {
                        return "[" + string + "]:" + 27017;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    String string4 = string.substring(0, n4);
                    String string5 = string.substring(n4 + 1);
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string4);
                        byte[] byArray = inetAddress.getAddress();
                        if (byArray.length == 16) {
                            n = Integer.parseInt(string5);
                            return "[" + string4 + "]:" + n;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 27017;
                    }
                    catch (UnknownHostException unknownHostException2) {
                        unknownHostException2.hashCode();
                    }
                }
            }
            object = string.substring(n4 + 1);
            try {
                Integer.parseInt((String)object);
                return string;
            }
            catch (NumberFormatException numberFormatException) {
                n = 27017;
            }
        }
        return string2 + ':' + n;
    }

    public static InetSocketAddress parse(String string) {
        String string2 = string;
        int n = 27017;
        int n2 = string.indexOf(91);
        int n3 = string.lastIndexOf(93);
        int n4 = string.lastIndexOf(58);
        if (n2 == 0 && n3 > 0) {
            if (n3 + 1 == n4) {
                String string3 = string.substring(n4 + 1);
                try {
                    n = Integer.parseInt(string3);
                    string2 = string.substring(0, n4);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 27017;
                }
            }
        } else if (n4 > 0) {
            String string4 = string.substring(n4 + 1);
            try {
                n = Integer.parseInt(string4);
                string2 = string.substring(0, n4);
            }
            catch (NumberFormatException numberFormatException) {
                n = 27017;
            }
        }
        return new InetSocketAddress(string2, n);
    }

    private ServerNameUtils() {
    }
}

