/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.util.log;

import com.allanbank.mongodb.util.log.AbstractLog;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JulLog
extends AbstractLog {
    private final Logger myDelegate;

    protected JulLog(Class<?> clazz) {
        this.myDelegate = Logger.getLogger(clazz.getName());
    }

    @Override
    protected final void doLog(Level level, Throwable throwable, String string, Object ... objectArray) {
        if (this.myDelegate.isLoggable(level)) {
            Thread thread = Thread.currentThread();
            LogRecord logRecord = new LogRecord(level, this.format(string, objectArray));
            logRecord.setLoggerName(this.myDelegate.getName());
            logRecord.setThrown(throwable);
            logRecord.setThreadID((int)Thread.currentThread().getId());
            boolean bl = true;
            for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                String string2 = stackTraceElement.getClassName();
                if (bl) {
                    bl = !CLASS_NAME.equals(string2);
                    continue;
                }
                if (CLASS_NAME.equals(string2)) continue;
                logRecord.setSourceClassName(string2);
                logRecord.setSourceMethodName(stackTraceElement.getMethodName());
                break;
            }
            this.myDelegate.log(logRecord);
        }
    }

    private String format(String string, Object[] objectArray) {
        String string2 = string;
        if (objectArray != null && objectArray.length > 0 && string.indexOf("{}") >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (Object object : objectArray) {
                int n = string2.indexOf("{}");
                if (n < 0) break;
                stringBuilder.append(string2.substring(0, n));
                stringBuilder.append(object);
                string2 = string2.substring(n + 2);
            }
            stringBuilder.append(string2);
            string2 = stringBuilder.toString();
        }
        return string2;
    }
}

