/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.VersionedWritable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClusterStatus
extends VersionedWritable {
    private static final byte VERSION = 2;
    private String hbaseVersion;
    private Map<ServerName, ServerLoad> liveServers;
    private Collection<ServerName> deadServers;
    private ServerName master;
    private Collection<ServerName> backupMasters;
    private Map<String, RegionState> intransition;
    private String clusterId;
    private String[] masterCoprocessors;
    private Boolean balancerOn;

    @Deprecated
    public ClusterStatus() {
    }

    public ClusterStatus(String hbaseVersion, String clusterid, Map<ServerName, ServerLoad> servers, Collection<ServerName> deadServers, ServerName master, Collection<ServerName> backupMasters, Map<String, RegionState> rit, String[] masterCoprocessors, Boolean balancerOn) {
        this.hbaseVersion = hbaseVersion;
        this.liveServers = servers;
        this.deadServers = deadServers;
        this.master = master;
        this.backupMasters = backupMasters;
        this.intransition = rit;
        this.clusterId = clusterid;
        this.masterCoprocessors = masterCoprocessors;
        this.balancerOn = balancerOn;
    }

    public Collection<ServerName> getDeadServerNames() {
        return Collections.unmodifiableCollection(this.deadServers);
    }

    public int getServersSize() {
        return this.liveServers.size();
    }

    public int getDeadServers() {
        return this.deadServers.size();
    }

    public double getAverageLoad() {
        int load = this.getRegionsCount();
        return (double)load / (double)this.getServersSize();
    }

    public int getRegionsCount() {
        int count = 0;
        for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
            count += e.getValue().getNumberOfRegions();
        }
        return count;
    }

    public int getRequestsCount() {
        int count = 0;
        for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
            count += e.getValue().getNumberOfRequests();
        }
        return count;
    }

    public String getHBaseVersion() {
        return this.hbaseVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterStatus)) {
            return false;
        }
        return this.getVersion() == ((ClusterStatus)((Object)o)).getVersion() && this.getHBaseVersion().equals(((ClusterStatus)((Object)o)).getHBaseVersion()) && ((Object)this.liveServers).equals(((ClusterStatus)((Object)o)).liveServers) && this.deadServers.containsAll(((ClusterStatus)((Object)o)).deadServers) && Arrays.equals(this.masterCoprocessors, ((ClusterStatus)((Object)o)).masterCoprocessors) && this.master.equals(((ClusterStatus)((Object)o)).master) && this.backupMasters.containsAll(((ClusterStatus)((Object)o)).backupMasters);
    }

    public int hashCode() {
        return 2 + this.hbaseVersion.hashCode() + ((Object)this.liveServers).hashCode() + ((Object)this.deadServers).hashCode() + this.master.hashCode() + ((Object)this.backupMasters).hashCode();
    }

    public byte getVersion() {
        return 2;
    }

    public Collection<ServerName> getServerInfo() {
        return this.getServers();
    }

    public Collection<ServerName> getServers() {
        return Collections.unmodifiableCollection(this.liveServers.keySet());
    }

    public ServerName getMaster() {
        return this.master;
    }

    public int getBackupMastersSize() {
        return this.backupMasters.size();
    }

    public Collection<ServerName> getBackupMasters() {
        return Collections.unmodifiableCollection(this.backupMasters);
    }

    public ServerLoad getLoad(ServerName sn) {
        return this.liveServers.get(sn);
    }

    @InterfaceAudience.Private
    public Map<String, RegionState> getRegionsInTransition() {
        return this.intransition;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String[] getMasterCoprocessors() {
        return this.masterCoprocessors;
    }

    public boolean isBalancerOn() {
        return this.balancerOn != null && this.balancerOn != false;
    }

    public Boolean getBalancerOn() {
        return this.balancerOn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Master: " + this.master);
        sb.append("\nNumber of backup masters: " + this.backupMasters.size());
        for (ServerName serverName : this.backupMasters) {
            sb.append("\n  " + serverName);
        }
        sb.append("\nNumber of live region servers: " + this.liveServers.size());
        for (ServerName serverName : this.liveServers.keySet()) {
            sb.append("\n  " + serverName.getServerName());
        }
        sb.append("\nNumber of dead region servers: " + this.deadServers.size());
        for (ServerName serverName : this.deadServers) {
            sb.append("\n  " + serverName);
        }
        sb.append("\nAverage load: " + this.getAverageLoad());
        sb.append("\nNumber of requests: " + this.getRequestsCount());
        sb.append("\nNumber of regions: " + this.getRegionsCount());
        sb.append("\nNumber of regions in transition: " + this.intransition.size());
        for (RegionState state : this.intransition.values()) {
            sb.append("\n  " + state.toDescriptiveString());
        }
        return sb.toString();
    }

    public ClusterStatusProtos.ClusterStatus convert() {
        ClusterStatusProtos.ClusterStatus.Builder builder = ClusterStatusProtos.ClusterStatus.newBuilder();
        builder.setHbaseVersion(FSProtos.HBaseVersionFileContent.newBuilder().setVersion(this.getHBaseVersion()));
        if (this.liveServers != null) {
            for (Map.Entry entry : this.liveServers.entrySet()) {
                ClusterStatusProtos.LiveServerInfo.Builder lsi = ClusterStatusProtos.LiveServerInfo.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)entry.getKey()));
                lsi.setServerLoad(((ServerLoad)entry.getValue()).obtainServerLoadPB());
                builder.addLiveServers(lsi.build());
            }
        }
        if (this.deadServers != null) {
            for (ServerName serverName : this.deadServers) {
                builder.addDeadServers(ProtobufUtil.toServerName(serverName));
            }
        }
        if (this.intransition != null) {
            for (Map.Entry entry : this.getRegionsInTransition().entrySet()) {
                ClusterStatusProtos.RegionState rs = ((RegionState)entry.getValue()).convert();
                HBaseProtos.RegionSpecifier.Builder spec = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
                spec.setValue(ByteStringer.wrap((byte[])Bytes.toBytes((String)((String)entry.getKey()))));
                ClusterStatusProtos.RegionInTransition pbRIT = ClusterStatusProtos.RegionInTransition.newBuilder().setSpec(spec.build()).setRegionState(rs).build();
                builder.addRegionsInTransition(pbRIT);
            }
        }
        if (this.clusterId != null) {
            builder.setClusterId(new ClusterId(this.clusterId).convert());
        }
        if (this.masterCoprocessors != null) {
            for (String coprocessor : this.masterCoprocessors) {
                builder.addMasterCoprocessors(HBaseProtos.Coprocessor.newBuilder().setName(coprocessor));
            }
        }
        if (this.master != null) {
            builder.setMaster(ProtobufUtil.toServerName(this.getMaster()));
        }
        if (this.backupMasters != null) {
            for (ServerName serverName : this.backupMasters) {
                builder.addBackupMasters(ProtobufUtil.toServerName(serverName));
            }
        }
        if (this.balancerOn != null) {
            builder.setBalancerOn(this.balancerOn.booleanValue());
        }
        return builder.build();
    }

    public static ClusterStatus convert(ClusterStatusProtos.ClusterStatus proto) {
        HashMap<ServerName, ServerLoad> servers = null;
        if (proto.getLiveServersList() != null) {
            servers = new HashMap<ServerName, ServerLoad>(proto.getLiveServersList().size());
            for (ClusterStatusProtos.LiveServerInfo lsi : proto.getLiveServersList()) {
                servers.put(ProtobufUtil.toServerName(lsi.getServer()), new ServerLoad(lsi.getServerLoad()));
            }
        }
        ArrayList<ServerName> deadServers = null;
        if (proto.getDeadServersList() != null) {
            deadServers = new ArrayList<ServerName>(proto.getDeadServersList().size());
            for (HBaseProtos.ServerName sn : proto.getDeadServersList()) {
                deadServers.add(ProtobufUtil.toServerName(sn));
            }
        }
        ArrayList<ServerName> backupMasters = null;
        if (proto.getBackupMastersList() != null) {
            backupMasters = new ArrayList<ServerName>(proto.getBackupMastersList().size());
            for (HBaseProtos.ServerName sn : proto.getBackupMastersList()) {
                backupMasters.add(ProtobufUtil.toServerName(sn));
            }
        }
        HashMap<String, RegionState> rit = null;
        if (proto.getRegionsInTransitionList() != null) {
            rit = new HashMap<String, RegionState>(proto.getRegionsInTransitionList().size());
            for (ClusterStatusProtos.RegionInTransition region : proto.getRegionsInTransitionList()) {
                String key = new String(region.getSpec().getValue().toByteArray());
                RegionState value = RegionState.convert(region.getRegionState());
                rit.put(key, value);
            }
        }
        String[] masterCoprocessors = null;
        if (proto.getMasterCoprocessorsList() != null) {
            int numMasterCoprocessors = proto.getMasterCoprocessorsCount();
            masterCoprocessors = new String[numMasterCoprocessors];
            for (int i = 0; i < numMasterCoprocessors; ++i) {
                masterCoprocessors[i] = proto.getMasterCoprocessors(i).getName();
            }
        }
        return new ClusterStatus(proto.getHbaseVersion().getVersion(), ClusterId.convert(proto.getClusterId()).toString(), servers, deadServers, ProtobufUtil.toServerName(proto.getMaster()), backupMasters, rit, masterCoprocessors, proto.getBalancerOn());
    }
}

