/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.LockType;
import com.allanbank.mongodb.MongoClient;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbUri;
import com.allanbank.mongodb.MongoFactory;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.BatchedWriteMode;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.QueryBuilder;
import com.allanbank.mongodb.builder.Sort;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncMongoDbClient
extends DB {
    protected static final int INCLUDE = 1;
    private static String databaseName;
    private static final ThreadLocal<DocumentBuilder> DOCUMENT_BUILDER;
    private static final AtomicInteger INIT_COUNT;
    private static MongoClient mongoClient;
    private static Durability writeConcern;
    private static ReadPreference readPreference;
    private MongoDatabase database;
    private static int batchSize;
    private final BatchedWrite.Builder batchedWrite = BatchedWrite.builder().mode(BatchedWriteMode.REORDERED);
    private int batchedWriteCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup() throws DBException {
        if (INIT_COUNT.decrementAndGet() == 0) {
            try {
                mongoClient.close();
            }
            catch (Exception e1) {
                System.err.println("Could not close MongoDB connection pool: " + e1.toString());
                e1.printStackTrace();
                return;
            }
            finally {
                mongoClient = null;
                this.database = null;
            }
        }
    }

    public final int delete(String table, String key) {
        try {
            MongoCollection collection = this.database.getCollection(table);
            Document q = BuilderFactory.start().add("_id", key).build();
            long res = collection.delete((DocumentAssignable)q, writeConcern);
            if (res == 0L) {
                System.err.println("Nothing deleted for key " + key);
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() throws DBException {
        int count = INIT_COUNT.incrementAndGet();
        Class<AsyncMongoDbClient> clazz = AsyncMongoDbClient.class;
        synchronized (AsyncMongoDbClient.class) {
            Properties props = this.getProperties();
            if (mongoClient != null) {
                this.database = mongoClient.getDatabase(databaseName);
                if (count > mongoClient.getConfig().getMaxConnectionCount()) {
                    mongoClient.getConfig().setLockType(LockType.MUTEX);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            batchSize = Integer.parseInt(props.getProperty("mongodb.batchsize", "1"));
            String url = props.getProperty("mongodb.url", "mongodb://localhost:27017/ycsb?w=1");
            if (!url.startsWith("mongodb://")) {
                System.err.println("ERROR: Invalid URL: '" + url + "'. Must be of the form " + "'mongodb://<host1>:<port1>,<host2>:<port2>/database?" + "options'. See " + "http://docs.mongodb.org/manual/reference/connection-string/.");
                System.exit(1);
            }
            MongoDbUri uri = new MongoDbUri(url);
            try {
                databaseName = uri.getDatabase();
                if (databaseName == null || databaseName.isEmpty()) {
                    databaseName = "ycsb";
                }
                mongoClient = MongoFactory.createClient((MongoDbUri)uri);
                MongoClientConfiguration config = mongoClient.getConfig();
                if (!url.toLowerCase().contains("locktype=")) {
                    config.setLockType(LockType.LOW_LATENCY_SPIN);
                }
                readPreference = config.getDefaultReadPreference();
                writeConcern = config.getDefaultDurability();
                this.database = mongoClient.getDatabase(databaseName);
                System.out.println("mongo connection created with " + url);
            }
            catch (Exception e1) {
                System.err.println("Could not initialize MongoDB connection pool for Loader: " + e1.toString());
                e1.printStackTrace();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            return;
        }
    }

    public final int insert(String table, String key, HashMap<String, ByteIterator> values) {
        MongoCollection collection = this.database.getCollection(table);
        DocumentBuilder toInsert = DOCUMENT_BUILDER.get().reset().add("_id", key);
        Document query = toInsert.build();
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            toInsert.add(entry.getKey(), entry.getValue().toArray());
        }
        if (batchSize <= 1) {
            long result = collection.update((DocumentAssignable)query, (DocumentAssignable)toInsert, false, true, writeConcern);
            return result == 1L ? 0 : 1;
        }
        try {
            this.batchedWrite.insert((DocumentAssignable)toInsert);
            ++this.batchedWriteCount;
            if (this.batchedWriteCount < batchSize) {
                return 0;
            }
            long count = collection.write(this.batchedWrite);
            if (count == (long)this.batchedWriteCount) {
                this.batchedWrite.reset().mode(BatchedWriteMode.REORDERED);
                this.batchedWriteCount = 0;
                return 0;
            }
            System.err.println("Number of inserted documents doesn't match the number sent, " + count + " inserted, sent " + this.batchedWriteCount);
            this.batchedWrite.reset().mode(BatchedWriteMode.REORDERED);
            this.batchedWriteCount = 0;
            return 1;
        }
        catch (Exception e) {
            try {
                System.err.println("Exception while trying bulk insert with " + this.batchedWriteCount);
                e.printStackTrace();
                return 1;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return 1;
            }
        }
    }

    public final int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        try {
            MongoCollection collection = this.database.getCollection(table);
            DocumentBuilder query = DOCUMENT_BUILDER.get().reset().add("_id", key);
            Document queryResult = null;
            if (fields != null) {
                DocumentBuilder fieldsToReturn = BuilderFactory.start();
                Iterator<String> iter = fields.iterator();
                while (iter.hasNext()) {
                    fieldsToReturn.add(iter.next(), 1);
                }
                Find.Builder fb = new Find.Builder((DocumentAssignable)query);
                fb.projection((DocumentAssignable)fieldsToReturn);
                fb.setLimit(1);
                fb.setBatchSize(1);
                fb.readPreference(readPreference);
                MongoIterator ci = collection.find(fb.build());
                if (ci.hasNext()) {
                    queryResult = (Document)ci.next();
                    ci.close();
                }
            } else {
                queryResult = collection.findOne((DocumentAssignable)query);
            }
            if (queryResult != null) {
                this.fillMap(result, queryResult);
            }
            return queryResult != null ? 0 : 1;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return 1;
        }
    }

    public final int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        try {
            MongoCollection collection = this.database.getCollection(table);
            Find.Builder find = Find.builder().query((DocumentAssignable)QueryBuilder.where((String)"_id").greaterThanOrEqualTo(startkey)).limit(recordcount).batchSize(recordcount).sort(new IntegerElement[]{Sort.asc((String)"_id")}).readPreference(readPreference);
            if (fields != null) {
                DocumentBuilder fieldsDoc = BuilderFactory.start();
                for (String field : fields) {
                    fieldsDoc.add(field, 1);
                }
                find.projection((DocumentAssignable)fieldsDoc);
            }
            result.ensureCapacity(recordcount);
            MongoIterator cursor = collection.find(find);
            if (!cursor.hasNext()) {
                System.err.println("Nothing found in scan for key " + startkey);
                return 1;
            }
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                HashMap<String, ByteIterator> docAsMap = new HashMap<String, ByteIterator>();
                this.fillMap(docAsMap, doc);
                result.add(docAsMap);
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return 1;
        }
    }

    public final int update(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            MongoCollection collection = this.database.getCollection(table);
            DocumentBuilder query = BuilderFactory.start().add("_id", key);
            DocumentBuilder update = BuilderFactory.start();
            DocumentBuilder fieldsToSet = update.push("$set");
            for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                fieldsToSet.add(entry.getKey(), entry.getValue().toArray());
            }
            long res = collection.update((DocumentAssignable)query, (DocumentAssignable)update, false, false, writeConcern);
            return res == 1L ? 0 : 1;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return 1;
        }
    }

    protected final void fillMap(HashMap<String, ByteIterator> result, Document queryResult) {
        for (Element be : queryResult) {
            if (be.getType() != ElementType.BINARY) continue;
            result.put(be.getName(), new BinaryByteArrayIterator((BinaryElement)be));
        }
    }

    static {
        DOCUMENT_BUILDER = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                return BuilderFactory.start();
            }
        };
        INIT_COUNT = new AtomicInteger(0);
    }

    private static final class BinaryByteArrayIterator
    extends ByteIterator {
        private final BinaryElement binaryElement;
        private int offset;

        public BinaryByteArrayIterator(BinaryElement element) {
            this.binaryElement = element;
            this.offset = 0;
        }

        public long bytesLeft() {
            return Math.max(0, this.binaryElement.length() - this.offset);
        }

        public boolean hasNext() {
            return this.offset < this.binaryElement.length();
        }

        public byte nextByte() {
            byte value = this.binaryElement.get(this.offset);
            ++this.offset;
            return value;
        }
    }
}

