/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.db.OptionsSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

public class MongoDbClient
extends DB {
    private static final Integer INCLUDE = 1;
    private static final InsertManyOptions INSERT_UNORDERED = new InsertManyOptions().ordered(false);
    private static final UpdateOptions UPDATE_WITH_UPSERT = new UpdateOptions().upsert(true);
    private static String databaseName;
    private static MongoDatabase database;
    private static final AtomicInteger INIT_COUNT;
    private static MongoClient mongoClient;
    private static ReadPreference readPreference;
    private static WriteConcern writeConcern;
    private static int batchSize;
    private final List<Document> bulkInserts = new ArrayList<Document>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws DBException {
        if (INIT_COUNT.decrementAndGet() == 0) {
            try {
                mongoClient.close();
            }
            catch (Exception e1) {
                System.err.println("Could not close MongoDB connection pool: " + e1.toString());
                e1.printStackTrace();
                return;
            }
            finally {
                database = null;
                mongoClient = null;
            }
        }
    }

    public int delete(String table, String key) {
        try {
            MongoCollection collection = database.getCollection(table);
            Document query = new Document("_id", (Object)key);
            DeleteResult result = collection.withWriteConcern(writeConcern).deleteOne((Bson)query);
            if (result.wasAcknowledged() && result.getDeletedCount() == 0L) {
                System.err.println("Nothing deleted for key " + key);
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws DBException {
        INIT_COUNT.incrementAndGet();
        Integer n = INCLUDE;
        synchronized (n) {
            if (mongoClient != null) {
                return;
            }
            Properties props = this.getProperties();
            batchSize = Integer.parseInt(props.getProperty("batchsize", "1"));
            String url = props.getProperty("mongodb.url", null);
            boolean defaultedUrl = false;
            if (url == null) {
                defaultedUrl = true;
                url = "mongodb://localhost:27017/ycsb?w=1";
            }
            if (!(url = OptionsSupport.updateUrl(url, props)).startsWith("mongodb://")) {
                System.err.println("ERROR: Invalid URL: '" + url + "'. Must be of the form " + "'mongodb://<host1>:<port1>,<host2>:<port2>/database?options'. " + "http://docs.mongodb.org/manual/reference/connection-string/");
                System.exit(1);
            }
            try {
                MongoClientURI uri = new MongoClientURI(url);
                String uriDb = uri.getDatabase();
                databaseName = !defaultedUrl && uriDb != null && !uriDb.isEmpty() && !"admin".equals(uriDb) ? uriDb : "ycsb";
                readPreference = uri.getOptions().getReadPreference();
                writeConcern = uri.getOptions().getWriteConcern();
                mongoClient = new MongoClient(uri);
                database = mongoClient.getDatabase(databaseName).withReadPreference(readPreference).withWriteConcern(writeConcern);
                System.out.println("mongo client connection created with " + url);
            }
            catch (Exception e1) {
                System.err.println("Could not initialize MongoDB connection pool for Loader: " + e1.toString());
                e1.printStackTrace();
                return;
            }
        }
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            MongoCollection collection = database.getCollection(table);
            Document toInsert = new Document("_id", (Object)key);
            for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                toInsert.put(entry.getKey(), (Object)entry.getValue().toArray());
            }
            if (batchSize == 1) {
                collection.replaceOne((Bson)new Document("_id", toInsert.get((Object)"_id")), (Object)toInsert, UPDATE_WITH_UPSERT);
            } else {
                this.bulkInserts.add(toInsert);
                if (this.bulkInserts.size() == batchSize) {
                    collection.insertMany(this.bulkInserts, INSERT_UNORDERED);
                    this.bulkInserts.clear();
                }
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println("Exception while trying bulk insert with " + this.bulkInserts.size());
            e.printStackTrace();
            return 1;
        }
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        try {
            Document queryResult;
            MongoCollection collection = database.getCollection(table);
            Document query = new Document("_id", (Object)key);
            FindIterable findIterable = collection.find((Bson)query);
            if (fields != null) {
                Document projection = new Document();
                for (String field : fields) {
                    projection.put(field, (Object)INCLUDE);
                }
                findIterable.projection((Bson)projection);
            }
            if ((queryResult = (Document)findIterable.first()) != null) {
                this.fillMap(result, queryResult);
            }
            return queryResult != null ? 0 : 1;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        MongoCursor cursor = null;
        try {
            MongoCollection collection = database.getCollection(table);
            Document scanRange = new Document("$gte", (Object)startkey);
            Document query = new Document("_id", (Object)scanRange);
            Document sort = new Document("_id", (Object)INCLUDE);
            FindIterable findIterable = collection.find((Bson)query).sort((Bson)sort).limit(recordcount);
            if (fields != null) {
                Document projection = new Document();
                for (String fieldName : fields) {
                    projection.put(fieldName, (Object)INCLUDE);
                }
                findIterable.projection((Bson)projection);
            }
            if (!(cursor = findIterable.iterator()).hasNext()) {
                System.err.println("Nothing found in scan for key " + startkey);
                int projection = 1;
                return projection;
            }
            result.ensureCapacity(recordcount);
            while (cursor.hasNext()) {
                HashMap<String, ByteIterator> resultMap = new HashMap<String, ByteIterator>();
                Document obj = (Document)cursor.next();
                this.fillMap(resultMap, obj);
                result.add(resultMap);
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            int n = 1;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            MongoCollection collection = database.getCollection(table);
            Document query = new Document("_id", (Object)key);
            Document fieldsToSet = new Document();
            for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                fieldsToSet.put(entry.getKey(), (Object)entry.getValue().toArray());
            }
            Document update = new Document("$set", (Object)fieldsToSet);
            UpdateResult result = collection.updateOne((Bson)query, (Bson)update);
            if (result.wasAcknowledged() && result.getMatchedCount() == 0L) {
                System.err.println("Nothing updated for key " + key);
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return 1;
        }
    }

    protected void fillMap(Map<String, ByteIterator> resultMap, Document obj) {
        for (Map.Entry entry : obj.entrySet()) {
            if (!(entry.getValue() instanceof Binary)) continue;
            resultMap.put((String)entry.getKey(), (ByteIterator)new ByteArrayByteIterator(((Binary)entry.getValue()).getData()));
        }
    }

    static {
        INIT_COUNT = new AtomicInteger(0);
    }
}

