/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class AuthInfoProvider {
    static final AuthInfoProvider NONE = new AuthInfoProvider(){

        @Override
        public Map<String, String> getAuthInfo(InetAddress host) {
            return Collections.emptyMap();
        }
    };

    AuthInfoProvider() {
    }

    public abstract Map<String, String> getAuthInfo(InetAddress var1);

    static class Simple
    extends AuthInfoProvider {
        private static final String USERNAME_KEY = "username";
        private static final String PASSWORD_KEY = "password";
        private final Map<String, String> credentials = new HashMap<String, String>(2);

        Simple(String username, String password) {
            this.credentials.put(USERNAME_KEY, username);
            this.credentials.put(PASSWORD_KEY, password);
        }

        @Override
        public Map<String, String> getAuthInfo(InetAddress host) {
            return this.credentials;
        }
    }
}

