/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Codec;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class TableMetadata {
    static final String CF_NAME = "columnfamily_name";
    private static final String KEY_VALIDATOR = "key_validator";
    private static final String COMPARATOR = "comparator";
    private static final String VALIDATOR = "default_validator";
    private static final String KEY_ALIASES = "key_aliases";
    private static final String COLUMN_ALIASES = "column_aliases";
    private static final String VALUE_ALIAS = "value_alias";
    private static final String DEFAULT_KEY_ALIAS = "key";
    private static final String DEFAULT_COLUMN_ALIAS = "column";
    private static final String DEFAULT_VALUE_ALIAS = "value";
    private final KeyspaceMetadata keyspace;
    private final String name;
    private final List<ColumnMetadata> partitionKey;
    private final List<ColumnMetadata> clusteringKey;
    private final Map<String, ColumnMetadata> columns;
    private final Options options;
    private static ObjectMapper jsonMapper = new ObjectMapper(new JsonFactory());

    private TableMetadata(KeyspaceMetadata keyspace, String name, List<ColumnMetadata> partitionKey, List<ColumnMetadata> clusteringKey, LinkedHashMap<String, ColumnMetadata> columns, Options options) {
        this.keyspace = keyspace;
        this.name = name;
        this.partitionKey = partitionKey;
        this.clusteringKey = clusteringKey;
        this.columns = columns;
        this.options = options;
    }

    static String fixTimestampType(String type) {
        return type.replaceAll("org.apache.cassandra.db.marshal.TimestampType", "org.apache.cassandra.db.marshal.DateType");
    }

    static TableMetadata build(KeyspaceMetadata ksm, Row row, boolean hasColumnMetadata) {
        try {
            ColumnMetadata colMeta;
            DataType dt;
            String cn;
            int i;
            int clusteringSize;
            boolean hasValue;
            String name = row.getString(CF_NAME);
            ArrayList<ColumnMetadata> partitionKey = new ArrayList<ColumnMetadata>();
            ArrayList<ColumnMetadata> clusteringKey = new ArrayList<ColumnMetadata>();
            LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
            boolean isCompact = false;
            AbstractType ct = TypeParser.parse((String)TableMetadata.fixTimestampType(row.getString(COMPARATOR)));
            boolean isComposite = ct instanceof CompositeType;
            List columnTypes = isComposite ? ((CompositeType)ct).types : Collections.singletonList(ct);
            List<String> columnAliases = TableMetadata.fromJsonList(row.getString(COLUMN_ALIASES));
            int last = columnTypes.size() - 1;
            AbstractType lastType = (AbstractType)columnTypes.get(last);
            if (isComposite) {
                if (lastType instanceof ColumnToCollectionType || columnAliases.size() == last && lastType instanceof UTF8Type) {
                    hasValue = false;
                    clusteringSize = lastType instanceof ColumnToCollectionType ? last - 1 : last;
                } else {
                    isCompact = true;
                    hasValue = true;
                    clusteringSize = columnTypes.size();
                }
            } else {
                isCompact = true;
                if (!columnAliases.isEmpty() || !hasColumnMetadata) {
                    hasValue = true;
                    clusteringSize = columnTypes.size();
                } else {
                    hasValue = false;
                    clusteringSize = 0;
                }
            }
            TableMetadata tm = new TableMetadata(ksm, name, partitionKey, clusteringKey, columns, new Options(row, isCompact));
            AbstractType kt = TypeParser.parse((String)TableMetadata.fixTimestampType(row.getString(KEY_VALIDATOR)));
            List keyTypes = kt instanceof CompositeType ? ((CompositeType)kt).types : Collections.singletonList(kt);
            List keyAliases = row.getString(KEY_ALIASES) == null ? Collections.emptyList() : TableMetadata.fromJsonList(row.getString(KEY_ALIASES));
            for (i = 0; i < keyTypes.size(); ++i) {
                cn = keyAliases.size() > i ? (String)keyAliases.get(i) : (i == 0 ? DEFAULT_KEY_ALIAS : DEFAULT_KEY_ALIAS + (i + 1));
                dt = Codec.rawTypeToDataType((AbstractType)keyTypes.get(i));
                colMeta = new ColumnMetadata(tm, cn, dt, null);
                columns.put(cn, colMeta);
                partitionKey.add(colMeta);
            }
            for (i = 0; i < clusteringSize; ++i) {
                cn = columnAliases.size() > i ? columnAliases.get(i) : DEFAULT_COLUMN_ALIAS + (i + 1);
                dt = Codec.rawTypeToDataType((AbstractType)columnTypes.get(i));
                colMeta = new ColumnMetadata(tm, cn, dt, null);
                columns.put(cn, colMeta);
                clusteringKey.add(colMeta);
            }
            if (hasValue) {
                AbstractType vt = TypeParser.parse((String)TableMetadata.fixTimestampType(row.getString(VALIDATOR)));
                String valueAlias = row.isNull(KEY_ALIASES) ? DEFAULT_VALUE_ALIAS : row.getString(VALUE_ALIAS);
                ColumnMetadata vm = new ColumnMetadata(tm, valueAlias, Codec.rawTypeToDataType(vt), null);
                columns.put(valueAlias, vm);
            }
            ksm.add(tm);
            return tm;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public ColumnMetadata getColumn(String name) {
        return this.columns.get(name);
    }

    public List<ColumnMetadata> getColumns() {
        return new ArrayList<ColumnMetadata>(this.columns.values());
    }

    public List<ColumnMetadata> getPrimaryKey() {
        ArrayList<ColumnMetadata> pk = new ArrayList<ColumnMetadata>(this.partitionKey.size() + this.clusteringKey.size());
        pk.addAll(this.partitionKey);
        pk.addAll(this.clusteringKey);
        return pk;
    }

    public List<ColumnMetadata> getPartitionKey() {
        return Collections.unmodifiableList(this.partitionKey);
    }

    public List<ColumnMetadata> getClusteringKey() {
        return Collections.unmodifiableList(this.clusteringKey);
    }

    public Options getOptions() {
        return this.options;
    }

    static List<String> fromJsonList(String json) {
        try {
            return (List)jsonMapper.readValue(json, List.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Map<String, String> fromJsonMap(String json) {
        try {
            return (Map)jsonMapper.readValue(json, Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void add(ColumnMetadata column) {
        this.columns.put(column.getName(), column);
    }

    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.asCQLQuery(true));
        for (ColumnMetadata column : this.columns.values()) {
            ColumnMetadata.IndexMetadata index = column.getIndex();
            if (index == null) continue;
            sb.append("\n").append(index.asCQLQuery());
        }
        return sb.toString();
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(this.name).append(" (");
        this.newLine(sb, formatted);
        for (ColumnMetadata cm : this.columns.values()) {
            this.newLine(sb.append(this.spaces(4, formatted)).append(cm).append(","), formatted);
        }
        sb.append(this.spaces(4, formatted)).append("PRIMARY KEY (");
        if (this.partitionKey.size() == 1) {
            sb.append(this.partitionKey.get(0).getName());
        } else {
            sb.append("(");
            boolean first = true;
            for (ColumnMetadata cm : this.partitionKey) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(cm.getName());
            }
            sb.append(")");
        }
        for (ColumnMetadata cm : this.clusteringKey) {
            sb.append(", ").append(cm.getName());
        }
        sb.append(")");
        this.newLine(sb, formatted);
        if (this.options.isCompactStorage) {
            sb.append(") WITH COMPACT STORAGE");
            this.and(sb, formatted).append("read_repair_chance = ").append(this.options.readRepair);
        } else {
            sb.append(") WITH read_repair_chance = ").append(this.options.readRepair);
        }
        this.and(sb, formatted).append("dclocal_read_repair_chance = ").append(this.options.localReadRepair);
        this.and(sb, formatted).append("replicate_on_write = ").append(this.options.replicateOnWrite);
        this.and(sb, formatted).append("gc_grace_seconds = ").append(this.options.gcGrace);
        this.and(sb, formatted).append("bloom_filter_fp_chance = ").append(this.options.bfFpChance);
        this.and(sb, formatted).append("caching = ").append(this.options.caching);
        if (this.options.comment != null) {
            this.and(sb, formatted).append("comment = '").append(this.options.comment).append("'");
        }
        this.and(sb, formatted).append("compaction = ").append(TableMetadata.formatOptionMap(this.options.compaction));
        this.and(sb, formatted).append("compression = ").append(TableMetadata.formatOptionMap(this.options.compression));
        sb.append(";");
        return sb.toString();
    }

    private static String formatOptionMap(Map<String, String> m) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("'").append(entry.getKey()).append("'");
            sb.append(" : ");
            try {
                sb.append(Integer.parseInt(entry.getValue()));
            }
            catch (NumberFormatException e) {
                sb.append("'").append(entry.getValue()).append("'");
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    private StringBuilder and(StringBuilder sb, boolean formatted) {
        return this.newLine(sb, formatted).append(this.spaces(2, formatted)).append(" AND ");
    }

    private String spaces(int n, boolean formatted) {
        if (!formatted) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private StringBuilder newLine(StringBuilder sb, boolean formatted) {
        if (formatted) {
            sb.append('\n');
        }
        return sb;
    }

    public static class Options {
        private static final String COMMENT = "comment";
        private static final String READ_REPAIR = "read_repair_chance";
        private static final String LOCAL_READ_REPAIR = "local_read_repair_chance";
        private static final String REPLICATE_ON_WRITE = "replicate_on_write";
        private static final String GC_GRACE = "gc_grace_seconds";
        private static final String BF_FP_CHANCE = "bloom_filter_fp_chance";
        private static final String CACHING = "caching";
        private static final String COMPACTION_CLASS = "compaction_strategy_class";
        private static final String COMPACTION_OPTIONS = "compaction_strategy_options";
        private static final String MIN_COMPACTION_THRESHOLD = "min_compaction_threshold";
        private static final String MAX_COMPACTION_THRESHOLD = "max_compaction_threshold";
        private static final String POPULATE_CACHE_ON_FLUSH = "populate_io_cache_on_flush";
        private static final String COMPRESSION_PARAMS = "compression_parameters";
        private static final double DEFAULT_BF_FP_CHANCE = 0.01;
        private static final boolean DEFAULT_POPULATE_CACHE_ON_FLUSH = false;
        private final boolean isCompactStorage;
        private final String comment;
        private final double readRepair;
        private final double localReadRepair;
        private final boolean replicateOnWrite;
        private final int gcGrace;
        private final double bfFpChance;
        private final String caching;
        private final boolean populateCacheOnFlush;
        private final Map<String, String> compaction = new HashMap<String, String>();
        private final Map<String, String> compression = new HashMap<String, String>();

        Options(Row row, boolean isCompactStorage) {
            this.isCompactStorage = isCompactStorage;
            this.comment = row.isNull(COMMENT) ? "" : row.getString(COMMENT);
            this.readRepair = row.getDouble(READ_REPAIR);
            this.localReadRepair = row.getDouble(LOCAL_READ_REPAIR);
            this.replicateOnWrite = row.getBool(REPLICATE_ON_WRITE);
            this.gcGrace = row.getInt(GC_GRACE);
            this.bfFpChance = row.isNull(BF_FP_CHANCE) ? 0.01 : row.getDouble(BF_FP_CHANCE);
            this.caching = row.getString(CACHING);
            this.populateCacheOnFlush = row.isNull(POPULATE_CACHE_ON_FLUSH) ? false : row.getBool(POPULATE_CACHE_ON_FLUSH);
            this.compaction.put("class", row.getString(COMPACTION_CLASS));
            this.compaction.putAll(TableMetadata.fromJsonMap(row.getString(COMPACTION_OPTIONS)));
            this.compression.putAll(TableMetadata.fromJsonMap(row.getString(COMPRESSION_PARAMS)));
        }

        public boolean isCompactStorage() {
            return this.isCompactStorage;
        }

        public String getComment() {
            return this.comment;
        }

        public double getReadRepairChance() {
            return this.readRepair;
        }

        public double getLocalReadRepairChance() {
            return this.localReadRepair;
        }

        public boolean getReplicateOnWrite() {
            return this.replicateOnWrite;
        }

        public int getGcGraceInSeconds() {
            return this.gcGrace;
        }

        public double getBloomFilterFalsePositiveChance() {
            return this.bfFpChance;
        }

        public String getCaching() {
            return this.caching;
        }

        public boolean getPopulateIOCacheOnFlush() {
            return this.populateCacheOnFlush;
        }

        public Map<String, String> getCompaction() {
            return new HashMap<String, String>(this.compaction);
        }

        public Map<String, String> getCompression() {
            return new HashMap<String, String>(this.compression);
        }
    }
}

