/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MurmurHash;

abstract class Token<T extends Token<T>>
implements Comparable<T> {
    Token() {
    }

    public static Factory<?> getFactory(String partitionerName) {
        if (partitionerName.endsWith("Murmur3Partitioner")) {
            return M3PToken.FACTORY;
        }
        if (partitionerName.endsWith("RandomPartitioner")) {
            return RPToken.FACTORY;
        }
        if (partitionerName.endsWith("OrderedPartitioner")) {
            return OPPToken.FACTORY;
        }
        return null;
    }

    static class RPToken
    extends Token<RPToken> {
        private final BigInteger value;
        public static final Factory<RPToken> FACTORY = new Factory<RPToken>(){

            @Override
            public RPToken fromString(String tokenStr) {
                return new RPToken(new BigInteger(tokenStr));
            }

            @Override
            public RPToken hash(ByteBuffer partitionKey) {
                return new RPToken(FBUtilities.hashToBigInteger((ByteBuffer)partitionKey));
            }
        };

        private RPToken(BigInteger value) {
            this.value = value;
        }

        @Override
        public int compareTo(RPToken other) {
            return this.value.compareTo(other.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value.equals(((RPToken)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class OPPToken
    extends Token<OPPToken> {
        private final ByteBuffer value;
        public static final Factory<OPPToken> FACTORY = new Factory<OPPToken>(){

            @Override
            public OPPToken fromString(String tokenStr) {
                return new OPPToken(ByteBufferUtil.bytes((String)tokenStr));
            }

            @Override
            public OPPToken hash(ByteBuffer partitionKey) {
                return new OPPToken(partitionKey);
            }
        };

        private OPPToken(ByteBuffer value) {
            this.value = value;
        }

        @Override
        public int compareTo(OPPToken other) {
            return this.value.compareTo(other.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value.equals(((OPPToken)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class M3PToken
    extends Token<M3PToken> {
        private final long value;
        public static final Factory<M3PToken> FACTORY = new Factory<M3PToken>(){

            @Override
            public M3PToken fromString(String tokenStr) {
                return new M3PToken(Long.parseLong(tokenStr));
            }

            @Override
            public M3PToken hash(ByteBuffer partitionKey) {
                long v = MurmurHash.hash3_x64_128((ByteBuffer)partitionKey, (int)partitionKey.position(), (int)partitionKey.remaining(), (long)0L)[0];
                return new M3PToken(v == Long.MIN_VALUE ? Long.MAX_VALUE : v);
            }
        };

        private M3PToken(long value) {
            this.value = value;
        }

        @Override
        public int compareTo(M3PToken other) {
            long otherValue = other.value;
            return this.value < otherValue ? -1 : (this.value == otherValue ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value == ((M3PToken)obj).value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static interface Factory<T extends Token<T>> {
        public T fromString(String var1);

        public T hash(ByteBuffer var1);
    }
}

