/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.concur.lock.OAdaptiveLock;
import com.orientechnologies.common.concur.lock.OLock;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.listener.OListenerManger;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.OrientShutdownHook;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseFactory;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseThreadLocalFactory;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.engine.local.OEngineLocal;
import com.orientechnologies.orient.core.engine.local.OEngineLocalPaginated;
import com.orientechnologies.orient.core.engine.memory.OEngineMemory;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.record.ORecordFactoryManager;
import com.orientechnologies.orient.core.storage.OClusterFactory;
import com.orientechnologies.orient.core.storage.ODefaultClusterFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Orient
extends OListenerManger<OOrientListener> {
    public static final String ORIENTDB_HOME = "ORIENTDB_HOME";
    public static final String URL_SYNTAX = "<engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*";
    protected static final Orient instance = new Orient();
    protected static boolean registerDatabaseByPath = false;
    protected final Map<String, OEngine> engines = new HashMap<String, OEngine>();
    protected final Map<String, OStorage> storages = new HashMap<String, OStorage>();
    protected final Map<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY> dbLifecycleListeners = new LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY>();
    protected final ODatabaseFactory databaseFactory = new ODatabaseFactory();
    protected final OScriptManager scriptManager = new OScriptManager();
    protected final Timer timer = new Timer(true);
    protected final ThreadGroup threadGroup = new ThreadGroup("OrientDB");
    protected final AtomicInteger serialId = new AtomicInteger();
    protected OClusterFactory clusterFactory = new ODefaultClusterFactory();
    protected ORecordFactoryManager recordFactoryManager = new ORecordFactoryManager();
    protected OrientShutdownHook shutdownHook;
    protected OMemoryWatchDog memoryWatchDog;
    protected OProfilerMBean profiler = new OProfiler();
    protected ODatabaseThreadLocalFactory databaseThreadFactory;
    protected volatile boolean active = false;
    protected ThreadPoolExecutor workers;

    protected Orient() {
        super((OLock)new OAdaptiveLock(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean()));
        this.startup();
    }

    public static Orient instance() {
        return instance;
    }

    public static String getHomePath() {
        String v = System.getProperty("orient.home");
        if (v == null) {
            v = System.getProperty(ORIENTDB_HOME);
        }
        if (v == null) {
            v = System.getenv(ORIENTDB_HOME);
        }
        return OFileUtils.getPath((String)v);
    }

    public static String getTempPath() {
        return OFileUtils.getPath((String)(System.getProperty("java.io.tmpdir") + "/orientdb/"));
    }

    public static boolean isRegisterDatabaseByPath() {
        return registerDatabaseByPath;
    }

    public static void setRegisterDatabaseByPath(boolean iValue) {
        registerDatabaseByPath = iValue;
    }

    public Orient startup() {
        this.getLock().lock();
        try {
            if (this.active) {
                Orient orient = this;
                return orient;
            }
            this.shutdownHook = new OrientShutdownHook();
            int cores = Runtime.getRuntime().availableProcessors();
            this.workers = new ThreadPoolExecutor(cores, cores * 3, 10L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(cores * 500){

                @Override
                public boolean offer(Runnable e) {
                    try {
                        this.put(e);
                        return true;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
            });
            this.registerEngine(new OEngineLocal());
            this.registerEngine(new OEngineLocalPaginated());
            this.registerEngine(new OEngineMemory());
            this.registerEngine("com.orientechnologies.orient.client.remote.OEngineRemote");
            if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean()) {
                this.profiler.startRecording();
            }
            if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
                OGlobalConfiguration.dumpConfiguration(System.out);
            }
            this.memoryWatchDog = new OMemoryWatchDog();
            this.active = true;
            Orient orient = this;
            return orient;
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Orient shutdown() {
        this.getLock().lock();
        try {
            if (!this.active) {
                Orient orient = this;
                return orient;
            }
            this.active = false;
            this.workers.shutdown();
            OLogManager.instance().debug((Object)this, "Orient Engine is shutting down...", new Object[0]);
            for (OOrientListener l : this.browseListeners()) {
                if (l == null) continue;
                l.onShutdown();
            }
            this.closeAllStorages();
            for (OEngine engine : this.engines.values()) {
                engine.shutdown();
            }
            this.engines.clear();
            if (this.databaseFactory != null) {
                this.databaseFactory.shutdown();
            }
            if (this.shutdownHook != null) {
                this.shutdownHook.cancel();
                this.shutdownHook = null;
            }
            if (this.threadGroup != null) {
                this.threadGroup.interrupt();
            }
            this.resetListeners();
            this.timer.purge();
            this.profiler.shutdown();
            if (this.memoryWatchDog != null) {
                this.memoryWatchDog.sendShutdown();
                try {
                    this.memoryWatchDog.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.memoryWatchDog = null;
                }
            }
            OLogManager.instance().info((Object)this, "OrientDB Engine shutdown complete", new Object[0]);
            OLogManager.instance().flush();
        }
        finally {
            this.getLock().unlock();
        }
        return this;
    }

    public void closeAllStorages() {
        if (this.storages != null) {
            ArrayList<OStorage> storagesCopy = new ArrayList<OStorage>(this.storages.values());
            for (OStorage stg : storagesCopy) {
                try {
                    OLogManager.instance().info((Object)this, "- storage: " + stg.getName() + "...", new Object[0]);
                    stg.close(true, false);
                }
                catch (Throwable e) {
                    OLogManager.instance().warn((Object)this, "-- error on closing storage", e, new Object[0]);
                }
            }
            this.storages.clear();
        }
    }

    public ThreadPoolExecutor getWorkers() {
        return this.workers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage loadStorage(String iURL) {
        int pos;
        if (iURL == null || iURL.length() == 0) {
            throw new IllegalArgumentException("URL missed");
        }
        if (iURL.endsWith("/")) {
            iURL = iURL.substring(0, iURL.length() - 1);
        }
        if ((pos = (iURL = iURL.replace("//", "/")).indexOf(58)) <= 0) {
            throw new OConfigurationException("Error in database URL: the engine was not specified. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
        }
        String engineName = iURL.substring(0, pos);
        this.getLock().lock();
        try {
            OStorage storage;
            String dbName;
            OEngine engine = this.engines.get(engineName.toLowerCase());
            if (engine == null) {
                throw new OConfigurationException("Error on opening database: the engine '" + engineName + "' was not found. URL was: " + iURL + ". Registered engines are: " + this.engines.keySet());
            }
            iURL = iURL.substring(pos + 1);
            pos = iURL.indexOf(63);
            HashMap<String, String> parameters = null;
            String dbPath = null;
            if (pos > 0) {
                dbPath = iURL.substring(0, pos);
                iURL = iURL.substring(pos + 1);
                parameters = new HashMap<String, String>();
                String[] pairs = iURL.split("&");
                for (String pair : pairs) {
                    String[] kv = pair.split("=");
                    if (kv.length < 2) {
                        throw new OConfigurationException("Error on opening database: parameter has no value. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
                    }
                    parameters.put(kv[0], kv[1]);
                }
            } else {
                dbPath = iURL;
            }
            String string = dbName = registerDatabaseByPath ? dbPath : OIOUtils.getRelativePathIfAny((String)dbPath, null);
            if (engine.isShared()) {
                storage = this.storages.get(dbName);
                if (storage == null) {
                    storage = engine.createStorage(dbPath, parameters);
                    this.storages.put(dbName, storage);
                }
            } else {
                storage = engine.createStorage(dbPath, parameters);
                this.storages.put(dbName + "__" + this.serialId.incrementAndGet(), storage);
            }
            for (OOrientListener l : this.browseListeners()) {
                l.onStorageRegistered(storage);
            }
            OStorage oStorage = storage;
            return oStorage;
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage registerStorage(OStorage iStorage) throws IOException {
        this.getLock().lock();
        try {
            for (OOrientListener l : this.browseListeners()) {
                l.onStorageRegistered(iStorage);
            }
            if (!this.storages.containsKey(iStorage.getName())) {
                this.storages.put(iStorage.getName(), iStorage);
            }
        }
        finally {
            this.getLock().unlock();
        }
        return iStorage;
    }

    public OStorage getStorage(String iDbName) {
        this.getLock().lock();
        try {
            OStorage oStorage = this.storages.get(iDbName);
            return oStorage;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void registerEngine(OEngine iEngine) {
        this.getLock().lock();
        try {
            this.engines.put(iEngine.getName(), iEngine);
        }
        finally {
            this.getLock().unlock();
        }
    }

    public OEngine getEngine(String iEngineName) {
        this.getLock().lock();
        try {
            OEngine oEngine = this.engines.get(iEngineName);
            return oEngine;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public Set<String> getEngines() {
        this.getLock().lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.engines.keySet());
            return set;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void unregisterStorageByName(String iName) {
        String dbName = registerDatabaseByPath ? iName : OIOUtils.getRelativePathIfAny((String)iName, null);
        OStorage stg = this.storages.get(dbName);
        this.unregisterStorage(stg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStorage(OStorage iStorage) {
        if (!this.active) {
            return;
        }
        if (iStorage == null) {
            return;
        }
        this.getLock().lock();
        try {
            Iterable listenerCopy = this.getListenersCopy();
            for (OOrientListener l : listenerCopy) {
                this.unregisterListener(l);
                l.onStorageUnregistered(iStorage);
            }
            ArrayList<String> storagesToRemove = new ArrayList<String>();
            for (Map.Entry<String, OStorage> s : this.storages.entrySet()) {
                if (!s.getValue().equals(iStorage)) continue;
                storagesToRemove.add(s.getKey());
            }
            for (String dbName : storagesToRemove) {
                this.storages.remove(dbName);
            }
        }
        finally {
            this.getLock().unlock();
        }
    }

    public Collection<OStorage> getStorages() {
        this.getLock().lock();
        try {
            ArrayList<OStorage> arrayList = new ArrayList<OStorage>(this.storages.values());
            return arrayList;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    public Iterator<ODatabaseLifecycleListener> getDbLifecycleListeners() {
        return this.dbLifecycleListeners.keySet().iterator();
    }

    public void addDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY> tmp = new LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY>(this.dbLifecycleListeners);
        tmp.put(iListener, iListener.getPriority());
        this.dbLifecycleListeners.clear();
        for (ODatabaseLifecycleListener.PRIORITY p : ODatabaseLifecycleListener.PRIORITY.values()) {
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.dbLifecycleListeners.put((ODatabaseLifecycleListener)e.getKey(), (ODatabaseLifecycleListener.PRIORITY)((Object)e.getValue()));
            }
        }
    }

    public void removeDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.remove(iListener);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ODatabaseThreadLocalFactory getDatabaseThreadFactory() {
        return this.databaseThreadFactory;
    }

    public OMemoryWatchDog getMemoryWatchDog() {
        return this.memoryWatchDog;
    }

    public ORecordFactoryManager getRecordFactoryManager() {
        return this.recordFactoryManager;
    }

    public void setRecordFactoryManager(ORecordFactoryManager iRecordFactoryManager) {
        this.recordFactoryManager = iRecordFactoryManager;
    }

    public OClusterFactory getClusterFactory() {
        return this.clusterFactory;
    }

    public void setClusterFactory(OClusterFactory clusterFactory) {
        this.clusterFactory = clusterFactory;
    }

    public ODatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    public OProfilerMBean getProfiler() {
        return this.profiler;
    }

    public void setProfiler(OProfilerMBean iProfiler) {
        this.profiler = iProfiler;
    }

    public void registerThreadDatabaseFactory(ODatabaseThreadLocalFactory iDatabaseFactory) {
        this.databaseThreadFactory = iDatabaseFactory;
    }

    public OScriptManager getScriptManager() {
        return this.scriptManager;
    }

    private void registerEngine(String iClassName) {
        try {
            Class<?> cls = Class.forName(iClassName);
            this.registerEngine((OEngine)cls.newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

