/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCache;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.HashSet;

public abstract class OAbstractRecordCache {
    protected OCache underlying;
    protected String profilerPrefix = "noname";
    protected String profilerMetadataPrefix = "noname";
    protected int excludedCluster = -1;

    public OAbstractRecordCache(OCache impl) {
        this.underlying = impl;
    }

    public boolean isEnabled() {
        return this.underlying.isEnabled();
    }

    public void setEnable(boolean enable) {
        if (enable) {
            this.underlying.enable();
        } else {
            this.underlying.disable();
        }
    }

    public ORecordInternal<?> freeRecord(ORID rid) {
        return this.underlying.remove(rid);
    }

    public void freeCluster(int cid) {
        HashSet<ORID> toRemove = new HashSet<ORID>(this.underlying.size() / 2);
        HashSet<ORID> keys = new HashSet<ORID>(this.underlying.keys());
        for (ORID id : keys) {
            if (id.getClusterId() != cid) continue;
            toRemove.add(id);
        }
        for (ORID ridToRemove : toRemove) {
            this.underlying.remove(ridToRemove);
        }
    }

    public void deleteRecord(ORID rid) {
        this.underlying.remove(rid);
    }

    public void clear() {
        this.underlying.clear();
    }

    public int getSize() {
        return this.underlying.size();
    }

    public int getMaxSize() {
        return this.underlying.limit();
    }

    public void startup() {
        this.underlying.startup();
        Orient.instance().getProfiler().registerHookValue(this.profilerPrefix + "enabled", "Cache enabled", OProfilerMBean.METRIC_TYPE.ENABLED, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OAbstractRecordCache.this.isEnabled();
            }
        }, this.profilerMetadataPrefix + "enabled");
        Orient.instance().getProfiler().registerHookValue(this.profilerPrefix + "current", "Number of entries in cache", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OAbstractRecordCache.this.getSize();
            }
        }, this.profilerMetadataPrefix + "current");
        Orient.instance().getProfiler().registerHookValue(this.profilerPrefix + "max", "Maximum number of entries in cache", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OAbstractRecordCache.this.getMaxSize();
            }
        }, this.profilerMetadataPrefix + "max");
    }

    public void shutdown() {
        this.underlying.shutdown();
        if (Orient.instance().getProfiler() != null) {
            Orient.instance().getProfiler().unregisterHookValue(this.profilerPrefix + "enabled");
            Orient.instance().getProfiler().unregisterHookValue(this.profilerPrefix + "current");
            Orient.instance().getProfiler().unregisterHookValue(this.profilerPrefix + "max");
        }
    }
}

