/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.collection.OLimitedMap;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OAbstractMapCache;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Map;

public class ODefaultCache
extends OAbstractMapCache<OLinkedHashMapCache> {
    private static final int DEFAULT_LIMIT = 1000;
    protected final int limit;
    protected OMemoryWatchDog.Listener lowMemoryListener;

    public ODefaultCache(String iName, int initialLimit) {
        super(new OLinkedHashMapCache(initialLimit > 0 ? initialLimit : 1000, 0.75f, initialLimit));
        this.limit = initialLimit;
    }

    @Override
    public void startup() {
        this.lowMemoryListener = Orient.instance().getMemoryWatchDog().addListener(new OLowMemoryListener());
        super.startup();
    }

    @Override
    public void shutdown() {
        Orient.instance().getMemoryWatchDog().removeListener(this.lowMemoryListener);
        super.shutdown();
    }

    private void removeEldest(int threshold) {
        this.lock.acquireExclusiveLock();
        try {
            ((OLinkedHashMapCache)((Object)this.cache)).removeEldest(threshold);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public ORecordInternal<?> get(ORID id) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)((OLinkedHashMapCache)((Object)this.cache)).get(id);
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public ORecordInternal<?> put(ORecordInternal<?> record) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)((OLinkedHashMapCache)((Object)this.cache)).put(record.getIdentity(), record);
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public ORecordInternal<?> remove(ORID id) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)((OLinkedHashMapCache)((Object)this.cache)).remove(id);
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    class OLowMemoryListener
    implements OMemoryWatchDog.Listener {
        OLowMemoryListener() {
        }

        @Override
        public void lowMemory(long freeMemory, long freeMemoryPercentage) {
            try {
                int oldSize = ODefaultCache.this.size();
                if (oldSize == 0) {
                    return;
                }
                if (freeMemoryPercentage < 10L) {
                    OLogManager.instance().warn((Object)this, "Low free heap memory (%d%%): clearing %d cached records", new Object[]{freeMemoryPercentage, ODefaultCache.this.size()});
                    ODefaultCache.this.removeEldest(oldSize);
                } else {
                    int newSize = (int)((float)oldSize * 0.9f);
                    ODefaultCache.this.removeEldest(oldSize - newSize);
                    OLogManager.instance().warn((Object)this, "Low free heap memory (%d%%): reducing cached records number from %d to %d", new Object[]{freeMemoryPercentage, oldSize, newSize});
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error occurred during default cache cleanup", (Throwable)e, new Object[0]);
            }
        }
    }

    static final class OLinkedHashMapCache
    extends OLimitedMap<ORID, ORecordInternal<?>> {
        public OLinkedHashMapCache(int initialCapacity, float loadFactor, int limit) {
            super(initialCapacity, loadFactor, limit);
        }

        void removeEldest(int amount) {
            ORID[] victims = new ORID[amount];
            int skip = this.size() - amount;
            int skipped = 0;
            int selected = 0;
            for (Map.Entry entry : this.entrySet()) {
                if (((ORecordInternal)entry.getValue()).isDirty() || ((ORecordInternal)entry.getValue()).isPinned() == Boolean.TRUE || skipped++ < skip) continue;
                victims[selected++] = (ORID)entry.getKey();
            }
            for (ORID id : victims) {
                this.remove(id);
            }
        }
    }
}

