/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OAbstractRecordCache;
import com.orientechnologies.orient.core.cache.OCacheLevelOneLocator;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;

public class OLevel1RecordCache
extends OAbstractRecordCache {
    private OLevel2RecordCache secondary = null;
    private String CACHE_HIT;
    private String CACHE_MISS;

    public OLevel1RecordCache(OCacheLevelOneLocator cacheLocator) {
        super(cacheLocator.threadLocalCache());
    }

    @Override
    public void startup() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
        this.secondary = db.getLevel2Cache();
        this.profilerPrefix = "db." + db.getName() + ".cache.level1.";
        this.profilerMetadataPrefix = "db.*.cache.level1.";
        this.CACHE_HIT = this.profilerPrefix + "cache.found";
        this.CACHE_MISS = this.profilerPrefix + "cache.notFound";
        this.excludedCluster = db.getClusterIdByName("index");
        super.startup();
        this.setEnable(OGlobalConfiguration.CACHE_LEVEL1_ENABLED.getValueAsBoolean());
    }

    public void updateRecord(ORecordInternal<?> record) {
        if (this.isEnabled() && record.getIdentity().getClusterId() != this.excludedCluster && record.getIdentity().isValid() && !record.getRecordVersion().isTombstone()) {
            this.underlying.lock(record.getIdentity());
            try {
                if (this.underlying.get(record.getIdentity()) != record) {
                    this.underlying.put(record);
                }
            }
            finally {
                this.underlying.unlock(record.getIdentity());
            }
        }
        if (record.getIdentity().getClusterId() != this.excludedCluster) {
            this.secondary.updateRecord(record);
        }
    }

    public ORecordInternal<?> findRecord(ORID rid) {
        ORecordInternal<?> record;
        if (!this.isEnabled()) {
            if (rid.getClusterId() != this.excludedCluster) {
                return this.secondary.retrieveRecord(rid);
            }
            return null;
        }
        this.underlying.lock(rid);
        try {
            record = this.underlying.get(rid);
            if (record == null && (record = this.secondary.retrieveRecord(rid)) != null) {
                this.underlying.put(record);
            }
        }
        finally {
            this.underlying.unlock(rid);
        }
        if (record != null) {
            Orient.instance().getProfiler().updateCounter(this.CACHE_HIT, "Record found in Level1 Cache", 1L, "db.*.cache.level1.cache.found");
        } else {
            Orient.instance().getProfiler().updateCounter(this.CACHE_MISS, "Record not found in Level1 Cache", 1L, "db.*.cache.level1.cache.notFound");
        }
        return record;
    }

    @Override
    public void deleteRecord(ORID rid) {
        super.deleteRecord(rid);
        this.secondary.freeRecord(rid);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.secondary = null;
    }

    @Override
    public void clear() {
        this.moveRecordsToSecondaryCache();
        super.clear();
    }

    private void moveRecordsToSecondaryCache() {
        if (this.secondary == null) {
            return;
        }
        for (ORID rid : this.underlying.keys()) {
            this.secondary.updateRecord(this.underlying.get(rid));
        }
    }

    public void invalidate() {
        this.underlying.clear();
    }

    public String toString() {
        return "DB level1 cache records = " + this.getSize() + ", maxSize= " + this.getMaxSize();
    }
}

