/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.metadata.security.ORole;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OCommandExecutorAbstract
extends OBaseParser
implements OCommandExecutor {
    protected OProgressListener progressListener;
    protected int limit = -1;
    protected Map<Object, Object> parameters;
    protected OCommandContext context;

    public static ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    public OCommandExecutorAbstract init(OCommandRequestText iRequest) {
        OCommandExecutorAbstract.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.parserText = iRequest.getText().trim();
        this.parserTextUpperCase = this.parserText.toUpperCase(Locale.ENGLISH);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [text=" + this.parserText + "]";
    }

    public OProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public <RET extends OCommandExecutor> RET setProgressListener(OProgressListener progressListener) {
        this.progressListener = progressListener;
        return (RET)this;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public <RET extends OCommandExecutor> RET setLimit(int iLimit) {
        this.limit = iLimit;
        return (RET)this;
    }

    @Override
    public Map<Object, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getFetchPlan() {
        return null;
    }

    @Override
    public OCommandContext getContext() {
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        return this.context;
    }

    @Override
    public void setContext(OCommandContext iContext) {
        this.context = iContext;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        return Collections.EMPTY_SET;
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_READ;
    }
}

