/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.util.ArrayDeque;

public class OTraversePath {
    private static final OTraversePath EMPTY_PATH = new OTraversePath(new FirstPathItem());
    private final PathItem lastPathItem;

    private OTraversePath(PathItem lastPathItem) {
        this.lastPathItem = lastPathItem;
    }

    public String toString() {
        ArrayDeque<PathItem> stack = new ArrayDeque<PathItem>();
        PathItem currentItem = this.lastPathItem;
        while (currentItem != null) {
            stack.push(currentItem);
            currentItem = currentItem.parentItem;
        }
        StringBuilder buf = new StringBuilder();
        for (PathItem pathItem : stack) {
            buf.append(pathItem.toString());
        }
        return buf.toString();
    }

    public OTraversePath append(OIdentifiable record) {
        return new OTraversePath(new RecordPathItem(record, this.lastPathItem));
    }

    public OTraversePath appendField(String fieldName) {
        return new OTraversePath(new FieldPathItem(fieldName, this.lastPathItem));
    }

    public OTraversePath appendIndex(int index) {
        return new OTraversePath(new CollectionPathItem(index, this.lastPathItem));
    }

    public OTraversePath appendRecordSet() {
        return this;
    }

    public int getDepth() {
        return this.lastPathItem.depth;
    }

    public static OTraversePath empty() {
        return EMPTY_PATH;
    }

    private static class FirstPathItem
    extends PathItem {
        private FirstPathItem() {
            super(null, -1);
        }

        public String toString() {
            return "";
        }
    }

    private static class CollectionPathItem
    extends PathItem {
        private final int index;

        private CollectionPathItem(int index, PathItem parentItem) {
            super(parentItem, parentItem.depth);
            this.index = index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }
    }

    private static class FieldPathItem
    extends PathItem {
        private final String name;

        private FieldPathItem(String name, PathItem parentItem) {
            super(parentItem, parentItem.depth);
            this.name = name;
        }

        public String toString() {
            return "." + this.name;
        }
    }

    private static class RecordPathItem
    extends PathItem {
        private final OIdentifiable record;

        private RecordPathItem(OIdentifiable record, PathItem parentItem) {
            super(parentItem, parentItem.depth + 1);
            this.record = record;
        }

        public String toString() {
            return "(" + this.record.getIdentity().toString() + ")";
        }
    }

    private static abstract class PathItem {
        protected final PathItem parentItem;
        protected final int depth;

        private PathItem(PathItem parentItem, int depth) {
            this.parentItem = parentItem;
            this.depth = depth;
        }
    }
}

