/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.command.traverse.OTraversePath;
import com.orientechnologies.orient.core.command.traverse.OTraverseRecordProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.Iterator;

public class OTraverseRecordSetProcess
extends OTraverseAbstractProcess<Iterator<OIdentifiable>> {
    private final OTraversePath path;
    protected OIdentifiable record;
    protected int index = -1;

    public OTraverseRecordSetProcess(OTraverse iCommand, Iterator<OIdentifiable> iTarget, OTraversePath parentPath) {
        super(iCommand, iTarget);
        this.path = parentPath.appendRecordSet();
        ((OTraverse)this.command).getContext().push(this);
    }

    @Override
    public OIdentifiable process() {
        while (((Iterator)this.target).hasNext()) {
            this.record = (OIdentifiable)((Iterator)this.target).next();
            ++this.index;
            Object rec = this.record.getRecord();
            if (!(rec instanceof ODocument)) continue;
            ODocument doc = (ODocument)rec;
            if (!doc.getIdentity().isPersistent() && doc.fields() == 1) {
                Object fieldvalue = doc.field(doc.fieldNames()[0]);
                if (fieldvalue instanceof Collection) {
                    ((OTraverse)this.command).getContext().push(new OTraverseRecordSetProcess((OTraverse)this.command, ((Collection)fieldvalue).iterator(), this.getPath()));
                } else if (fieldvalue instanceof ODocument) {
                    ((OTraverse)this.command).getContext().push(new OTraverseRecordProcess((OTraverse)this.command, (ODocument)rec, this.getPath()));
                }
            } else {
                ((OTraverse)this.command).getContext().push(new OTraverseRecordProcess((OTraverse)this.command, (ODocument)rec, this.getPath()));
            }
            return null;
        }
        return this.drop();
    }

    @Override
    public OTraversePath getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return this.target != null ? ((Iterator)this.target).toString() : "-";
    }
}

