/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class ODatabaseRecordThreadLocal
extends ThreadLocal<ODatabaseRecord> {
    public static ODatabaseRecordThreadLocal INSTANCE = new ODatabaseRecordThreadLocal();

    @Override
    public ODatabaseRecord get() {
        ODatabaseRecord db = (ODatabaseRecord)super.get();
        if (db == null) {
            if (Orient.instance().getDatabaseThreadFactory() == null) {
                throw new ODatabaseException("Database instance is not set in current thread. Assure to set it with: ODatabaseRecordThreadLocal.INSTANCE.set(db);");
            }
            db = Orient.instance().getDatabaseThreadFactory().getThreadDatabase();
            if (db == null) {
                throw new ODatabaseException("Database instance is not set in current thread. Assure to set it with: ODatabaseRecordThreadLocal.INSTANCE.set(db);");
            }
            this.set(db);
        }
        return db;
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    public void set(ODatabaseRecord value) {
        super.set(value);
    }

    public ODatabaseRecord getIfDefined() {
        return (ODatabaseRecord)super.get();
    }

    public boolean isDefined() {
        return super.get() != null;
    }
}

