/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptDocumentDatabaseWrapper;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.command.script.OScriptOrientWrapper;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.lang.reflect.Method;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class OClassTrigger
extends ODocumentHookAbstract {
    public static final String CLASSNAME = "OTriggered";
    public static final String METHOD_SEPARATOR = ".";
    public static final String ONBEFORE_CREATED = "onBeforeCreate";
    public static final String PROP_BEFORE_CREATE = "onBeforeCreate";
    public static final String ONAFTER_CREATED = "onAfterCreate";
    public static final String PROP_AFTER_CREATE = "onAfterCreate";
    public static final String ONBEFORE_READ = "onBeforeRead";
    public static final String PROP_BEFORE_READ = "onBeforeRead";
    public static final String ONAFTER_READ = "onAfterRead";
    public static final String PROP_AFTER_READ = "onAfterRead";
    public static final String ONBEFORE_UPDATED = "onBeforeUpdate";
    public static final String PROP_BEFORE_UPDATE = "onBeforeUpdate";
    public static final String ONAFTER_UPDATED = "onAfterUpdate";
    public static final String PROP_AFTER_UPDATE = "onAfterUpdate";
    public static final String ONBEFORE_DELETE = "onBeforeDelete";
    public static final String PROP_BEFORE_DELETE = "onBeforeDelete";
    public static final String ONAFTER_DELETE = "onAfterDelete";
    public static final String PROP_AFTER_DELETE = "onAfterDelete";

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.SOURCE_NODE;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        Object func = this.checkClzAttribute(iDocument, "onBeforeCreate");
        if (func != null) {
            if (func instanceof OFunction) {
                return this.executeFunction(iDocument, (OFunction)func);
            }
            if (func instanceof Object[]) {
                return this.executeMethod(iDocument, (Object[])func);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        Object func = this.checkClzAttribute(iDocument, "onAfterCreate");
        if (func != null) {
            if (func instanceof OFunction) {
                this.executeFunction(iDocument, (OFunction)func);
            } else if (func instanceof Object[]) {
                this.executeMethod(iDocument, (Object[])func);
            }
        }
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeRead(ODocument iDocument) {
        Object func = this.checkClzAttribute(iDocument, "onBeforeRead");
        if (func != null) {
            if (func instanceof OFunction) {
                return this.executeFunction(iDocument, (OFunction)func);
            }
            if (func instanceof Object[]) {
                return this.executeMethod(iDocument, (Object[])func);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterRead(ODocument iDocument) {
        Object func = this.checkClzAttribute(iDocument, "onAfterRead");
        if (func != null) {
            if (func instanceof OFunction) {
                this.executeFunction(iDocument, (OFunction)func);
            } else if (func instanceof Object[]) {
                this.executeMethod(iDocument, (Object[])func);
            }
        }
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        Object func = this.checkClzAttribute(iDocument, "onBeforeUpdate");
        if (func != null) {
            if (func instanceof OFunction) {
                return this.executeFunction(iDocument, (OFunction)func);
            }
            if (func instanceof Object[]) {
                return this.executeMethod(iDocument, (Object[])func);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        Object func = this.checkClzAttribute(iDocument, "onAfterUpdate");
        if (func != null) {
            if (func instanceof OFunction) {
                this.executeFunction(iDocument, (OFunction)func);
            } else if (func instanceof Object[]) {
                this.executeMethod(iDocument, (Object[])func);
            }
        }
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        Object func = this.checkClzAttribute(iDocument, "onBeforeDelete");
        if (func != null) {
            if (func instanceof OFunction) {
                return this.executeFunction(iDocument, (OFunction)func);
            }
            if (func instanceof Object[]) {
                return this.executeMethod(iDocument, (Object[])func);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterDelete(ODocument iDocument) {
        Object func = this.checkClzAttribute(iDocument, "onAfterDelete");
        if (func != null) {
            if (func instanceof OFunction) {
                this.executeFunction(iDocument, (OFunction)func);
            } else if (func instanceof Object[]) {
                this.executeMethod(iDocument, (Object[])func);
            }
        }
    }

    @Override
    public ORecordHook.RESULT onTrigger(ORecordHook.TYPE iType, ORecord<?> iRecord) {
        if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && ODatabaseRecordThreadLocal.INSTANCE.get().getStatus() != ODatabase.STATUS.OPEN) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        if (!(iRecord instanceof ODocument)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        ODocument document = (ODocument)iRecord;
        if (document.getSchemaClass() != null && document.getSchemaClass().isSubClassOf(CLASSNAME)) {
            return super.onTrigger(iType, iRecord);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    private Object checkClzAttribute(ODocument iDocument, String attr) {
        OClass clz = iDocument.getSchemaClass();
        if (clz != null && clz.isSubClassOf(CLASSNAME)) {
            OFunction func = null;
            String fieldName = ((OClassImpl)clz).getCustom(attr);
            for (OClass superClz = clz.getSuperClass(); !(fieldName != null && fieldName.length() != 0 || superClz == null || superClz.getName().equals(CLASSNAME)); superClz = superClz.getSuperClass()) {
                fieldName = ((OClassImpl)superClz).getCustom(attr);
            }
            if (fieldName != null && fieldName.length() > 0) {
                Object[] clzMethod = this.checkMethod(fieldName);
                if (clzMethod != null) {
                    return clzMethod;
                }
                func = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getFunctionLibrary().getFunction(fieldName);
                if (func == null && OStringSerializerHelper.contains(fieldName, ':')) {
                    try {
                        ODocument funcDoc = (ODocument)ODatabaseRecordThreadLocal.INSTANCE.get().load(new ORecordId(fieldName));
                        if (funcDoc != null) {
                            func = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getFunctionLibrary().getFunction((String)funcDoc.field("name"));
                        }
                    }
                    catch (Exception ex) {
                        OLogManager.instance().error((Object)this, "illegal record id : ", new Object[]{ex.getMessage()});
                    }
                }
            } else {
                Object funcProp = iDocument.field(attr);
                if (funcProp != null) {
                    String funcName = funcProp instanceof ODocument ? (String)((ODocument)funcProp).field("name") : funcProp.toString();
                    func = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getFunctionLibrary().getFunction(funcName);
                }
            }
            return func;
        }
        return null;
    }

    private Object[] checkMethod(String fieldName) {
        String clzName = null;
        String methodName = null;
        if (fieldName.contains(METHOD_SEPARATOR)) {
            clzName = fieldName.substring(0, fieldName.lastIndexOf(METHOD_SEPARATOR));
            methodName = fieldName.substring(fieldName.lastIndexOf(METHOD_SEPARATOR) + 1);
        }
        if (clzName == null || methodName == null) {
            return null;
        }
        try {
            Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(clzName);
            Method method = clz.getMethod(methodName, ODocument.class);
            return new Object[]{clz, method};
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "illegal class or method : " + clzName + "/" + methodName, new Object[0]);
            return null;
        }
    }

    private ORecordHook.RESULT executeMethod(ODocument iDocument, Object[] clzMethod) {
        if (clzMethod[0] instanceof Class && clzMethod[1] instanceof Method) {
            Method method = (Method)clzMethod[1];
            Class clz = (Class)clzMethod[0];
            String result = null;
            try {
                result = (String)method.invoke(clz.newInstance(), iDocument);
            }
            catch (Exception ex) {
                throw new OException("Failed to invoke method " + method.getName(), (Throwable)ex);
            }
            if (result == null) {
                return ORecordHook.RESULT.RECORD_NOT_CHANGED;
            }
            return ORecordHook.RESULT.valueOf(result);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    private ORecordHook.RESULT executeFunction(ODocument iDocument, OFunction func) {
        if (func == null) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !(db instanceof ODatabaseRecordTx)) {
            db = (ODatabaseRecord)db.getUnderlying();
        }
        OScriptManager scriptManager = Orient.instance().getScriptManager();
        ScriptEngine scriptEngine = scriptManager.getEngine(func.getLanguage());
        Bindings binding = scriptEngine.getBindings(100);
        for (OScriptInjection i : scriptManager.getInjections()) {
            i.bind(binding);
        }
        binding.put("doc", (Object)iDocument);
        if (db != null) {
            binding.put("db", (Object)new OScriptDocumentDatabaseWrapper((ODatabaseRecordTx)db));
            binding.put("orient", (Object)new OScriptOrientWrapper(db));
        } else {
            binding.put("orient", (Object)new OScriptOrientWrapper());
        }
        String result = null;
        try {
            if (func.getLanguage() == null) {
                throw new OConfigurationException("Database function '" + func.getName() + "' has no language");
            }
            String funcStr = scriptManager.getFunctionDefinition(func);
            if (funcStr != null) {
                try {
                    scriptEngine.eval(funcStr);
                }
                catch (ScriptException e) {
                    scriptManager.getErrorMessage(e, funcStr);
                }
            }
            if (scriptEngine instanceof Invocable) {
                Invocable invocableEngine = (Invocable)((Object)scriptEngine);
                Object[] EMPTY = new Object[]{};
                result = (String)invocableEngine.invokeFunction(func.getName(), EMPTY);
            }
        }
        catch (ScriptException e) {
            throw new OCommandScriptException("Error on execution of the script", func.getName(), e.getColumnNumber(), e);
        }
        catch (NoSuchMethodException e) {
            throw new OCommandScriptException("Error on execution of the script", func.getName(), 0, e);
        }
        catch (OCommandScriptException e) {
            throw e;
        }
        finally {
            scriptManager.unbind(binding);
        }
        if (result == null) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        return ORecordHook.RESULT.valueOf(result);
    }
}

