/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCacheLevelOneLocatorImpl;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODataSegmentStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.ODefaultDataSegmentStrategy;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.OClassTrigger;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.ORidBagDeleteHook;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerProxy;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.OHookThreadLocal;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.function.OFunctionTrigger;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORestrictedAccessHook;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.OUserTrigger;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAwareAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OSchedulerTrigger;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;

public abstract class ODatabaseRecordAbstract
extends ODatabaseWrapperAbstract<ODatabaseRaw>
implements ODatabaseRecord {
    private static final String DEF_RECORD_FORMAT = "csv";
    private final Map<ORecordHook, ORecordHook.HOOK_POSITION> unmodifiableHooks;
    protected ORecordSerializer serializer;
    private OSBTreeCollectionManager sbTreeCollectionManager;
    private OMetadataDefault metadata;
    private OUser user;
    private byte recordType;
    private String recordFormat;
    private Map<ORecordHook, ORecordHook.HOOK_POSITION> hooks = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>();
    private boolean retainRecords = true;
    private OLevel1RecordCache level1Cache;
    private boolean mvcc;
    private boolean validation;
    private ODataSegmentStrategy dataSegmentStrategy = new ODefaultDataSegmentStrategy();
    private OCurrentStorageComponentsFactory componentsFactory;

    public ODatabaseRecordAbstract(String iURL, byte iRecordType) {
        super(new ODatabaseRaw(iURL));
        this.setCurrentDatabaseinThreadLocal();
        ((ODatabaseRaw)this.underlying).setOwner(this);
        this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
        this.databaseOwner = this;
        this.recordType = iRecordType;
        this.level1Cache = new OLevel1RecordCache(new OCacheLevelOneLocatorImpl());
        this.mvcc = OGlobalConfiguration.DB_MVCC.getValueAsBoolean();
        this.validation = OGlobalConfiguration.DB_VALIDATION.getValueAsBoolean();
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        this.setCurrentDatabaseinThreadLocal();
        try {
            super.open(iUserName, iUserPassword);
            this.componentsFactory = this.getStorage().getComponentsFactory();
            OSBTreeCollectionManager sbTreeCM = (OSBTreeCollectionManager)this.getStorage().getResource(OSBTreeCollectionManager.class.getSimpleName(), new Callable<OSBTreeCollectionManager>(){

                @Override
                public OSBTreeCollectionManager call() throws Exception {
                    Class<? extends OSBTreeCollectionManager> managerClass = ODatabaseRecordAbstract.this.getStorage().getCollectionManagerClass();
                    if (managerClass == null) {
                        OLogManager.instance().warn((Object)this, "Current implementation of storage does not support sbtree collections", new Object[0]);
                        return null;
                    }
                    return managerClass.newInstance();
                }
            });
            this.sbTreeCollectionManager = sbTreeCM != null ? new OSBTreeCollectionManagerProxy(this, sbTreeCM) : null;
            this.level1Cache.startup();
            this.metadata = new OMetadataDefault();
            this.metadata.load();
            this.recordFormat = DEF_RECORD_FORMAT;
            if (!(this.getStorage() instanceof OStorageProxy)) {
                if (this.metadata.getIndexManager().autoRecreateIndexesAfterCrash()) {
                    this.metadata.getIndexManager().recreateIndexes();
                    this.setCurrentDatabaseinThreadLocal();
                    this.user = null;
                }
                this.installHooks();
                this.user = this.metadata.getSecurity().authenticate(iUserName, iUserPassword);
            } else {
                this.user = new OUser(iUserName, OUser.encryptPassword(iUserPassword)).addRole(new ORole("passthrough", null, ORole.ALLOW_MODES.ALLOW_ALL_BUT));
            }
            this.checkSecurity("database", ORole.PERMISSION_READ);
            if (!this.metadata.getSchema().existsClass("ORIDs")) {
                this.metadata.getSchema().createClass("ORIDs");
            }
            this.callOnOpenListeners();
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new ODatabaseException("Cannot open database", e);
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create() {
        this.setCurrentDatabaseinThreadLocal();
        try {
            super.create();
            this.componentsFactory = this.getStorage().getComponentsFactory();
            this.sbTreeCollectionManager = new OSBTreeCollectionManagerProxy(this, (OSBTreeCollectionManager)this.getStorage().getResource(OSBTreeCollectionManager.class.getSimpleName(), new Callable<OSBTreeCollectionManager>(){

                @Override
                public OSBTreeCollectionManager call() throws Exception {
                    Class<? extends OSBTreeCollectionManager> managerClass = ODatabaseRecordAbstract.this.getStorage().getCollectionManagerClass();
                    if (managerClass == null) {
                        OLogManager.instance().warn((Object)this, "Current implementation of storage does not support sbtree collections", new Object[0]);
                        return null;
                    }
                    return managerClass.newInstance();
                }
            }));
            this.level1Cache.startup();
            this.getStorage().getConfiguration().update();
            if (!(this.getStorage() instanceof OStorageProxy)) {
                this.installHooks();
            }
            this.metadata = new OMetadataDefault();
            this.metadata.create();
            this.user = this.getMetadata().getSecurity().getUser("admin");
            if (!this.metadata.getSchema().existsClass("ORIDs")) {
                this.metadata.getSchema().createClass("ORIDs");
            }
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreate(this.getDatabaseOwner());
            }
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
                try {
                    listener.onCreate(this.underlying);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot create database", e);
        }
        return (DB)this;
    }

    @Override
    public OBinarySerializerFactory getSerializerFactory() {
        return this.componentsFactory.binarySerializerFactory;
    }

    @Override
    public OCurrentStorageComponentsFactory getStorageVersions() {
        return this.componentsFactory;
    }

    @Override
    public void drop() {
        this.checkOpeness();
        this.checkSecurity("database", ORole.PERMISSION_DELETE);
        this.setCurrentDatabaseinThreadLocal();
        this.callOnCloseListeners();
        if (this.metadata != null) {
            this.metadata.close();
            this.metadata = null;
        }
        super.drop();
    }

    @Override
    public void close() {
        this.setCurrentDatabaseinThreadLocal();
        this.callOnCloseListeners();
        for (ORecordHook h : this.hooks.keySet()) {
            h.onUnregister();
        }
        this.hooks.clear();
        if (this.metadata != null) {
            OIndexManagerProxy indexManager;
            if (!(this.getStorage() instanceof OStorageProxy) && (indexManager = this.metadata.getIndexManager()) != null) {
                indexManager.waitTillIndexRestore();
            }
            if (this.metadata != null) {
                this.metadata.close();
                this.metadata = null;
            }
        }
        super.close();
        this.user = null;
        this.level1Cache.shutdown();
        ODatabaseRecordThreadLocal.INSTANCE.remove();
    }

    @Override
    public ODictionary<ORecordInternal<?>> getDictionary() {
        this.checkOpeness();
        return this.metadata.getIndexManager().getDictionary();
    }

    @Override
    public <RET extends ORecordInternal<?>> RET getRecord(OIdentifiable iIdentifiable) {
        if (iIdentifiable instanceof ORecord) {
            return (RET)((ORecordInternal)iIdentifiable);
        }
        return (RET)this.load(iIdentifiable.getIdentity());
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord) {
        return this.load(iRecord, (String)null);
    }

    @Override
    public void reload() {
        this.metadata.reload();
        super.reload();
    }

    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, null, true, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, true, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId) {
        return this.executeReadRecord((ORecordId)iRecordId, null, null, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent) {
        return this.executeSaveRecord(iContent, null, iContent.getRecordVersion(), true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, null, null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return this.executeSaveRecord(iContent, null, iContent.getRecordVersion(), true, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName) {
        return this.executeSaveRecord(iContent, iClusterName, iContent.getRecordVersion(), true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, null, null);
    }

    @Override
    public ORecordSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ORecordSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public boolean updatedReplica(ORecordInternal<?> record) {
        return this.executeUpdateReplica(record);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return this.executeSaveRecord(iContent, iClusterName, iContent.getRecordVersion(), true, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> delete(ORID iRecord) {
        this.executeDeleteRecord(iRecord, OVersionFactory.instance().createUntrackedVersion(), true, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false);
        return this;
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> delete(ORID iRecord, ORecordVersion iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false);
        return this;
    }

    @Override
    public boolean hide(ORID rid) {
        return this.executeHideRecord(rid, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS);
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> cleanOutRecord(ORID iRecord, ORecordVersion iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, true);
        return this;
    }

    public ODatabaseRecord delete(ORID iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        this.executeDeleteRecord(iRecord, OVersionFactory.instance().createUntrackedVersion(), true, true, iMode, false);
        return this;
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> delete(ORecordInternal<?> iRecord) {
        this.executeDeleteRecord(iRecord, OVersionFactory.instance().createUntrackedVersion(), true, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false);
        return this;
    }

    public ODatabaseRecord delete(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        this.executeDeleteRecord(iRecord, OVersionFactory.instance().createUntrackedVersion(), true, true, iMode, false);
        return this;
    }

    @Override
    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iClass) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, true);
    }

    @Override
    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, OClusterPosition startClusterPosition, OClusterPosition endClusterPosition, boolean loadTombstones) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, startClusterPosition, endClusterPosition, true, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, OClusterPosition startClusterPosition, OClusterPosition endClusterPosition, boolean loadTombstones) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, startClusterPosition, endClusterPosition, true, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    public ORecordIteratorCluster<?> browseCluster(String iClusterName) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, true);
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.setCurrentDatabaseinThreadLocal();
        OCommandRequestInternal command = (OCommandRequestInternal)iCommand;
        try {
            command.reset();
            return command;
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on command execution", e);
        }
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<?> iCommand, Object ... iArgs) {
        this.setCurrentDatabaseinThreadLocal();
        iCommand.reset();
        return (RET)((List)iCommand.execute(iArgs));
    }

    @Override
    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public <RET> RET newInstance() {
        return (RET)Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        return this.countClusterElements(iClusterIds, false);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        return this.countClusterElements(iClusterId, false);
    }

    @Override
    public long countClusterElements(int iClusterId, boolean countTombstones) {
        String name = this.getClusterNameById(iClusterId);
        if (name == null) {
            return 0L;
        }
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)name);
        this.setCurrentDatabaseinThreadLocal();
        return super.countClusterElements(iClusterId, countTombstones);
    }

    @Override
    public long countClusterElements(int[] iClusterIds, boolean countTombstones) {
        for (int iClusterId : iClusterIds) {
            String name = this.getClusterNameById(iClusterId);
            this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)name);
        }
        return super.countClusterElements(iClusterIds, countTombstones);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        return super.countClusterElements(iClusterName);
    }

    @Override
    public OMetadataDefault getMetadata() {
        this.checkOpeness();
        return this.metadata;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResource, int iOperation) {
        if (this.user != null) {
            try {
                this.user.allow(iResource, iOperation);
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', operation '%s'", new Object[]{this.getUser(), iResource, iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        if (this.user != null) {
            try {
                StringBuilder keyBuffer = new StringBuilder();
                boolean ruleFound = false;
                for (Object target : iResourcesSpecific) {
                    if (target == null) continue;
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append(target.toString());
                    String key = keyBuffer.toString();
                    if (!this.user.isRuleDefined(key)) continue;
                    ruleFound = true;
                    this.user.allow(key, iOperation);
                }
                if (!ruleFound) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append("*");
                    this.user.allow(keyBuffer.toString(), iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target(s) '%s', operation '%s'", new Object[]{this.getUser(), iResourceGeneric, Arrays.toString(iResourcesSpecific), iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        if (this.user != null) {
            try {
                StringBuilder keyBuffer = new StringBuilder();
                boolean ruleFound = false;
                if (iResourceSpecific != null) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append(iResourceSpecific.toString());
                    String key = keyBuffer.toString();
                    if (this.user.isRuleDefined(key)) {
                        ruleFound = true;
                        this.user.allow(key, iOperation);
                    }
                }
                if (!ruleFound) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append("*");
                    this.user.allow(keyBuffer.toString(), iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target '%s', operation '%s'", new Object[]{this.getUser(), iResourceGeneric, iResourceSpecific, iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    public <RET extends ORecordInternal<?>> RET executeReadRecord(ORecordId rid, ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpeness();
        try {
            this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)this.getClusterNameById(rid.getClusterId()));
            ORecordInternal<?> record = this.getTransaction().getRecord(rid);
            if (record == OTransactionRealAbstract.DELETED_RECORD) {
                return null;
            }
            if (record == null && !iIgnoreCache) {
                record = this.getLevel1Cache().findRecord(rid);
            }
            if (record != null) {
                if (iRecord != null) {
                    iRecord.fromStream(record.toStream());
                    iRecord.getRecordVersion().copyFrom(record.getRecordVersion());
                    record = iRecord;
                }
                OFetchHelper.checkFetchPlanValid(iFetchPlan);
                if (this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, record) == ORecordHook.RESULT.SKIP) {
                    return null;
                }
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                if (iLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK) {
                    record.lock(false);
                } else if (iLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
                    record.lock(true);
                }
                this.callbackHooks(ORecordHook.TYPE.AFTER_READ, record);
                return (RET)record;
            }
            ORawBuffer recordBuffer = ((ODatabaseRaw)this.underlying).read(rid, iFetchPlan, iIgnoreCache, loadTombstones, iLockingStrategy).getResult();
            if (recordBuffer == null) {
                return null;
            }
            if (iRecord == null || iRecord.getRecordType() != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(recordBuffer.recordType);
            }
            iRecord.fill(rid, recordBuffer.version, recordBuffer.buffer, false);
            if (iRecord.getRecordVersion().isTombstone()) {
                return (RET)iRecord;
            }
            if (this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, iRecord) == ORecordHook.RESULT.SKIP) {
                return null;
            }
            iRecord.fromStream(recordBuffer.buffer);
            this.callbackHooks(ORecordHook.TYPE.AFTER_READ, iRecord);
            if (!iIgnoreCache) {
                this.getLevel1Cache().updateRecord(iRecord);
            }
            return (RET)iRecord;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on retrieving record " + rid, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <RET extends ORecordInternal<?>> RET executeSaveRecord(ORecordInternal<?> record, String iClusterName, ORecordVersion iVersion, boolean iCallTriggers, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        this.checkOpeness();
        if (!record.isDirty()) {
            return (RET)record;
        }
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        this.setCurrentDatabaseinThreadLocal();
        HashSet lockedIndexes = new HashSet();
        record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
        try {
            OStorageOperationResult<ORecordVersion> operationResult;
            byte[] stream;
            block34: {
                boolean wasNew;
                if (record instanceof ODocument) {
                    this.acquireIndexModificationLock((ODocument)record, lockedIndexes);
                }
                boolean bl = wasNew = iForceCreate || rid.isNew();
                if (wasNew && rid.clusterId == -1) {
                    rid.clusterId = iClusterName != null ? this.getClusterIdByName(iClusterName) : this.getDefaultClusterId();
                }
                ORecordSerializationContext.pushContext();
                try {
                    Object triggerType;
                    boolean isNew;
                    stream = record.toStream();
                    boolean bl2 = isNew = iForceCreate || rid.isNew();
                    if (isNew) {
                        record.onBeforeIdentityChanged(rid);
                    } else if (stream == null || stream.length == 0) {
                        ORecordInternal<?> oRecordInternal = record;
                        return (RET)oRecordInternal;
                    }
                    if (isNew && rid.clusterId < 0) {
                        int n = rid.clusterId = iClusterName != null ? this.getClusterIdByName(iClusterName) : this.getDefaultClusterId();
                    }
                    if (rid.clusterId > -1 && iClusterName == null) {
                        iClusterName = this.getClusterNameById(rid.clusterId);
                    }
                    this.checkRecordClass(record, iClusterName, rid, isNew);
                    int permission = wasNew ? ORole.PERMISSION_CREATE : ORole.PERMISSION_UPDATE;
                    this.checkSecurity("database.cluster", permission, (Object)iClusterName);
                    if (stream != null && stream.length > 0 && iCallTriggers) {
                        triggerType = wasNew ? ORecordHook.TYPE.BEFORE_CREATE : ORecordHook.TYPE.BEFORE_UPDATE;
                        ORecordHook.RESULT hookResult = this.callbackHooks((ORecordHook.TYPE)((Object)triggerType), record);
                        if (hookResult == ORecordHook.RESULT.RECORD_CHANGED) {
                            stream = this.updateStream(record);
                        } else if (hookResult == ORecordHook.RESULT.SKIP_IO) {
                            ORecordInternal<?> oRecordInternal = record;
                            return (RET)oRecordInternal;
                        }
                    }
                    if (!record.isDirty()) {
                        triggerType = record;
                        return (RET)triggerType;
                    }
                    ORecordVersion realVersion = !this.mvcc || iVersion.isUntracked() ? OVersionFactory.instance().createUntrackedVersion() : record.getRecordVersion();
                    int dataSegmentId = this.dataSegmentStrategy.assignDataSegmentId(this, record);
                    try {
                        operationResult = ((ODatabaseRaw)this.underlying).save(dataSegmentId, rid, stream == null ? new byte[]{} : stream, realVersion, record.getRecordType(), iMode.ordinal(), iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
                        ORecordVersion version = operationResult.getResult();
                        if (isNew) {
                            ((ORecordId)record.getIdentity()).copyFrom(rid);
                            record.onAfterIdentityChanged(record);
                        }
                        record.fill(rid, version, stream, stream == null || stream.length == 0);
                        if (!iCallTriggers || stream == null || stream.length <= 0) break block34;
                        if (!operationResult.isMoved()) {
                            this.callbackHooks(wasNew ? ORecordHook.TYPE.AFTER_CREATE : ORecordHook.TYPE.AFTER_UPDATE, record);
                        } else {
                            this.callbackHooks(wasNew ? ORecordHook.TYPE.CREATE_REPLICATED : ORecordHook.TYPE.UPDATE_REPLICATED, record);
                        }
                    }
                    catch (Throwable t) {
                        if (!iCallTriggers) throw t;
                        if (stream == null) throw t;
                        if (stream.length <= 0) throw t;
                        this.callbackHooks(wasNew ? ORecordHook.TYPE.CREATE_FAILED : ORecordHook.TYPE.UPDATE_FAILED, record);
                        throw t;
                    }
                }
                finally {
                    ORecordSerializationContext.pullContext();
                }
            }
            if (stream == null) return (RET)record;
            if (stream.length <= 0) return (RET)record;
            if (operationResult.isMoved()) return (RET)record;
            this.getLevel1Cache().updateRecord(record);
            return (RET)record;
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on saving record in cluster #" + record.getIdentity().getClusterId(), t);
        }
        finally {
            this.releaseIndexModificationLock(lockedIndexes);
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    public boolean executeUpdateReplica(ORecordInternal<?> record) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        if (rid.isNew()) {
            throw new ODatabaseException("Passed in record was not saved and can not be treated as replica");
        }
        return this.callInRecordLock(new ExecuteReplicaUpdateCallable(record), rid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDeleteRecord(OIdentifiable record, ORecordVersion iVersion, boolean iRequired, boolean iCallTriggers, ODatabaseComplex.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        if ((record = record.getRecord()) == null) {
            return;
        }
        this.checkSecurity("database.cluster", ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.clusterId));
        HashSet lockedIndexes = new HashSet();
        this.setCurrentDatabaseinThreadLocal();
        ORecordSerializationContext.pushContext();
        try {
            if (record instanceof ODocument) {
                this.acquireIndexModificationLock((ODocument)record, lockedIndexes);
            }
            try {
                OStorageOperationResult<Boolean> operationResult;
                Object rec = record.getRecord();
                if (iCallTriggers && rec != null) {
                    this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, (OIdentifiable)rec);
                }
                ORecordVersion realVersion = this.mvcc ? iVersion : OVersionFactory.instance().createUntrackedVersion();
                try {
                    operationResult = prohibitTombstones ? new OStorageOperationResult<Boolean>(((ODatabaseRaw)this.underlying).cleanOutRecord(rid, realVersion, iRequired, (byte)iMode.ordinal())) : ((ODatabaseRaw)this.underlying).delete(rid, realVersion, iRequired, (byte)iMode.ordinal());
                    if (iCallTriggers) {
                        if (!operationResult.isMoved() && rec != null) {
                            this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, (OIdentifiable)rec);
                        } else if (rec != null) {
                            this.callbackHooks(ORecordHook.TYPE.DELETE_REPLICATED, (OIdentifiable)rec);
                        }
                    }
                }
                catch (Throwable t) {
                    if (iCallTriggers) {
                        this.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, (OIdentifiable)rec);
                    }
                    throw t;
                }
                if (!operationResult.isMoved()) {
                    this.getLevel1Cache().deleteRecord(rid);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ODatabaseException("Error on deleting record in cluster #" + record.getIdentity().getClusterId(), t);
            }
        }
        finally {
            this.releaseIndexModificationLock(lockedIndexes);
            ORecordSerializationContext.pullContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeHideRecord(OIdentifiable record, ODatabaseComplex.OPERATION_MODE iMode) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot hide record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return false;
        }
        this.checkSecurity("database.cluster", ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.clusterId));
        this.setCurrentDatabaseinThreadLocal();
        ORecordSerializationContext.pushContext();
        try {
            OStorageOperationResult<Boolean> operationResult = ((ODatabaseRaw)this.underlying).hide(rid, (byte)iMode.ordinal());
            if (!operationResult.isMoved()) {
                this.getLevel1Cache().deleteRecord(rid);
            }
            boolean bl = operationResult.getResult();
            return bl;
        }
        finally {
            ORecordSerializationContext.pullContext();
        }
    }

    @Override
    public ODatabaseComplex<?> getDatabaseOwner() {
        ODatabaseComplex<?> current;
        for (current = this.databaseOwner; current != null && current != this && current.getDatabaseOwner() != current; current = current.getDatabaseOwner()) {
        }
        return current;
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> setDatabaseOwner(ODatabaseComplex<?> iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public boolean isRetainRecords() {
        return this.retainRecords;
    }

    @Override
    public ODatabaseRecord setRetainRecords(boolean retainRecords) {
        this.retainRecords = retainRecords;
        return this;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        String cmd = String.format("alter database status %s", status.toString());
        this.command(new OCommandSQL(cmd)).execute(new Object[0]);
        return (DB)this;
    }

    public void setStatusInternal(ODatabase.STATUS status) {
        ((ODatabaseRaw)this.underlying).setStatus(status);
    }

    public void setDefaultClusterIdInternal(int iDefClusterId) {
        this.getStorage().setDefaultClusterId(iDefClusterId);
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        ((ODatabaseRaw)this.underlying).set(iAttribute, iValue);
    }

    @Override
    public OUser getUser() {
        return this.user;
    }

    @Override
    public void setUser(OUser user) {
        this.user = user;
    }

    @Override
    public boolean isMVCC() {
        return this.mvcc;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB setMVCC(boolean mvcc) {
        this.mvcc = mvcc;
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION> tmp = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>(this.hooks);
        tmp.put(iHookImpl, iPosition);
        this.hooks.clear();
        for (ORecordHook.HOOK_POSITION p : ORecordHook.HOOK_POSITION.values()) {
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.hooks.put((ORecordHook)e.getKey(), (ORecordHook.HOOK_POSITION)((Object)e.getValue()));
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB registerHook(ORecordHook iHookImpl) {
        return this.registerHook(iHookImpl, ORecordHook.HOOK_POSITION.REGULAR);
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB unregisterHook(ORecordHook iHookImpl) {
        if (iHookImpl != null) {
            iHookImpl.onUnregister();
            this.hooks.remove(iHookImpl);
        }
        return (DB)this;
    }

    @Override
    public OSBTreeCollectionManager getSbTreeCollectionManager() {
        return this.sbTreeCollectionManager;
    }

    @Override
    public OLevel1RecordCache getLevel1Cache() {
        return this.level1Cache;
    }

    @Override
    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks() {
        return this.unmodifiableHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE iType, OIdentifiable id) {
        if (id == null || !OHookThreadLocal.INSTANCE.push(id)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        try {
            Object rec = id.getRecord();
            if (rec == null) {
                ORecordHook.RESULT rESULT = ORecordHook.RESULT.RECORD_NOT_CHANGED;
                return rESULT;
            }
            OScenarioThreadLocal.RUN_MODE runMode = OScenarioThreadLocal.INSTANCE.get();
            boolean recordChanged = false;
            block10: for (ORecordHook hook : this.hooks.keySet()) {
                switch (runMode) {
                    case DEFAULT: {
                        if (!this.getStorage().isDistributed() || hook.getDistributedExecutionMode() != ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE) break;
                        continue block10;
                    }
                    case RUNNING_DISTRIBUTED: {
                        if (hook.getDistributedExecutionMode() != ORecordHook.DISTRIBUTED_EXECUTION_MODE.SOURCE_NODE) break;
                        continue block10;
                    }
                }
                ORecordHook.RESULT res = hook.onTrigger(iType, (ORecord<?>)rec);
                if (res == ORecordHook.RESULT.RECORD_CHANGED) {
                    recordChanged = true;
                    continue;
                }
                if (res == ORecordHook.RESULT.SKIP_IO) {
                    ORecordHook.RESULT rESULT = res;
                    return rESULT;
                }
                if (res != ORecordHook.RESULT.SKIP) continue;
                ORecordHook.RESULT rESULT = res;
                return rESULT;
            }
            Object object = recordChanged ? ORecordHook.RESULT.RECORD_CHANGED : ORecordHook.RESULT.RECORD_NOT_CHANGED;
            return object;
        }
        finally {
            OHookThreadLocal.INSTANCE.pop(id);
        }
    }

    @Override
    public boolean isValidationEnabled() {
        return !this.getStatus().equals((Object)ODatabase.STATUS.IMPORTING) && this.validation;
    }

    @Override
    public <DB extends ODatabaseRecord> DB setValidationEnabled(boolean iEnabled) {
        this.validation = iEnabled;
        return (DB)this;
    }

    @Override
    public ODataSegmentStrategy getDataSegmentStrategy() {
        return this.dataSegmentStrategy;
    }

    @Override
    public void setDataSegmentStrategy(ODataSegmentStrategy dataSegmentStrategy) {
        this.dataSegmentStrategy = dataSegmentStrategy;
    }

    public void callOnOpenListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onOpen(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListenersCopy()) {
            try {
                listener.onOpen(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void callOnCloseListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onClose(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListenersCopy()) {
            try {
                listener.onClose(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected ORecordSerializer resolveFormat(Object iObject) {
        return ORecordSerializerFactory.instance().getFormatForObject(iObject, this.recordFormat);
    }

    @Override
    protected void checkOpeness() {
        if (this.isClosed()) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }

    protected void setCurrentDatabaseinThreadLocal() {
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
    }

    protected void installHooks() {
        this.registerHook(new OClassTrigger(), ORecordHook.HOOK_POSITION.FIRST);
        this.registerHook(new ORestrictedAccessHook(), ORecordHook.HOOK_POSITION.FIRST);
        this.registerHook(new OUserTrigger(), ORecordHook.HOOK_POSITION.EARLY);
        this.registerHook(new OFunctionTrigger(), ORecordHook.HOOK_POSITION.REGULAR);
        this.registerHook(new OClassIndexManager(), ORecordHook.HOOK_POSITION.LAST);
        this.registerHook(new OSchedulerTrigger(), ORecordHook.HOOK_POSITION.LAST);
        this.registerHook(new ORidBagDeleteHook(), ORecordHook.HOOK_POSITION.LAST);
    }

    private void checkRecordClass(ORecordInternal<?> record, String iClusterName, ORecordId rid, boolean isNew) {
        if (rid.clusterId > -1 && this.getStorageVersions().classesAreDetectedByClusterId() && isNew && record instanceof ORecordSchemaAwareAbstract) {
            ORecordSchemaAwareAbstract recordSchemaAware = (ORecordSchemaAwareAbstract)record;
            OClass recordClass = recordSchemaAware.getSchemaClass();
            OClass clusterIdClass = this.metadata.getSchema().getClassByClusterId(rid.clusterId);
            if (recordClass == null && clusterIdClass != null || clusterIdClass == null && recordClass != null || recordClass != null && !recordClass.equals(clusterIdClass)) {
                throw new OSchemaException("Record saved into cluster " + iClusterName + " should be saved with class " + clusterIdClass + " but saved with class " + recordClass);
            }
        }
    }

    private byte[] updateStream(ORecordInternal<?> record) {
        record.unsetDirty();
        record.setDirty();
        ORecordSerializationContext.pullContext();
        ORecordSerializationContext.pushContext();
        byte[] stream = record.toStream();
        return stream;
    }

    private void releaseIndexModificationLock(Set<OIndex<?>> lockedIndexes) {
        OMetadataDefault metadata = this.getMetadata();
        if (metadata == null) {
            return;
        }
        OIndexManagerProxy indexManager = metadata.getIndexManager();
        if (indexManager == null) {
            return;
        }
        for (OIndex<?> index : lockedIndexes) {
            index.getInternal().releaseModificationLock();
        }
    }

    private void acquireIndexModificationLock(ODocument doc, Set<OIndex<?>> lockedIndexes) {
        Set<OIndex<?>> indexes;
        OClass cls;
        if (this.getStorage().getUnderlying() instanceof OStorageEmbedded && (cls = doc.getSchemaClass()) != null && (indexes = cls.getIndexes()) != null) {
            TreeSet indexesToLock = new TreeSet(new Comparator<OIndex<?>>(){

                @Override
                public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
                    return indexOne.getName().compareTo(indexTwo.getName());
                }
            });
            indexesToLock.addAll(indexes);
            for (OIndex oIndex : indexesToLock) {
                oIndex.getInternal().acquireModificationLock();
                lockedIndexes.add(oIndex);
            }
        }
    }

    private class ExecuteReplicaUpdateCallable
    implements Callable<Boolean> {
        private final ORecordId rid;
        private final ORecordInternal<?> record;

        public ExecuteReplicaUpdateCallable(ORecordInternal<?> record) {
            this.rid = (ORecordId)record.getIdentity();
            this.record = record;
        }

        @Override
        public Boolean call() throws Exception {
            boolean result;
            ORecordMetadata loadedRecordMetadata = ODatabaseRecordAbstract.this.getRecordMetadata(this.rid);
            if (loadedRecordMetadata == null) {
                result = this.processReplicaAdd();
            } else if (loadedRecordMetadata.getRecordVersion().compareTo(this.record.getRecordVersion()) < 0) {
                result = this.processReplicaUpdate(loadedRecordMetadata);
            } else {
                return false;
            }
            if (!result) {
                throw new IllegalStateException("Passed in replica was not stored in DB");
            }
            return true;
        }

        private boolean processReplicaUpdate(ORecordMetadata loadedRecordMetadata) throws Exception {
            boolean result;
            Object replicaToUpdate = this.record;
            ORecordVersion replicaVersion = this.record.getRecordVersion();
            byte recordType = this.record.getRecordType();
            try {
                if (loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    replicaToUpdate = this.mergeWithRecord(null);
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.BEFORE_REPLICA_ADD, (OIdentifiable)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    replicaToUpdate = this.mergeWithRecord(this.rid);
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.BEFORE_REPLICA_UPDATE, (OIdentifiable)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone()) {
                    replicaToUpdate = ODatabaseRecordAbstract.this.load(this.rid, "*:0", false, true, OStorage.LOCKING_STRATEGY.DEFAULT);
                    replicaToUpdate.getRecordVersion().copyFrom(replicaVersion);
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.BEFORE_REPLICA_DELETE, (OIdentifiable)replicaToUpdate);
                }
                byte[] stream = replicaToUpdate.toStream();
                int dataSegmentId = ODatabaseRecordAbstract.this.dataSegmentStrategy.assignDataSegmentId(ODatabaseRecordAbstract.this, (ORecord<?>)replicaToUpdate);
                result = ((ODatabaseRaw)ODatabaseRecordAbstract.this.underlying).updateReplica(dataSegmentId, this.rid, stream, replicaVersion, recordType);
                if (loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_ADD, (OIdentifiable)replicaToUpdate);
                    replicaToUpdate.unsetDirty();
                    ODatabaseRecordAbstract.this.getLevel1Cache().updateRecord((ORecordInternal<?>)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_UPDATE, (OIdentifiable)replicaToUpdate);
                    replicaToUpdate.unsetDirty();
                    ODatabaseRecordAbstract.this.getLevel1Cache().updateRecord((ORecordInternal<?>)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_DELETE, (OIdentifiable)replicaToUpdate);
                    replicaToUpdate.unsetDirty();
                    ODatabaseRecordAbstract.this.getLevel1Cache().deleteRecord(this.rid);
                }
            }
            catch (Exception e) {
                if (loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.REPLICA_ADD_FAILED, (OIdentifiable)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.REPLICA_UPDATE_FAILED, (OIdentifiable)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.REPLICA_DELETE_FAILED, (OIdentifiable)replicaToUpdate);
                }
                throw e;
            }
            return result;
        }

        private boolean processReplicaAdd() throws Exception {
            boolean result;
            ORecordInternal replicaToAdd = this.record;
            ORecordVersion replicaVersion = this.record.getRecordVersion();
            try {
                if (!replicaVersion.isTombstone()) {
                    replicaToAdd = this.mergeWithRecord(null);
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.BEFORE_REPLICA_ADD, replicaToAdd);
                } else {
                    replicaToAdd = (ORecordInternal)this.record.copy();
                }
                byte[] stream = replicaToAdd.toStream();
                int dataSegmentId = ODatabaseRecordAbstract.this.dataSegmentStrategy.assignDataSegmentId(ODatabaseRecordAbstract.this, replicaToAdd);
                result = ((ODatabaseRaw)ODatabaseRecordAbstract.this.underlying).updateReplica(dataSegmentId, this.rid, stream, replicaVersion, replicaToAdd.getRecordType());
                if (!replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_ADD, replicaToAdd);
                    replicaToAdd.unsetDirty();
                    ODatabaseRecordAbstract.this.getLevel1Cache().updateRecord(replicaToAdd);
                }
            }
            catch (Exception e) {
                if (!replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_ADD, replicaToAdd);
                }
                throw e;
            }
            return result;
        }

        private ORecordInternal<?> mergeWithRecord(ORID rid) {
            Object replicaToAdd;
            if (this.record instanceof ODocument) {
                replicaToAdd = rid == null ? new ODocument() : ODatabaseRecordAbstract.this.load(rid, "*:0", false, true, OStorage.LOCKING_STRATEGY.DEFAULT);
                ((ODocument)replicaToAdd).merge((ODocument)this.record, false, false);
                replicaToAdd.getRecordVersion().copyFrom(this.record.getRecordVersion());
                replicaToAdd.setIdentity(this.rid);
            } else {
                replicaToAdd = (ORecordInternal)this.record.copy();
            }
            return replicaToAdd;
        }
    }
}

