/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OPlaceholder
implements OIdentifiable,
Externalizable {
    private ORecordId rid;
    private ORecordVersion recordVersion;

    public OPlaceholder() {
    }

    public OPlaceholder(ORecordId rid, ORecordVersion version) {
        this.rid = rid;
        this.recordVersion = version;
    }

    public OPlaceholder(ORecord<?> iRecord) {
        this.rid = (ORecordId)iRecord.getIdentity().copy();
        this.recordVersion = iRecord.getRecordVersion().copy();
    }

    @Override
    public ORID getIdentity() {
        return this.rid;
    }

    @Override
    public <T extends ORecord<?>> T getRecord() {
        return this.rid.getRecord();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OPlaceholder)) {
            return false;
        }
        OPlaceholder other = (OPlaceholder)obj;
        return this.rid.equals(other.rid) && this.recordVersion.equals(other.recordVersion);
    }

    public int hashCode() {
        return this.rid.hashCode() + this.recordVersion.hashCode();
    }

    @Override
    public int compareTo(OIdentifiable o) {
        return this.rid.compareTo(o);
    }

    @Override
    public int compare(OIdentifiable o1, OIdentifiable o2) {
        return this.rid.compare(o1, o2);
    }

    public ORecordVersion getRecordVersion() {
        return this.recordVersion;
    }

    public String toString() {
        return this.rid.toString() + " v." + this.recordVersion.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rid);
        out.writeObject(this.recordVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = (ORecordId)in.readObject();
        this.recordVersion = (ORecordVersion)in.readObject();
    }

    @Override
    public void lock(boolean iExclusive) {
        ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().lockRecord(this, iExclusive ? OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK : OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK);
    }

    @Override
    public void unlock() {
        ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().unlockRecord(this);
    }
}

