/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.version.OVersionFactory;

public class ORecordOperation
implements OSerializableStream {
    private static final long serialVersionUID = 1L;
    public static final byte LOADED = 0;
    public static final byte UPDATED = 1;
    public static final byte DELETED = 2;
    public static final byte CREATED = 3;
    public byte type;
    public OIdentifiable record;
    public int dataSegmentId = 0;

    public ORecordOperation() {
    }

    public ORecordOperation(OIdentifiable iRecord, byte iStatus) {
        this.record = iRecord;
        this.type = iStatus;
    }

    public int hashCode() {
        return this.record.getIdentity().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ORecordOperation)) {
            return false;
        }
        return this.record.equals(((ORecordOperation)obj).record);
    }

    public String toString() {
        return "ORecordOperation [record=" + this.record + ", type=" + ORecordOperation.getName(this.type) + "]";
    }

    public ORecordInternal<?> getRecord() {
        return this.record != null ? this.record.getRecord() : null;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        try {
            OMemoryStream stream = new OMemoryStream();
            stream.set(this.type);
            ((ORecordId)this.record.getIdentity()).toStream(stream);
            switch (this.type) {
                case 1: 
                case 3: {
                    stream.set(((ORecordInternal)this.record.getRecord()).getRecordType());
                    stream.set(((ORecordInternal)this.record.getRecord()).toStream());
                }
            }
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw new OSerializationException("Cannot serialize record operation", e);
        }
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        try {
            OMemoryStream stream = new OMemoryStream(iStream);
            this.type = stream.getAsByte();
            ORecordId rid = new ORecordId().fromStream(stream);
            switch (this.type) {
                case 1: 
                case 3: {
                    this.record = Orient.instance().getRecordFactoryManager().newInstance(stream.getAsByte());
                    ((ORecordInternal)this.record).fill(rid, OVersionFactory.instance().createVersion(), stream.getAsByteArray(), true);
                }
            }
            return this;
        }
        catch (Exception e) {
            throw new OSerializationException("Cannot deserialize record operation", e);
        }
    }

    public static String getName(int type) {
        String operation = "?";
        switch (type) {
            case 3: {
                operation = "CREATE";
                break;
            }
            case 1: {
                operation = "UPDATE";
                break;
            }
            case 2: {
                operation = "DELETE";
                break;
            }
            case 0: {
                operation = "READ";
            }
        }
        return operation;
    }

    public static byte getId(String iName) {
        if ((iName = iName.toUpperCase()).startsWith("CREAT")) {
            return 3;
        }
        if (iName.startsWith("UPDAT")) {
            return 1;
        }
        if (iName.startsWith("DELET")) {
            return 2;
        }
        if (iName.startsWith("READ")) {
            return 0;
        }
        return -1;
    }
}

