/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag;

import com.orientechnologies.common.collection.OCollection;
import com.orientechnologies.common.serialization.types.OUUIDSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDelegate;
import com.orientechnologies.orient.core.db.record.ridbag.embedded.OEmbeddedRidBag;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringBuilderSerializable;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class ORidBag
implements OStringBuilderSerializable,
Iterable<OIdentifiable>,
ORecordLazyMultiValue,
OTrackedMultiValue<OIdentifiable, OIdentifiable>,
OCollection<OIdentifiable> {
    private ORidBagDelegate delegate;
    private int topThreshold = OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.getValueAsInteger();
    private int bottomThreshold = OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.getValueAsInteger();
    private UUID uuid;

    public ORidBag(ORidBag ridBag) {
        this();
        for (OIdentifiable identifiable : ridBag) {
            this.add(identifiable);
        }
    }

    public ORidBag() {
        this.delegate = this.topThreshold < 0 ? new OSBTreeRidBag() : new OEmbeddedRidBag();
    }

    private ORidBag(byte[] stream) {
        this.fromStream(stream);
    }

    public void addAll(Collection<OIdentifiable> values) {
        this.delegate.addAll(values);
    }

    public void add(OIdentifiable identifiable) {
        this.delegate.add(identifiable);
    }

    public void remove(OIdentifiable identifiable) {
        this.delegate.remove(identifiable);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return this.delegate.rawIterator();
    }

    @Override
    public void convertLinks2Records() {
        this.delegate.convertLinks2Records();
    }

    @Override
    public boolean convertRecords2Links() {
        return this.delegate.convertRecords2Links();
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.delegate.isAutoConvertToRecord();
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.delegate.setAutoConvertToRecord(convertToRecord);
    }

    @Override
    public boolean detach() {
        return this.delegate.detach();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmbedded() {
        return this.delegate instanceof OEmbeddedRidBag;
    }

    @Override
    public OStringBuilderSerializable toStream(StringBuilder output) throws OSerializationException {
        ORecordSerializationContext context = ORecordSerializationContext.getContext();
        if (context != null) {
            ORecord<?> owner;
            boolean oldAutoConvert;
            ORidBagDelegate oldDelegate;
            if (this.delegate.size() >= this.topThreshold && this.isEmbedded() && ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager() != null) {
                oldDelegate = this.delegate;
                this.delegate = new OSBTreeRidBag();
                oldAutoConvert = oldDelegate.isAutoConvertToRecord();
                oldDelegate.setAutoConvertToRecord(false);
                for (Iterator<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> identifiable : oldDelegate) {
                    this.delegate.add((OIdentifiable)((Object)identifiable));
                }
                owner = oldDelegate.getOwner();
                this.delegate.setOwner(owner);
                for (OMultiValueChangeListener<OIdentifiable, OIdentifiable> listener : oldDelegate.getChangeListeners()) {
                    this.delegate.addChangeListener(listener);
                }
                owner.setDirty();
                oldDelegate.setAutoConvertToRecord(oldAutoConvert);
                oldDelegate.requestDelete();
            } else if (this.delegate.size() <= this.bottomThreshold && !this.isEmbedded()) {
                oldDelegate = this.delegate;
                oldAutoConvert = oldDelegate.isAutoConvertToRecord();
                oldDelegate.setAutoConvertToRecord(false);
                this.delegate = new OEmbeddedRidBag();
                for (Iterator<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> identifiable : oldDelegate) {
                    this.delegate.add((OIdentifiable)((Object)identifiable));
                }
                owner = oldDelegate.getOwner();
                this.delegate.setOwner(owner);
                for (OMultiValueChangeListener<OIdentifiable, OIdentifiable> listener : oldDelegate.getChangeListeners()) {
                    this.delegate.addChangeListener(listener);
                }
                owner.setDirty();
                oldDelegate.setAutoConvertToRecord(oldAutoConvert);
                oldDelegate.requestDelete();
            }
        }
        UUID oldUuid = this.uuid;
        OSBTreeCollectionManager sbTreeCollectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
        this.uuid = sbTreeCollectionManager != null ? sbTreeCollectionManager.listenForChanges(this) : null;
        boolean hasUuid = this.uuid != null;
        int serializedSize = 1 + this.delegate.getSerializedSize() + (hasUuid ? 16 : 0);
        byte[] stream = new byte[serializedSize];
        byte configByte = 0;
        if (this.isEmbedded()) {
            configByte = (byte)(configByte | 1);
        }
        if (hasUuid) {
            configByte = (byte)(configByte | 2);
        }
        stream[0] = configByte;
        int offset = 1;
        if (hasUuid) {
            OUUIDSerializer.INSTANCE.serialize(this.uuid, stream, offset, new Object[0]);
            offset += 16;
        }
        this.delegate.serialize(stream, offset, oldUuid);
        output.append(OBase64Utils.encodeBytes(stream));
        return this;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void delete() {
        this.delegate.requestDelete();
    }

    @Override
    public OStringBuilderSerializable fromStream(StringBuilder input) throws OSerializationException {
        byte[] stream = OBase64Utils.decode(input.toString());
        this.fromStream(stream);
        return this;
    }

    private void fromStream(byte[] stream) {
        this.delegate = (stream[0] & 1) == 1 ? new OEmbeddedRidBag() : new OSBTreeRidBag();
        int offset = 1;
        if ((stream[0] & 2) == 2) {
            this.uuid = OUUIDSerializer.INSTANCE.deserialize(stream, offset);
            offset += 16;
        }
        this.delegate.deserialize(stream, offset);
    }

    public static ORidBag fromStream(String value) {
        byte[] stream = OBase64Utils.decode(value);
        return new ORidBag(stream);
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        this.delegate.addChangeListener(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        this.delegate.removeRecordChangeListener(changeListener);
    }

    @Override
    public Object returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> multiValueChangeEvents) {
        return this.delegate.returnOriginalState(multiValueChangeEvents);
    }

    @Override
    public Class<?> getGenericClass() {
        return this.delegate.getGenericClass();
    }

    public void setOwner(ORecord<?> owner) {
        this.delegate.setOwner(owner);
    }

    public UUID getTemporaryId() {
        return this.uuid;
    }

    public void notifySaved(OBonsaiCollectionPointer newPointer) {
        if (newPointer.isValid()) {
            if (this.isEmbedded()) {
                this.replaceWithSBTree(newPointer);
            } else {
                ((OSBTreeRidBag)this.delegate).setCollectionPointer(newPointer);
                ((OSBTreeRidBag)this.delegate).clearChanges();
            }
        }
    }

    private void replaceWithSBTree(OBonsaiCollectionPointer pointer) {
        this.delegate.requestDelete();
        OSBTreeRidBag treeBag = new OSBTreeRidBag();
        treeBag.setCollectionPointer(pointer);
        this.delegate = treeBag;
    }

    public OBonsaiCollectionPointer getPointer() {
        if (this.isEmbedded()) {
            return OBonsaiCollectionPointer.INVALID;
        }
        return ((OSBTreeRidBag)this.delegate).getCollectionPointer();
    }
}

