/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class ODatabaseExport
extends ODatabaseImpExpAbstract {
    public static final int VERSION = 8;
    protected OJSONWriter writer;
    protected long recordExported;
    protected int compressionLevel = 1;
    protected int compressionBuffer = 16384;

    public ODatabaseExport(ODatabaseRecord iDatabase, String iFileName, OCommandOutputListener iListener) throws IOException {
        super(iDatabase, iFileName, iListener);
        File f;
        if (this.fileName == null) {
            throw new IllegalArgumentException("file name missing");
        }
        if (!this.fileName.endsWith(".gz")) {
            this.fileName = this.fileName + ".gz";
        }
        if ((f = new File(this.fileName)).getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            f.delete();
        }
        GZIPOutputStream gzipOS = new GZIPOutputStream(new FileOutputStream(this.fileName), this.compressionBuffer){
            {
                this.def.setLevel(ODatabaseExport.this.compressionLevel);
            }
        };
        this.writer = new OJSONWriter(new OutputStreamWriter(gzipOS));
        this.writer.beginObject();
        iDatabase.getLevel1Cache().setEnable(false);
        iDatabase.getLevel2Cache().setEnable(false);
    }

    public ODatabaseExport(ODatabaseRecord iDatabase, OutputStream iOutputStream, OCommandOutputListener iListener) throws IOException {
        super(iDatabase, "streaming", iListener);
        this.writer = new OJSONWriter(new OutputStreamWriter(iOutputStream));
        this.writer.beginObject();
        iDatabase.getLevel1Cache().setEnable(false);
        iDatabase.getLevel2Cache().setEnable(false);
    }

    @Override
    public ODatabaseExport setOptions(String s) {
        super.setOptions(s);
        return this;
    }

    public ODatabaseExport exportDatabase() {
        try {
            this.listener.onMessage("\nStarted export of database '" + this.database.getName() + "' to " + this.fileName + "...");
            this.database.getLevel1Cache().setEnable(false);
            this.database.getLevel2Cache().setEnable(false);
            long time = System.currentTimeMillis();
            if (this.includeInfo) {
                this.exportInfo();
            }
            if (this.includeClusterDefinitions) {
                this.exportClusters();
            }
            if (this.includeSchema) {
                this.exportSchema();
            }
            if (this.includeRecords) {
                this.exportRecords();
            }
            if (this.includeIndexDefinitions) {
                this.exportIndexDefinitions();
            }
            if (this.includeManualIndexes) {
                this.exportManualIndexes();
            }
            this.listener.onMessage("\n\nDatabase export completed in " + (System.currentTimeMillis() - time) + "ms");
            this.writer.flush();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on exporting database '%s' to: %s", (Throwable)e, new Object[]{this.database.getName(), this.fileName});
            throw new ODatabaseExportException("Error on exporting database '" + this.database.getName() + "' to: " + this.fileName, e);
        }
        finally {
            this.close();
        }
        return this;
    }

    public long exportRecords() throws IOException {
        long totalFoundRecords = 0L;
        long totalExportedRecords = 0L;
        int level = 1;
        this.listener.onMessage("\nExporting records...");
        this.writer.beginCollection(level, true, "records");
        int exportedClusters = 0;
        int maxClusterId = this.getMaxClusterId();
        int i = 0;
        while (exportedClusters <= maxClusterId) {
            block14: {
                long clusterExportedRecordsCurrent;
                long clusterExportedRecordsTot;
                block12: {
                    String clusterName;
                    block15: {
                        block13: {
                            clusterName = this.database.getClusterNameById(i);
                            ++exportedClusters;
                            clusterExportedRecordsTot = 0L;
                            if (clusterName == null) break block13;
                            if (this.includeClusters == null ? this.excludeClusters != null && this.excludeClusters.contains(clusterName.toUpperCase()) : !this.includeClusters.contains(clusterName.toUpperCase())) break block14;
                            if (this.excludeClusters != null && this.excludeClusters.contains(clusterName.toUpperCase())) break block14;
                            clusterExportedRecordsTot = this.database.countClusterElements(clusterName);
                            break block15;
                        }
                        if (this.includeClusters != null && !this.includeClusters.isEmpty()) break block14;
                    }
                    this.listener.onMessage("\n- Cluster " + (clusterName != null ? "'" + clusterName + "'" : "NULL") + " (id=" + i + ")...");
                    clusterExportedRecordsCurrent = 0L;
                    if (clusterName != null) {
                        Object rec = null;
                        try {
                            ORecordIteratorCluster it = this.database.browseCluster(clusterName);
                            while (it.hasNext()) {
                                rec = it.next();
                                if (rec instanceof ODocument) {
                                    String className;
                                    ODocument doc = (ODocument)rec;
                                    String string = className = doc.getClassName() != null ? doc.getClassName().toUpperCase() : null;
                                    if (this.includeClasses != null ? !this.includeClasses.contains(className) : this.excludeClasses != null && this.excludeClasses.contains(className)) {
                                        continue;
                                    }
                                } else if (this.includeClasses != null && !this.includeClasses.isEmpty()) continue;
                                if (!this.exportRecord(clusterExportedRecordsTot, clusterExportedRecordsCurrent, (ORecordInternal<?>)rec)) continue;
                                ++clusterExportedRecordsCurrent;
                            }
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "\nError on exporting record %s because of I/O problems", (Throwable)e, new Object[]{rec.getIdentity()});
                            throw e;
                        }
                        catch (OIOException e) {
                            OLogManager.instance().error((Object)this, "\nError on exporting record %s because of I/O problems", (Throwable)e, new Object[]{rec.getIdentity()});
                            throw e;
                        }
                        catch (Throwable t) {
                            if (rec == null) break block12;
                            byte[] buffer = rec.toStream();
                            OLogManager.instance().error((Object)this, "\nError on exporting record %s. It seems corrupted; size: %d bytes, raw content (as string):\n==========\n%s\n==========", t, new Object[]{rec.getIdentity(), buffer.length, new String(buffer)});
                        }
                    }
                }
                this.listener.onMessage("OK (records=" + clusterExportedRecordsCurrent + "/" + clusterExportedRecordsTot + ")");
                totalExportedRecords += clusterExportedRecordsCurrent;
                totalFoundRecords += clusterExportedRecordsTot;
            }
            ++i;
        }
        this.writer.endCollection(level, true);
        this.listener.onMessage("\n\nDone. Exported " + totalExportedRecords + " of total " + totalFoundRecords + " records\n");
        return totalFoundRecords;
    }

    public void close() {
        this.database.declareIntent(null);
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.endObject();
            this.writer.close();
            this.writer = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int getMaxClusterId() {
        int totalCluster = -1;
        for (String clusterName : this.database.getClusterNames()) {
            if (this.database.getClusterIdByName(clusterName) <= totalCluster) continue;
            totalCluster = this.database.getClusterIdByName(clusterName);
        }
        return totalCluster;
    }

    @Override
    protected void parseSetting(String option, List<String> items) {
        if (option.equalsIgnoreCase("-compressionLevel")) {
            this.compressionLevel = Integer.parseInt(items.get(0));
        } else if (option.equalsIgnoreCase("-compressionBuffer")) {
            this.compressionBuffer = Integer.parseInt(items.get(0));
        } else {
            super.parseSetting(option, items);
        }
    }

    private void exportClusters() throws IOException {
        this.listener.onMessage("\nExporting clusters...");
        this.writer.beginCollection(1, true, "clusters");
        int exportedClusters = 0;
        int maxClusterId = this.getMaxClusterId();
        for (int clusterId = 0; clusterId <= maxClusterId; ++clusterId) {
            String clusterName = this.database.getClusterNameById(clusterId);
            if (clusterName == null || (this.includeClusters != null ? !this.includeClusters.contains(clusterName.toUpperCase()) : this.excludeClusters != null && this.excludeClusters.contains(clusterName.toUpperCase()))) continue;
            this.writer.beginObject(2, true, null);
            this.writer.writeAttribute(0, false, "name", clusterName);
            this.writer.writeAttribute(0, false, "id", clusterId);
            this.writer.writeAttribute(0, false, "type", this.database.getClusterType(clusterName));
            ++exportedClusters;
            this.writer.endObject(2, false);
        }
        this.listener.onMessage("OK (" + exportedClusters + " clusters)");
        this.writer.endCollection(1, true);
    }

    private void exportInfo() throws IOException {
        this.listener.onMessage("\nExporting database info...");
        this.writer.beginObject(1, true, "info");
        this.writer.writeAttribute(2, true, "name", this.database.getName().replace('\\', '/'));
        this.writer.writeAttribute(2, true, "default-cluster-id", this.database.getDefaultClusterId());
        this.writer.writeAttribute(2, true, "exporter-version", 8);
        this.writer.writeAttribute(2, true, "engine-version", "1.7.10");
        String engineBuild = OConstants.getBuildNumber();
        if (engineBuild != null) {
            this.writer.writeAttribute(2, true, "engine-build", engineBuild);
        }
        this.writer.writeAttribute(2, true, "storage-config-version", 9);
        this.writer.writeAttribute(2, true, "schema-version", 4);
        this.writer.writeAttribute(2, true, "mvrbtree-version", (byte)3);
        this.writer.writeAttribute(2, true, "schemaRecordId", this.database.getStorage().getConfiguration().schemaRecordId);
        this.writer.writeAttribute(2, true, "indexMgrRecordId", this.database.getStorage().getConfiguration().indexMgrRecordId);
        this.writer.endObject(1, true);
        this.listener.onMessage("OK");
    }

    private void exportIndexDefinitions() throws IOException {
        this.listener.onMessage("\nExporting index info...");
        this.writer.beginCollection(1, true, "indexes");
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        indexManager.reload();
        Collection<OIndex<?>> indexes = indexManager.getIndexes();
        for (OIndex<?> index : indexes) {
            ODocument configuration;
            ODocument metadata;
            if (index.getName().equals("___exportImportRIDMap")) continue;
            this.listener.onMessage("\n- Index " + index.getName() + "...");
            this.writer.beginObject(2, true, null);
            this.writer.writeAttribute(3, true, "name", index.getName());
            this.writer.writeAttribute(3, true, "type", index.getType());
            if (!index.getClusters().isEmpty()) {
                this.writer.writeAttribute(3, true, "clustersToIndex", index.getClusters());
            }
            if (index.getDefinition() != null) {
                this.writer.beginObject(4, true, "definition");
                this.writer.writeAttribute(5, true, "defClass", index.getDefinition().getClass().getName());
                this.writer.writeAttribute(5, true, "stream", index.getDefinition().toStream());
                this.writer.endObject(4, true);
            }
            if ((metadata = index.getMetadata()) != null) {
                this.writer.writeAttribute(4, true, "metadata", metadata);
            }
            if ((configuration = index.getConfiguration()).field("blueprintsIndexClass") != null) {
                this.writer.writeAttribute(4, true, "blueprintsIndexClass", configuration.field("blueprintsIndexClass"));
            }
            this.writer.endObject(2, true);
            this.listener.onMessage("OK");
        }
        this.writer.endCollection(1, true);
        this.listener.onMessage("\nOK (" + indexes.size() + " indexes)");
    }

    private void exportManualIndexes() throws IOException {
        this.listener.onMessage("\nExporting manual indexes content...");
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        indexManager.reload();
        Collection<OIndex<?>> indexes = indexManager.getIndexes();
        ODocument exportEntry = new ODocument();
        int manualIndexes = 0;
        this.writer.beginCollection(1, true, "manualIndexes");
        for (OIndex<?> index : indexes) {
            if (index.getName().equals("___exportImportRIDMap") || index.isAutomatic()) continue;
            this.listener.onMessage("\n- Exporting index " + index.getName() + " ...");
            this.writer.beginObject(2, true, null);
            this.writer.writeAttribute(3, true, "name", index.getName());
            Object indexContent = this.database.query(new OSQLSynchQuery("select from index:" + index.getName()), new Object[0]);
            this.writer.beginCollection(3, true, "content");
            int i = 0;
            for (ODocument indexEntry : indexContent) {
                if (i > 0) {
                    this.writer.append(",");
                }
                indexEntry.setLazyLoad(false);
                OIndexDefinition indexDefinition = index.getDefinition();
                exportEntry.reset();
                exportEntry.setLazyLoad(false);
                if (indexDefinition instanceof ORuntimeKeyIndexDefinition && ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer() != null) {
                    OBinarySerializer binarySerializer = ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer();
                    int dataSize = binarySerializer.getObjectSize(indexEntry.field("key"), new Object[0]);
                    byte[] binaryContent = new byte[dataSize];
                    binarySerializer.serialize(indexEntry.field("key"), binaryContent, 0, new Object[0]);
                    exportEntry.field("binary", true);
                    exportEntry.field("key", binaryContent);
                } else {
                    exportEntry.field("binary", false);
                    exportEntry.field("key", indexEntry.field("key"));
                }
                exportEntry.field("rid", indexEntry.field("rid"));
                this.writer.append(exportEntry.toJSON());
                long percent = indexContent.size() / 10;
                if (percent <= 0L || (long)(++i) % percent != 0L) continue;
                this.listener.onMessage(".");
            }
            this.writer.endCollection(3, true);
            this.writer.endObject(2, true);
            this.listener.onMessage("OK (entries=" + index.getSize() + ")");
            ++manualIndexes;
        }
        this.writer.endCollection(1, true);
        this.listener.onMessage("\nOK (" + manualIndexes + " manual indexes)");
    }

    private void exportSchema() throws IOException {
        this.listener.onMessage("\nExporting schema...");
        this.writer.beginObject(1, true, "schema");
        OSchemaProxy s = (OSchemaProxy)this.database.getMetadata().getSchema();
        this.writer.writeAttribute(2, true, "version", s.getVersion());
        if (!s.getClasses().isEmpty()) {
            this.writer.beginCollection(2, true, "classes");
            ArrayList<OClass> classes = new ArrayList<OClass>(s.getClasses());
            Collections.sort(classes);
            for (OClass cls : classes) {
                this.writer.beginObject(3, true, null);
                this.writer.writeAttribute(0, false, "name", cls.getName());
                this.writer.writeAttribute(0, false, "default-cluster-id", cls.getDefaultClusterId());
                this.writer.writeAttribute(0, false, "cluster-ids", cls.getClusterIds());
                if (((OClassImpl)cls).getOverSizeInternal() > 1.0f) {
                    this.writer.writeAttribute(0, false, "oversize", Float.valueOf(((OClassImpl)cls).getOverSizeInternal()));
                }
                if (cls.isStrictMode()) {
                    this.writer.writeAttribute(0, false, "strictMode", cls.isStrictMode());
                }
                if (cls.getSuperClass() != null) {
                    this.writer.writeAttribute(0, false, "super-class", cls.getSuperClass().getName());
                }
                if (cls.getShortName() != null) {
                    this.writer.writeAttribute(0, false, "short-name", cls.getShortName());
                }
                if (cls.isAbstract()) {
                    this.writer.writeAttribute(0, false, "abstract", cls.isAbstract());
                }
                this.writer.writeAttribute(0, false, "cluster-selection", cls.getClusterSelection().getName());
                if (!cls.properties().isEmpty()) {
                    this.writer.beginCollection(4, true, "properties");
                    ArrayList<OProperty> properties = new ArrayList<OProperty>(cls.declaredProperties());
                    Collections.sort(properties);
                    for (OProperty p : properties) {
                        this.writer.beginObject(5, true, null);
                        this.writer.writeAttribute(0, false, "name", p.getName());
                        this.writer.writeAttribute(0, false, "type", p.getType().toString());
                        if (p.isMandatory()) {
                            this.writer.writeAttribute(0, false, "mandatory", p.isMandatory());
                        }
                        if (p.isReadonly()) {
                            this.writer.writeAttribute(0, false, "readonly", p.isReadonly());
                        }
                        if (p.isNotNull()) {
                            this.writer.writeAttribute(0, false, "not-null", p.isNotNull());
                        }
                        if (p.getLinkedClass() != null) {
                            this.writer.writeAttribute(0, false, "linked-class", p.getLinkedClass().getName());
                        }
                        if (p.getLinkedType() != null) {
                            this.writer.writeAttribute(0, false, "linked-type", p.getLinkedType().toString());
                        }
                        if (p.getMin() != null) {
                            this.writer.writeAttribute(0, false, "min", p.getMin());
                        }
                        if (p.getMax() != null) {
                            this.writer.writeAttribute(0, false, "max", p.getMax());
                        }
                        if (p.getCollate() != null) {
                            this.writer.writeAttribute(0, false, "collate", p.getCollate().getName());
                        }
                        if (((OPropertyImpl)p).getCustomInternal() != null) {
                            this.writer.writeAttribute(0, false, "customFields", ((OPropertyImpl)p).getCustomInternal());
                        }
                        this.writer.endObject(0, false);
                    }
                    this.writer.endCollection(4, true);
                }
                this.writer.endObject(3, true);
            }
            this.writer.endCollection(2, true);
        }
        this.writer.endObject(1, true);
        this.listener.onMessage("OK (" + s.getClasses().size() + " classes)");
    }

    private boolean exportRecord(long recordTot, long recordNum, ORecordInternal<?> rec) throws IOException {
        block7: {
            if (rec != null) {
                try {
                    if (rec.getIdentity().isValid()) {
                        rec.reload();
                    }
                    if (this.useLineFeedForRecords) {
                        this.writer.append("\n");
                    }
                    if (this.recordExported > 0L) {
                        this.writer.append(",");
                    }
                    this.writer.append(rec.toJSON("rid,type,version,class,attribSameRow,keepTypes,alwaysFetchEmbedded,dateAsLong"));
                    ++this.recordExported;
                    if (recordTot > 10L && (++recordNum + 1L) % (recordTot / 10L) == 0L) {
                        this.listener.onMessage(".");
                    }
                    return true;
                }
                catch (Throwable t) {
                    if (rec == null) break block7;
                    byte[] buffer = rec.toStream();
                    OLogManager.instance().error((Object)this, "\nError on exporting record %s. It seems corrupted; size: %d bytes, raw content (as string):\n==========\n%s\n==========", t, new Object[]{rec.getIdentity(), buffer.length, new String(buffer)});
                }
            }
        }
        return false;
    }
}

