/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.collate.ODefaultCollate;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;

public abstract class OAbstractIndexDefinition
extends ODocumentWrapperNoClass
implements OIndexDefinition {
    protected OCollate collate = new ODefaultCollate();
    private boolean nullValuesIgnored = true;

    protected OAbstractIndexDefinition() {
        super(new ODocument());
    }

    @Override
    public OCollate getCollate() {
        return this.collate;
    }

    @Override
    public void setCollate(OCollate collate) {
        if (collate == null) {
            throw new IllegalArgumentException("COLLATE cannot be null");
        }
        this.collate = collate;
    }

    public void setCollate(String iCollate) {
        if (iCollate == null) {
            iCollate = "default";
        }
        this.setCollate(OSQLEngine.getCollate(iCollate));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAbstractIndexDefinition that = (OAbstractIndexDefinition)o;
        if (!this.collate.equals(that.collate)) {
            return false;
        }
        return this.nullValuesIgnored == that.nullValuesIgnored;
    }

    @Override
    public int hashCode() {
        int result = this.collate.hashCode();
        result = 31 * result + (this.nullValuesIgnored ? 1 : 0);
        return result;
    }

    @Override
    public boolean isNullValuesIgnored() {
        return this.nullValuesIgnored;
    }

    @Override
    public void setNullValuesIgnored(boolean value) {
        this.nullValuesIgnored = value;
    }
}

