/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OMVRBTreeIndexEngine;
import com.orientechnologies.orient.core.index.engine.OSBTreeIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ODefaultIndexFactory
implements OIndexFactory {
    public static final String SBTREE_ALGORITHM = "SBTREE";
    public static final String MVRBTREE_ALGORITHM = "MVRBTREE";
    public static final String MVRBTREE_VALUE_CONTAINER = "MVRBTREESET";
    public static final String SBTREEBONSAI_VALUE_CONTAINER = "SBTREEBONSAISET";
    public static final String NONE_VALUE_CONTAINER = "NONE";
    private static final Set<String> TYPES;
    private static final Set<String> ALGORITHMS;

    public static boolean isMultiValueIndex(String indexType) {
        switch (OClass.INDEX_TYPE.valueOf(indexType)) {
            case UNIQUE: 
            case UNIQUE_HASH_INDEX: 
            case DICTIONARY: 
            case DICTIONARY_HASH_INDEX: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    @Override
    public OIndexInternal<?> createIndex(ODatabaseRecord database, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata) throws OConfigurationException {
        if (valueContainerAlgorithm == null) {
            valueContainerAlgorithm = OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(indexType) || OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(indexType) || OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString().equals(indexType) || OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType) ? MVRBTREE_VALUE_CONTAINER : NONE_VALUE_CONTAINER;
        }
        if ((database.getStorage().getType().equals("plocal") || database.getStorage().getType().equals("local")) && valueContainerAlgorithm.equals(MVRBTREE_VALUE_CONTAINER) && OGlobalConfiguration.INDEX_NOTUNIQUE_USE_SBTREE_CONTAINER_BY_DEFAULT.getValueAsBoolean()) {
            OLogManager.instance().warn((Object)this, "Index was created using %s as values container. This container is deprecated and is not supported any more. To avoid this message please drop and recreate indexes or perform DB export/import.", new Object[]{valueContainerAlgorithm});
        }
        if (SBTREE_ALGORITHM.equals(algorithm)) {
            return this.createSBTreeIndex(indexType, valueContainerAlgorithm, metadata);
        }
        if (MVRBTREE_ALGORITHM.equals(algorithm) || algorithm == null) {
            return this.createMVRBTreeIndex(indexType, valueContainerAlgorithm, metadata);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }

    private OIndexInternal<?> createMVRBTreeIndex(String indexType, String valueContainerAlgorithm, ODocument metadata) {
        if (OClass.INDEX_TYPE.UNIQUE.toString().equals(indexType)) {
            return new OIndexUnique(indexType, MVRBTREE_ALGORITHM, (OIndexEngine<OIdentifiable>)new OMVRBTreeIndexEngine<OIdentifiable>(), valueContainerAlgorithm);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(indexType)) {
            return new OIndexNotUnique(indexType, MVRBTREE_ALGORITHM, (OIndexEngine<Set<OIdentifiable>>)new OMVRBTreeIndexEngine<Set<OIdentifiable>>(), valueContainerAlgorithm);
        }
        if (OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType)) {
            return new OIndexFullText(indexType, MVRBTREE_ALGORITHM, new OMVRBTreeIndexEngine<Set<OIdentifiable>>(), valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.DICTIONARY.toString().equals(indexType)) {
            return new OIndexDictionary(indexType, MVRBTREE_ALGORITHM, (OIndexEngine<OIdentifiable>)new OMVRBTreeIndexEngine<OIdentifiable>(), valueContainerAlgorithm);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }

    private OIndexInternal<?> createSBTreeIndex(String indexType, String valueContainerAlgorithm, ODocument metadata) {
        if (OClass.INDEX_TYPE.UNIQUE.toString().equals(indexType)) {
            return new OIndexUnique(indexType, SBTREE_ALGORITHM, (OIndexEngine<OIdentifiable>)new OSBTreeIndexEngine<OIdentifiable>(), valueContainerAlgorithm);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(indexType)) {
            return new OIndexNotUnique(indexType, SBTREE_ALGORITHM, (OIndexEngine<Set<OIdentifiable>>)new OSBTreeIndexEngine<Set<OIdentifiable>>(), valueContainerAlgorithm);
        }
        if (OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType)) {
            return new OIndexFullText(indexType, SBTREE_ALGORITHM, new OSBTreeIndexEngine<Set<OIdentifiable>>(), valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.DICTIONARY.toString().equals(indexType)) {
            return new OIndexDictionary(indexType, SBTREE_ALGORITHM, (OIndexEngine<OIdentifiable>)new OSBTreeIndexEngine<OIdentifiable>(), valueContainerAlgorithm);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(SBTREE_ALGORITHM);
        algorithms.add(MVRBTREE_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

