/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import java.util.Map;

public class OIndexDictionary
extends OIndexOneValue {
    public OIndexDictionary(String typeId, String algorithm, OIndexEngine<OIdentifiable> engine, String valueContainerAlgorithm) {
        super(typeId, algorithm, engine, valueContainerAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexOneValue put(Object key, OIdentifiable value) {
        this.modificationLock.requestModificationLock();
        key = this.getCollatingValue(key);
        try {
            OIndexDictionary oIndexDictionary;
            this.checkForKeyType(key);
            this.acquireSharedLock();
            try {
                this.indexEngine.put(key, value);
                oIndexDictionary = this;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oIndexDictionary;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public void checkEntry(OIdentifiable record, Object key) {
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        key = this.getCollatingValue(key);
        snapshot.put(key, value.getIdentity());
    }

    @Override
    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        key = this.getCollatingValue(key);
        snapshot.put(key, OIndexAbstract.RemovedValue.INSTANCE);
    }

    @Override
    protected void commitSnapshot(Map<Object, Object> snapshot) {
        for (Map.Entry<Object, Object> snapshotEntry : snapshot.entrySet()) {
            Object key = snapshotEntry.getKey();
            this.checkForKeyType(key);
            Object snapshotValue = snapshotEntry.getValue();
            if (snapshotValue.equals(OIndexAbstract.RemovedValue.INSTANCE)) {
                this.indexEngine.remove(key);
                continue;
            }
            this.indexEngine.put(key, (OIdentifiable)snapshotValue);
        }
    }
}

