/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexRebuildOutputListener;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OIndexManagerShared
extends OIndexManagerAbstract
implements OIndexManager {
    private static final boolean useSBTree = OGlobalConfiguration.INDEX_USE_SBTREE_BY_DEFAULT.getValueAsBoolean();
    private static final long serialVersionUID = 1L;
    protected volatile Thread recreateIndexesThread = null;
    private volatile boolean rebuildCompleted = false;

    public OIndexManagerShared(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    public OIndex<?> getIndexInternal(String name) {
        this.acquireSharedLock();
        try {
            OIndex oIndex = (OIndex)this.indexes.get(name.toLowerCase());
            return oIndex;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata) {
        return this.createIndex(iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String algorithm) {
        OIndexInternal<?> index;
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot create a new index inside a transaction");
        }
        Character c = OSchemaShared.checkNameIfValid(iName);
        if (c != null) {
            throw new IllegalArgumentException("Invalid index name '" + iName + "'. Character '" + c + "' is invalid");
        }
        ODatabaseRecord database = this.getDatabase();
        OStorage storage = database.getStorage();
        algorithm = this.chooseTreeAlgorithm(algorithm, storage);
        String valueContainerAlgorithm = this.chooseContainerAlgorithm(iType, storage);
        this.acquireExclusiveLock();
        try {
            String clusterName;
            if (this.indexes.containsKey(iName.toLowerCase())) {
                throw new OIndexException("Index with name " + iName.toLowerCase() + " already exists.");
            }
            index = OIndexes.createIndex(this.getDatabase(), iType, algorithm, valueContainerAlgorithm, metadata);
            String string = clusterName = indexDefinition != null && indexDefinition.getClassName() != null ? this.defaultClusterName : this.manualClusterName;
            if (progressListener == null) {
                progressListener = new OIndexRebuildOutputListener(index);
            }
            Set<String> clustersToIndex = this.findClustersByIds(clusterIdsToIndex, database);
            if (metadata != null && Boolean.FALSE.equals(metadata.field("ignoreNullValues")) && indexDefinition != null) {
                indexDefinition.setNullValuesIgnored(false);
            }
            index.create(iName, indexDefinition, clusterName, clustersToIndex, true, progressListener);
            this.addIndexInternal(index);
            if (metadata != null) {
                ODocument config = index.getConfiguration();
                config.field("metadata", metadata, OType.EMBEDDED);
            }
            this.setDirty();
            this.save();
        }
        finally {
            this.releaseExclusiveLock();
        }
        if (OGlobalConfiguration.INDEX_FLUSH_AFTER_CREATE.getValueAsBoolean()) {
            storage.synch();
        }
        return index;
    }

    private Set<String> findClustersByIds(int[] clusterIdsToIndex, ODatabase database) {
        HashSet<String> clustersToIndex = new HashSet<String>();
        if (clusterIdsToIndex != null) {
            for (int clusterId : clusterIdsToIndex) {
                String clusterNameToIndex = database.getClusterNameById(clusterId);
                if (clusterNameToIndex == null) {
                    throw new OIndexException("Cluster with id " + clusterId + " does not exist.");
                }
                clustersToIndex.add(clusterNameToIndex);
            }
        }
        return clustersToIndex;
    }

    private String chooseContainerAlgorithm(String iType, OStorage storage) {
        String valueContainerAlgorithm = OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(iType) || OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(iType) || OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString().equals(iType) || OClass.INDEX_TYPE.FULLTEXT.toString().equals(iType) ? ((storage.getType().equals("plocal") || storage.getType().equals("local")) && OGlobalConfiguration.INDEX_NOTUNIQUE_USE_SBTREE_CONTAINER_BY_DEFAULT.getValueAsBoolean() ? "SBTREEBONSAISET" : "MVRBTREESET") : "NONE";
        return valueContainerAlgorithm;
    }

    private String chooseTreeAlgorithm(String algorithm, OStorage storage) {
        if (algorithm == null) {
            algorithm = storage.getType().equals("memory") || !useSBTree ? "MVRBTREE" : "SBTREE";
        }
        return algorithm;
    }

    @Override
    public OIndexManager dropIndex(String iIndexName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop an index inside a transaction");
        }
        this.acquireExclusiveLock();
        try {
            OIndex idx = (OIndex)this.indexes.remove(iIndexName.toLowerCase());
            if (idx != null) {
                this.removeClassPropertyIndex(idx);
                this.getDatabase().unregisterListener(idx.getInternal());
                idx.delete();
                this.setDirty();
                this.save();
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        OStorage storage = this.getDatabase().getStorage();
        if (OGlobalConfiguration.INDEX_FLUSH_AFTER_CREATE.getValueAsBoolean()) {
            storage.synch();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument toStream() {
        this.acquireExclusiveLock();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                ORecordTrackedSet idxs = new ORecordTrackedSet(this.document);
                for (OIndex i : this.indexes.values()) {
                    idxs.add(((OIndexInternal)i).updateConfiguration());
                }
                this.document.field("indexes", idxs, OType.EMBEDDEDSET);
            }
            finally {
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
            this.document.setDirty();
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recreateIndexes() {
        this.acquireExclusiveLock();
        try {
            if (this.recreateIndexesThread != null && this.recreateIndexesThread.isAlive()) {
                return;
            }
            ODatabaseRecord db = this.getDatabase();
            this.document = (ODocument)db.load(new ORecordId(this.getDatabase().getStorage().getConfiguration().indexMgrRecordId));
            ODocument doc = new ODocument();
            this.document.copyTo(doc);
            ODatabaseDocumentTx newDb = new ODatabaseDocumentTx(db.getURL());
            RecreateIndexesTask recreateIndexesTask = new RecreateIndexesTask(newDb, doc);
            this.recreateIndexesThread = new Thread((Runnable)recreateIndexesTask, "OrientDB rebuild indexes");
            this.recreateIndexesThread.start();
        }
        finally {
            this.releaseExclusiveLock();
        }
        if (OGlobalConfiguration.INDEX_SYNCHRONOUS_AUTO_REBUILD.getValueAsBoolean()) {
            this.waitTillIndexRestore();
            this.getDatabase().getMetadata().reload();
        }
    }

    @Override
    public void waitTillIndexRestore() {
        if (this.recreateIndexesThread != null && this.recreateIndexesThread.isAlive()) {
            if (Thread.currentThread().equals(this.recreateIndexesThread)) {
                return;
            }
            OLogManager.instance().info((Object)this, "Wait till indexes restore after crash was finished.", new Object[0]);
            while (this.recreateIndexesThread.isAlive()) {
                try {
                    this.recreateIndexesThread.join();
                    OLogManager.instance().info((Object)this, "Indexes restore after crash was finished.", new Object[0]);
                }
                catch (InterruptedException e) {
                    OLogManager.instance().info((Object)this, "Index rebuild task was interrupted.", new Object[0]);
                }
            }
        }
    }

    @Override
    public boolean autoRecreateIndexesAfterCrash() {
        if (this.rebuildCompleted) {
            return false;
        }
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (!OGlobalConfiguration.INDEX_AUTO_REBUILD_AFTER_NOTSOFTCLOSE.getValueAsBoolean()) {
            return false;
        }
        OStorage storage = database.getStorage().getUnderlying();
        if (storage instanceof OStorageLocal) {
            return !((OStorageLocal)storage).wasClusterSoftlyClosed("index");
        }
        if (storage instanceof OLocalPaginatedStorage) {
            return ((OLocalPaginatedStorage)storage).wereDataRestoredAfterOpen();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            HashMap oldIndexes = new HashMap(this.indexes);
            this.clearMetadata();
            Collection idxs = (Collection)this.document.field("indexes");
            if (idxs != null) {
                boolean configUpdated = false;
                Iterator indexConfigurationIterator = idxs.iterator();
                while (indexConfigurationIterator.hasNext()) {
                    ODocument d = (ODocument)indexConfigurationIterator.next();
                    try {
                        OIndexInternal<?> index = OIndexes.createIndex(this.getDatabase(), (String)d.field("type"), (String)d.field("algorithm"), (String)d.field("valueContainerAlgorithm"), (ODocument)d.field("metadata"));
                        OIndexInternal.IndexMetadata newIndexMetadata = index.loadMetadata(d);
                        String normalizedName = newIndexMetadata.getName().toLowerCase();
                        OIndex oldIndex = (OIndex)oldIndexes.get(normalizedName);
                        if (oldIndex != null) {
                            OIndexInternal.IndexMetadata oldIndexMetadata = oldIndex.getInternal().loadMetadata(oldIndex.getConfiguration());
                            if (oldIndexMetadata.equals(newIndexMetadata)) {
                                this.addIndexInternal(oldIndex.getInternal());
                                oldIndexes.remove(normalizedName);
                                continue;
                            }
                            if (newIndexMetadata.getIndexDefinition() != null || !d.field("mapRid").equals(oldIndex.getConfiguration().field("mapRid"))) continue;
                            this.addIndexInternal(oldIndex.getInternal());
                            oldIndexes.remove(normalizedName);
                            continue;
                        }
                        if (index.loadFromConfiguration(d)) {
                            this.addIndexInternal(index);
                            continue;
                        }
                        indexConfigurationIterator.remove();
                        configUpdated = true;
                    }
                    catch (Exception e) {
                        indexConfigurationIterator.remove();
                        configUpdated = true;
                        OLogManager.instance().error((Object)this, "Error on loading index by configuration: %s", (Throwable)e, new Object[]{d});
                    }
                }
                for (OIndex oldIndex : oldIndexes.values()) {
                    try {
                        OLogManager.instance().warn((Object)this, "Index %s was not found after reload and will be removed", new Object[]{oldIndex.getName()});
                        this.getDatabase().unregisterListener(oldIndex.getInternal());
                        oldIndex.delete();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on deletion of index %s", (Throwable)e, new Object[]{oldIndex.getName()});
                    }
                }
                if (configUpdated) {
                    this.document.field("indexes", idxs);
                    this.save();
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void removeClassPropertyIndex(OIndex<?> idx) {
        OIndexDefinition indexDefinition = idx.getDefinition();
        if (indexDefinition == null || indexDefinition.getClassName() == null) {
            return;
        }
        Map map = (Map)this.classPropertyIndex.get(indexDefinition.getClassName().toLowerCase());
        if (map == null) {
            return;
        }
        int paramCount = indexDefinition.getParamCount();
        for (int i = 1; i <= paramCount; ++i) {
            List<String> fields = this.normalizeFieldNames(indexDefinition.getFields().subList(0, i));
            OMultiKey multiKey = new OMultiKey(fields);
            Set indexSet = (Set)map.get(multiKey);
            if (indexSet == null) continue;
            indexSet.remove(idx);
            if (!indexSet.isEmpty()) continue;
            map.remove(multiKey);
        }
        if (map.isEmpty()) {
            this.classPropertyIndex.remove(indexDefinition.getClassName().toLowerCase());
        }
    }

    private class RecreateIndexesTask
    implements Runnable {
        private final ODatabaseDocumentTx newDb;
        private final ODocument doc;
        private int ok;
        private int errors;

        public RecreateIndexesTask(ODatabaseDocumentTx newDb, ODocument doc) {
            this.newDb = newDb;
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                this.setUpDatabase();
                Collection<ODocument> idxs = this.getConfiguration();
                this.recreateIndexes(idxs);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error when attempt to restore indexes after crash was performed.", (Throwable)e, new Object[0]);
            }
        }

        private void recreateIndexes(Collection<ODocument> idxs) {
            this.ok = 0;
            this.errors = 0;
            for (ODocument idx : idxs) {
                try {
                    this.recreateIndex(idx);
                }
                catch (RuntimeException e) {
                    OLogManager.instance().error((Object)this, "Error during addition of index %s", (Throwable)e, new Object[]{idx});
                    ++this.errors;
                }
            }
            OIndexManagerShared.this.save();
            OStorage storage = this.newDb.getStorage();
            if (OGlobalConfiguration.INDEX_FLUSH_AFTER_CREATE.getValueAsBoolean()) {
                storage.synch();
            }
            OIndexManagerShared.this.rebuildCompleted = true;
            OLogManager.instance().info((Object)this, "%d indexes were restored successfully, %d errors", new Object[]{this.ok, this.errors});
        }

        private void recreateIndex(ODocument idx) {
            OIndexInternal<?> index = this.createIndex(idx);
            OIndexInternal.IndexMetadata indexMetadata = index.loadMetadata(idx);
            OIndexDefinition indexDefinition = indexMetadata.getIndexDefinition();
            if (indexDefinition != null && indexDefinition.isAutomatic()) {
                this.createAutomaticIndex(idx, index, indexMetadata, indexDefinition);
            } else {
                this.addIndexAsIs(idx, index, indexMetadata);
            }
        }

        private void createAutomaticIndex(ODocument idx, OIndexInternal<?> index, OIndexInternal.IndexMetadata indexMetadata, OIndexDefinition indexDefinition) {
            String indexName = indexMetadata.getName();
            Set<String> clusters = indexMetadata.getClustersToIndex();
            String type = indexMetadata.getType();
            if (indexName != null && clusters != null && !clusters.isEmpty() && type != null) {
                OLogManager.instance().info((Object)this, "Start creation of index %s", new Object[]{indexName});
                index.deleteWithoutIndexLoad(indexName);
                index.create(indexName, indexDefinition, OIndexManagerShared.this.defaultClusterName, clusters, false, new OIndexRebuildOutputListener(index));
                index.setRebuildingFlag();
                OIndexManagerShared.this.addIndexInternal(index);
                OLogManager.instance().info((Object)this, "Index %s was successfully created and rebuild is going to be started.", new Object[]{indexName});
                index.rebuild(new OIndexRebuildOutputListener(index));
                index.flush();
                OIndexManagerShared.this.setDirty();
                ++this.ok;
                OLogManager.instance().info((Object)this, "Rebuild of %s index was successfully finished.", new Object[]{indexName});
            } else {
                ++this.errors;
                OLogManager.instance().error((Object)this, "Information about index was restored incorrectly, following data were loaded : index name - %s, index definition %s, clusters %s, type %s.", new Object[]{indexName, indexDefinition, clusters, type});
            }
        }

        private void addIndexAsIs(ODocument idx, OIndexInternal<?> index, OIndexInternal.IndexMetadata indexMetadata) {
            OLogManager.instance().info((Object)this, "Index %s is not automatic index and will be added as is.", new Object[]{indexMetadata.getName()});
            if (index.loadFromConfiguration(idx)) {
                OIndexManagerShared.this.addIndexInternal(index);
                OIndexManagerShared.this.setDirty();
                ++this.ok;
                OLogManager.instance().info((Object)this, "Index %s was added in DB index list.", new Object[]{index.getName()});
            } else {
                OIndexManagerShared.this.getDatabase().unregisterListener(index.getInternal());
                index.delete();
                ++this.errors;
            }
        }

        private OIndexInternal<?> createIndex(ODocument idx) {
            String valueContainerAlgorithm;
            String indexType = (String)idx.field("type");
            String algorithm = (String)idx.field("algorithm");
            if (algorithm.equals("MVRBTREE")) {
                algorithm = "SBTREE";
                idx.field("algorithm", algorithm);
            }
            if ("MVRBTREESET".equals(valueContainerAlgorithm = (String)idx.field("valueContainerAlgorithm"))) {
                valueContainerAlgorithm = "SBTREEBONSAISET";
                idx.field("valueContainerAlgorithm", valueContainerAlgorithm);
            }
            ODocument metadata = (ODocument)idx.field("metadata");
            if (indexType == null) {
                OLogManager.instance().error((Object)this, "Index type is null, will process other record.", new Object[0]);
                throw new OException("Index type is null, will process other record. Index configuration: " + idx.toString());
            }
            return OIndexes.createIndex(this.newDb, indexType, algorithm, valueContainerAlgorithm, metadata);
        }

        private Collection<ODocument> getConfiguration() {
            Collection idxs = (Collection)this.doc.field("indexes");
            if (idxs == null) {
                OLogManager.instance().warn((Object)this, "List of indexes is empty.", new Object[0]);
                return Collections.emptyList();
            }
            return idxs;
        }

        private void setUpDatabase() {
            this.newDb.setProperty(ODatabase.OPTIONS.SECURITY.toString(), Boolean.FALSE);
            this.newDb.open("admin", "nopass");
            ODatabaseRecordThreadLocal.INSTANCE.set(this.newDb);
        }
    }
}

