/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.index.OIndex;

public class OIndexRebuildOutputListener
implements OProgressListener {
    private final OIndex<?> idx;
    long startTime;
    long lastDump;
    long lastCounter = 0L;
    boolean rebuild = false;

    public OIndexRebuildOutputListener(OIndex<?> idx) {
        this.idx = idx;
    }

    public void onBegin(Object iTask, long iTotal, Object iRebuild) {
        this.lastDump = this.startTime = System.currentTimeMillis();
        this.rebuild = (Boolean)iRebuild;
        if (iTotal > 0L) {
            if (this.rebuild) {
                OLogManager.instance().info((Object)this, "- Rebuilding index %s.%s (estimated %d items)...", new Object[]{this.idx.getDatabaseName(), this.idx.getName(), iTotal});
            } else {
                OLogManager.instance().debug((Object)this, "- Building index %s.%s (estimated %d items)...", new Object[]{this.idx.getDatabaseName(), this.idx.getName(), iTotal});
            }
        }
    }

    public boolean onProgress(Object iTask, long iCounter, float iPercent) {
        long now = System.currentTimeMillis();
        if (now - this.lastDump > 10000L) {
            if (this.rebuild) {
                OLogManager.instance().info((Object)this, "--> %3.2f%% progress, %,d indexed so far (%,d items/sec)", new Object[]{Float.valueOf(iPercent), iCounter, (iCounter - this.lastCounter) / 10L});
            } else {
                OLogManager.instance().debug((Object)this, "--> %3.2f%% progress, %,d indexed so far (%,d items/sec)", new Object[]{Float.valueOf(iPercent), iCounter, (iCounter - this.lastCounter) / 10L});
            }
            this.lastDump = now;
            this.lastCounter = iCounter;
        }
        return true;
    }

    public void onCompletition(Object iTask, boolean iSucceed) {
        long idxSize = this.idx.getSize();
        if (idxSize > 0L) {
            if (this.rebuild) {
                OLogManager.instance().info((Object)this, "--> OK, indexed %,d items in %,d ms", new Object[]{idxSize, System.currentTimeMillis() - this.startTime});
            } else {
                OLogManager.instance().debug((Object)this, "--> OK, indexed %,d items in %,d ms", new Object[]{idxSize, System.currentTimeMillis() - this.startTime});
            }
        }
    }
}

