/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexRemote;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class OIndexRemoteMultiValue
extends OIndexRemote<Collection<OIdentifiable>> {
    protected static final String QUERY_GET = "select EXPAND( rid ) from index:%s where key = ?";

    public OIndexRemoteMultiValue(String iName, String iWrappedType, ORID iRid, OIndexDefinition iIndexDefinition, ODocument iConfiguration, Set<String> clustersToIndex) {
        super(iName, iWrappedType, iRid, iIndexDefinition, iConfiguration, clustersToIndex);
    }

    @Override
    public Collection<OIdentifiable> get(Object iKey) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET, this.name);
        return new HashSet<OIdentifiable>((Collection)this.getDatabase().command(cmd).execute(iKey));
    }

    public Iterator<Map.Entry<Object, Collection<OIdentifiable>>> iterator() {
        OCommandRequest cmd = this.formatCommand("select key, rid from index:%s", this.name);
        Collection result = (Collection)this.getDatabase().command(cmd).execute(new Object[0]);
        LinkedHashMap map = new LinkedHashMap();
        for (ODocument d : result) {
            HashSet<OIdentifiable> rids = (HashSet<OIdentifiable>)map.get(d.field("key"));
            if (rids == null) {
                rids = new HashSet<OIdentifiable>();
                map.put(d.field("key"), rids);
            }
            rids.add((OIdentifiable)d.field("rid", OType.LINK));
        }
        return map.entrySet().iterator();
    }

    public Iterator<Map.Entry<Object, Collection<OIdentifiable>>> inverseIterator() {
        OCommandRequest cmd = this.formatCommand("select key, rid from index:%s", this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        LinkedHashMap map = new LinkedHashMap();
        ListIterator it = result.listIterator();
        while (it.hasPrevious()) {
            ODocument d = (ODocument)it.previous();
            HashSet<OIdentifiable> rids = (HashSet<OIdentifiable>)map.get(d.field("key"));
            if (rids == null) {
                rids = new HashSet<OIdentifiable>();
                map.put(d.field("key"), rids);
            }
            rids.add((OIdentifiable)d.field("rid", OType.LINK));
        }
        return map.entrySet().iterator();
    }

    public Iterator<OIdentifiable> valuesIterator() {
        throw new UnsupportedOperationException();
    }

    public Iterator<OIdentifiable> valuesInverseIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }
}

