/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OIndexUnique
extends OIndexOneValue {
    public OIndexUnique(String typeId, String algorithm, OIndexEngine<OIdentifiable> engine, String valueContainerAlgorithm) {
        super(typeId, algorithm, engine, valueContainerAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexOneValue put(Object key, OIdentifiable iSingleValue) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        this.modificationLock.requestModificationLock();
        try {
            block10: {
                OIndexUnique oIndexUnique;
                this.checkForKeyType(key);
                this.acquireExclusiveLock();
                try {
                    OIdentifiable value = (OIdentifiable)this.indexEngine.get(key);
                    if (value == null) break block10;
                    if (!value.equals(iSingleValue)) {
                        throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", iSingleValue.getIdentity(), key, this.getName(), value.getIdentity()), value.getIdentity());
                    }
                    oIndexUnique = this;
                }
                catch (Throwable throwable) {
                    this.releaseExclusiveLock();
                    throw throwable;
                }
                this.releaseExclusiveLock();
                return oIndexUnique;
            }
            if (!iSingleValue.getIdentity().isPersistent()) {
                iSingleValue.getRecord().save();
            }
            this.indexEngine.put(key, iSingleValue.getIdentity());
            OIndexUnique oIndexUnique = this;
            this.releaseExclusiveLock();
            return oIndexUnique;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        Object snapshotValue = snapshot.get(key = this.getCollatingValue(key));
        if (snapshotValue == null) {
            OIdentifiable storedValue = (OIdentifiable)this.indexEngine.get(key);
            LinkedHashSet<ORID> values = new LinkedHashSet<ORID>();
            if (storedValue != null) {
                values.add(storedValue.getIdentity());
            }
            values.add(value.getIdentity());
            snapshot.put(key, values);
        } else if (snapshotValue instanceof Set) {
            Set values = (Set)snapshotValue;
            values.add(value.getIdentity());
        } else {
            LinkedHashSet<OIdentifiable> values = new LinkedHashSet<OIdentifiable>();
            values.add(value);
            snapshot.put(key, values);
        }
    }

    @Override
    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        Object snapshotValue = snapshot.get(key = this.getCollatingValue(key));
        if (snapshotValue instanceof Set) {
            Set values = (Set)snapshotValue;
            if (values.isEmpty()) {
                snapshot.put(key, OIndexAbstract.RemovedValue.INSTANCE);
            } else {
                values.remove(value);
            }
        } else {
            snapshot.put(key, OIndexAbstract.RemovedValue.INSTANCE);
        }
    }

    @Override
    protected void commitSnapshot(Map<Object, Object> snapshot) {
        for (Map.Entry<Object, Object> snapshotEntry : snapshot.entrySet()) {
            Object key = snapshotEntry.getKey();
            this.checkForKeyType(key);
            Object snapshotValue = snapshotEntry.getValue();
            if (snapshotValue instanceof Set) {
                Set values = (Set)snapshotValue;
                if (values.isEmpty()) continue;
                Iterator valuesIterator = values.iterator();
                if (values.size() > 1) {
                    OIdentifiable valueOne = (OIdentifiable)valuesIterator.next();
                    OIdentifiable valueTwo = (OIdentifiable)valuesIterator.next();
                    throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", valueTwo.getIdentity(), key, this.getName(), valueOne.getIdentity()), valueOne.getIdentity());
                }
                OIdentifiable value = (OIdentifiable)valuesIterator.next();
                this.indexEngine.put(key, value.getIdentity());
                continue;
            }
            if (snapshotValue.equals(OIndexAbstract.RemovedValue.INSTANCE)) {
                this.indexEngine.remove(key);
                continue;
            }
            assert (false) : "Provided value can not be committed";
        }
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return this.indexEngine.hasRangeQuerySupport();
    }
}

