/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.mvrbtree.OMVRBTree;
import com.orientechnologies.orient.core.index.mvrbtree.OMVRBTreeEntry;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeDatabaseLazySave;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProviderAbstract;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public final class OMVRBTreeIndexEngine<V>
extends OSharedResourceAdaptiveExternal
implements OIndexEngine<V> {
    private int maxUpdatesBeforeSave;
    private OMemoryWatchDog.Listener watchDog;
    private OMVRBTreeDatabaseLazySave<Object, V> map;

    public OMVRBTreeIndexEngine() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);
    }

    @Override
    public void init() {
        this.acquireExclusiveLock();
        try {
            this.watchDog = new OMemoryWatchDog.Listener(){

                @Override
                public void lowMemory(long iFreeMemory, long iFreeMemoryPercentage) {
                    OMVRBTreeIndexEngine.this.map.setOptimization(iFreeMemoryPercentage < 10L ? 2 : 1);
                }
            };
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void flush() {
        this.acquireExclusiveLock();
        try {
            this.map.lazySave();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String indexName, OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.acquireExclusiveLock();
        try {
            this.maxUpdatesBeforeSave = this.lazyUpdates(isAutomatic);
            if (indexDefinition != null) {
                if (indexDefinition instanceof ORuntimeKeyIndexDefinition) {
                    this.map = new OMVRBTreeDatabaseLazySave(clusterIndexName, ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer(), valueSerializer, 1, this.maxUpdatesBeforeSave);
                } else {
                    OBinarySerializer keySerializer = indexDefinition.getTypes().length > 1 ? OCompositeKeySerializer.INSTANCE : OBinarySerializerFactory.getInstance().getObjectSerializer(indexDefinition.getTypes()[0]);
                    this.map = new OMVRBTreeDatabaseLazySave(clusterIndexName, keySerializer, valueSerializer, indexDefinition.getTypes().length, this.maxUpdatesBeforeSave);
                }
            } else {
                this.map = new OMVRBTreeDatabaseLazySave(clusterIndexName, new OSimpleKeySerializer(), valueSerializer, 1, this.maxUpdatesBeforeSave);
            }
            this.installHooks(indexName);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void installHooks(String indexName) {
        OProfilerMBean profiler = Orient.instance().getProfiler();
        String profilerPrefix = profiler.getDatabaseMetric(this.getDatabase().getName(), "index." + indexName + '.');
        String profilerMetadataPrefix = "db.*.index.*.";
        profiler.registerHookValue(profilerPrefix + "items", "Index size", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                OMVRBTreeIndexEngine.this.acquireSharedLock();
                try {
                    String string = OMVRBTreeIndexEngine.this.map != null ? Integer.valueOf(OMVRBTreeIndexEngine.this.map.size()) : "-";
                    return string;
                }
                finally {
                    OMVRBTreeIndexEngine.this.releaseSharedLock();
                }
            }
        }, "db.*.index.*.items");
        profiler.registerHookValue(profilerPrefix + "entryPointSize", "Number of entrypoints in an index", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMVRBTreeIndexEngine.this.map != null ? Integer.valueOf(OMVRBTreeIndexEngine.this.map.getEntryPointSize()) : "-";
            }
        }, "db.*.index.*.items");
        profiler.registerHookValue(profilerPrefix + "maxUpdateBeforeSave", "Maximum number of updates in a index before force saving", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMVRBTreeIndexEngine.this.map != null ? Integer.valueOf(OMVRBTreeIndexEngine.this.map.getMaxUpdatesBeforeSave()) : "-";
            }
        }, "db.*.index.*.maxUpdateBeforeSave");
        Orient.instance().getMemoryWatchDog().addListener(this.watchDog);
    }

    @Override
    public void delete() {
        this.acquireExclusiveLock();
        try {
            if (this.map != null) {
                this.map.delete();
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void deleteWithoutLoad(String indexName) {
        throw new UnsupportedOperationException("deleteWithoutLoad");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(ORID indexRid, String indexName, OIndexDefinition indexDefinition, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.acquireExclusiveLock();
        try {
            this.maxUpdatesBeforeSave = this.lazyUpdates(isAutomatic);
            this.map = new OMVRBTreeDatabaseLazySave(this.getDatabase(), indexRid, this.maxUpdatesBeforeSave);
            this.map.load();
            this.installHooks(indexName);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean contains(Object key) {
        this.acquireExclusiveLock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ORID getIdentity() {
        this.acquireSharedLock();
        try {
            ORID oRID = ((OMVRBTreeProviderAbstract)this.map.getProvider()).getRecord().getIdentity();
            return oRID;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void clear() {
        this.acquireExclusiveLock();
        try {
            this.map.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean remove(Object key) {
        this.acquireExclusiveLock();
        try {
            boolean bl = this.map.remove(key) != null;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            rangeFrom = fromInclusive ? this.map.enhanceCompositeKey(rangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.enhanceCompositeKey(rangeFrom, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY);
            rangeTo = toInclusive ? this.map.enhanceCompositeKey(rangeTo, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.enhanceCompositeKey(rangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            if (ascSortOrder) {
                OMBRBTreeIndexCursor oMBRBTreeIndexCursor = new OMBRBTreeIndexCursor(this.map.subMap(rangeFrom, fromInclusive, rangeTo, toInclusive).entrySet().iterator(), transformer);
                return oMBRBTreeIndexCursor;
            }
            OMBRBTreeIndexCursor oMBRBTreeIndexCursor = new OMBRBTreeIndexCursor(this.map.subMap(rangeFrom, fromInclusive, rangeTo, toInclusive).descendingMap().entrySet().iterator(), transformer);
            return oMBRBTreeIndexCursor;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            fromKey = isInclusive ? this.map.enhanceCompositeKey(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.enhanceCompositeKey(fromKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY);
            if (ascSortOrder) {
                OMBRBTreeIndexCursor oMBRBTreeIndexCursor = new OMBRBTreeIndexCursor(this.map.tailMap(fromKey, isInclusive).entrySet().iterator(), transformer);
                return oMBRBTreeIndexCursor;
            }
            OMBRBTreeIndexCursor oMBRBTreeIndexCursor = new OMBRBTreeIndexCursor(this.map.tailMap(fromKey, isInclusive).descendingMap().entrySet().iterator(), transformer);
            return oMBRBTreeIndexCursor;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            toKey = isInclusive ? this.map.enhanceCompositeKey(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.enhanceCompositeKey(toKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            if (ascSortOrder) {
                OMBRBTreeIndexCursor oMBRBTreeIndexCursor = new OMBRBTreeIndexCursor(this.map.headMap(toKey, isInclusive).entrySet().iterator(), transformer);
                return oMBRBTreeIndexCursor;
            }
            OMBRBTreeIndexCursor oMBRBTreeIndexCursor = new OMBRBTreeIndexCursor(this.map.headMap(toKey, isInclusive).descendingMap().entrySet().iterator(), transformer);
            return oMBRBTreeIndexCursor;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void unload() {
        this.acquireExclusiveLock();
        try {
            this.map.unload();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void startTransaction() {
        this.acquireExclusiveLock();
        try {
            this.map.setRunningTransaction(true);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void stopTransaction() {
        this.acquireExclusiveLock();
        try {
            this.map.setRunningTransaction(false);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void afterTxRollback() {
        this.acquireExclusiveLock();
        try {
            this.map.unload();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void afterTxCommit() {
        this.acquireExclusiveLock();
        try {
            this.map.onAfterTxCommit();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void closeDb() {
        this.acquireExclusiveLock();
        try {
            this.map.commitChanges(true);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void beforeTxBegin() {
        this.acquireExclusiveLock();
        try {
            this.map.commitChanges(true);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public V get(Object key) {
        this.acquireExclusiveLock();
        try {
            Object v = this.map.get(key);
            return v;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void put(Object key, V value) {
        this.acquireExclusiveLock();
        try {
            this.map.put(key, value);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Object getFirstKey() {
        this.acquireExclusiveLock();
        try {
            if (this.map.getFirstEntry() == null) {
                Object var1_1 = null;
                return var1_1;
            }
            Object k = this.map.getFirstEntry().getFirstKey();
            return k;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Object getLastKey() {
        this.acquireExclusiveLock();
        try {
            Object k = this.map.getLastEntry().getLastKey();
            return k;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        this.acquireExclusiveLock();
        try {
            if (valuesTransformer == null) {
                long l = this.map.size();
                return l;
            }
            OMVRBTreeEntry rootEntry = this.map.getRoot();
            long size = 0L;
            OMVRBTreeEntry currentEntry = rootEntry;
            this.map.setPageIndex(0);
            while (currentEntry != null) {
                size += (long)valuesTransformer.transformFromValue(currentEntry.getValue()).size();
                currentEntry = OMVRBTree.next(currentEntry);
            }
            this.map.setPageIndex(0);
            currentEntry = OMVRBTree.previous(rootEntry);
            while (currentEntry != null) {
                size += (long)valuesTransformer.transformFromValue(currentEntry.getValue()).size();
                currentEntry = OMVRBTree.previous(currentEntry);
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexCursor cursor(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        this.acquireExclusiveLock();
        try {
            OMBRBTreeIndexCursor oMBRBTreeIndexCursor = new OMBRBTreeIndexCursor(this.map.entrySet().iterator(), valuesTransformer);
            return oMBRBTreeIndexCursor;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        this.acquireExclusiveLock();
        try {
            OIndexKeyCursor oIndexKeyCursor = new OIndexKeyCursor(){
                private final Iterator<Object> keysIterator;
                {
                    this.keysIterator = OMVRBTreeIndexEngine.this.map.keySet().iterator();
                }

                @Override
                public Object next(int prefetchSize) {
                    if (this.keysIterator.hasNext()) {
                        return this.keysIterator.next();
                    }
                    return null;
                }
            };
            return oIndexKeyCursor;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private int lazyUpdates(boolean isAutomatic) {
        return isAutomatic ? OGlobalConfiguration.INDEX_AUTO_LAZY_UPDATES.getValueAsInteger() : OGlobalConfiguration.INDEX_MANUAL_LAZY_UPDATES.getValueAsInteger();
    }

    private final class OMBRBTreeIndexCursor
    extends OIndexAbstractCursor {
        private final Iterator<Map.Entry<Object, V>> treeIterator;
        private final OIndexEngine.ValuesTransformer<V> valuesTransformer;
        private Iterator<OIdentifiable> currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
        private Object currentKey = null;

        private OMBRBTreeIndexCursor(Iterator<Map.Entry<Object, V>> treeIterator, OIndexEngine.ValuesTransformer<V> valuesTransformer) {
            this.treeIterator = treeIterator;
            this.valuesTransformer = valuesTransformer;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.currentIterator.hasNext()) {
                return this.nextCollectionEntry();
            }
            if (!this.treeIterator.hasNext()) {
                return null;
            }
            if (this.valuesTransformer == null) {
                Map.Entry entry = this.treeIterator.next();
                this.currentKey = entry.getKey();
                this.currentIterator = Collections.singletonList((OIdentifiable)entry.getValue()).iterator();
            } else {
                while (!this.currentIterator.hasNext() && this.treeIterator.hasNext()) {
                    Map.Entry entry = this.treeIterator.next();
                    this.currentKey = entry.getKey();
                    this.currentIterator = this.valuesTransformer.transformFromValue(entry.getValue()).iterator();
                }
            }
            if (!this.currentIterator.hasNext()) {
                return null;
            }
            return this.nextCollectionEntry();
        }

        private Map.Entry<Object, OIdentifiable> nextCollectionEntry() {
            final OIdentifiable value = this.currentIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){

                @Override
                public Object getKey() {
                    return OMBRBTreeIndexCursor.this.currentKey;
                }

                @Override
                public OIdentifiable getValue() {
                    return value;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value2) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }
}

