/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OLocalHashTableIndexEngine;
import com.orientechnologies.orient.core.index.engine.OMemoryHashMapIndexEngine;
import com.orientechnologies.orient.core.index.engine.ORemoteIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OHashIndexFactory
implements OIndexFactory {
    private static final Set<String> TYPES;
    public static final String SBTREE_ALGORITHM = "SBTREE";
    public static final String MVRBTREE_ALGORITHM = "MVRBTREE";
    private static final Set<String> ALGORITHMS;

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    @Override
    public OIndexInternal<?> createIndex(ODatabaseRecord database, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata) throws OConfigurationException {
        OMemoryHashMapIndexEngine<Set<OIdentifiable>> indexEngine;
        OStorage storage;
        String storageType;
        if (valueContainerAlgorithm == null) {
            valueContainerAlgorithm = OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(indexType) || OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(indexType) || OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString().equals(indexType) || OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType) ? "MVRBTREESET" : "NONE";
        }
        if ((database.getStorage().getType().equals("plocal") || database.getStorage().getType().equals("local")) && valueContainerAlgorithm.equals("MVRBTREESET") && OGlobalConfiguration.INDEX_NOTUNIQUE_USE_SBTREE_CONTAINER_BY_DEFAULT.getValueAsBoolean()) {
            OLogManager.instance().warn((Object)this, "Index was created using %s as values container. This container is deprecated and is not supported any more. To avoid this message please drop and recreate indexes or perform DB export/import.", new Object[]{valueContainerAlgorithm});
        }
        if ((storageType = (storage = database.getStorage()).getType()).equals("memory")) {
            indexEngine = new OMemoryHashMapIndexEngine();
        } else if (storageType.equals("local") || storageType.equals("plocal")) {
            indexEngine = new OLocalHashTableIndexEngine();
        } else if (storageType.equals("distributed")) {
            indexEngine = new OLocalHashTableIndexEngine();
        } else if (storageType.equals("remote")) {
            indexEngine = new ORemoteIndexEngine();
        } else {
            throw new OIndexException("Unsupported storage type : " + storageType);
        }
        if (OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexUnique(indexType, algorithm, (OIndexEngine<OIdentifiable>)indexEngine, valueContainerAlgorithm);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexNotUnique(indexType, algorithm, (OIndexEngine<Set<OIdentifiable>>)indexEngine, valueContainerAlgorithm);
        }
        if (OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexFullText(indexType, algorithm, indexEngine, valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexDictionary(indexType, algorithm, (OIndexEngine<OIdentifiable>)indexEngine, valueContainerAlgorithm);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(SBTREE_ALGORITHM);
        algorithms.add(MVRBTREE_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

