/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;

public class OCacheEntry {
    OCachePointer dataPointer;
    final long fileId;
    final long pageIndex;
    boolean isDirty;
    int usagesCount;

    public OCacheEntry(long fileId, long pageIndex, OCachePointer dataPointer, boolean dirty) {
        this.fileId = fileId;
        this.pageIndex = pageIndex;
        this.dataPointer = dataPointer;
        this.isDirty = dirty;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public OCachePointer getCachePointer() {
        return this.dataPointer;
    }

    public long getFileId() {
        return this.fileId;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public void acquireExclusiveLock() {
        this.dataPointer.acquireExclusiveLock();
    }

    public void releaseExclusiveLock() {
        this.dataPointer.releaseExclusiveLock();
    }

    public void acquireSharedLock() {
        this.dataPointer.acquireSharedLock();
    }

    public void releaseSharedLock() {
        this.dataPointer.releaseSharedLock();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCacheEntry that = (OCacheEntry)o;
        if (this.fileId != that.fileId) {
            return false;
        }
        if (this.isDirty != that.isDirty) {
            return false;
        }
        if (this.pageIndex != that.pageIndex) {
            return false;
        }
        if (this.usagesCount != that.usagesCount) {
            return false;
        }
        return !(this.dataPointer != null ? !this.dataPointer.equals(that.dataPointer) : that.dataPointer != null);
    }

    public int hashCode() {
        int result = (int)(this.fileId ^ this.fileId >>> 32);
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        result = 31 * result + (this.dataPointer != null ? this.dataPointer.hashCode() : 0);
        result = 31 * result + (this.isDirty ? 1 : 0);
        result = 31 * result + this.usagesCount;
        return result;
    }

    public String toString() {
        return "OReadCacheEntry{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + ", dataPointer=" + this.dataPointer + ", isDirty=" + this.isDirty + ", usagesCount=" + this.usagesCount + '}';
    }
}

