/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OAllCacheEntriesAreUsedException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.LRUList;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OWOWCache;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Future;

public class OReadWriteDiskCache
implements ODiskCache {
    public static final int MIN_CACHE_SIZE = 256;
    private int maxSize;
    private int K_IN;
    private int K_OUT;
    private LRUList am;
    private LRUList a1out;
    private LRUList a1in;
    private final OWOWCache writeCache;
    private final int pageSize;
    private final Map<Long, Set<Long>> filePages;
    private final Object syncObject;
    private final NavigableMap<PinnedPage, OCacheEntry> pinnedPages = new TreeMap<PinnedPage, OCacheEntry>();
    private final String storageName;
    private static String METRIC_HITS;
    private static String METRIC_HITS_METADATA;
    private static String METRIC_MISSED;
    private static String METRIC_MISSED_METADATA;

    public OReadWriteDiskCache(long readCacheMaxMemory, long writeCacheMaxMemory, int pageSize, long writeGroupTTL, int pageFlushInterval, OStorageLocalAbstract storageLocal, OWriteAheadLog writeAheadLog, boolean syncOnPageFlush, boolean checkMinSize) {
        this(null, readCacheMaxMemory, writeCacheMaxMemory, pageSize, writeGroupTTL, pageFlushInterval, storageLocal, writeAheadLog, syncOnPageFlush, checkMinSize);
    }

    public OReadWriteDiskCache(String storageName, long readCacheMaxMemory, long writeCacheMaxMemory, int pageSize, long writeGroupTTL, int pageFlushInterval, OStorageLocalAbstract storageLocal, OWriteAheadLog writeAheadLog, boolean syncOnPageFlush, boolean checkMinSize) {
        this.storageName = storageName;
        this.pageSize = pageSize;
        this.initProfiler();
        this.filePages = new HashMap<Long, Set<Long>>();
        this.maxSize = this.normalizeMemory(readCacheMaxMemory, pageSize);
        if (checkMinSize && this.maxSize < 256) {
            this.maxSize = 256;
        }
        this.writeCache = new OWOWCache(syncOnPageFlush, pageSize, writeGroupTTL, writeAheadLog, pageFlushInterval, this.normalizeMemory(writeCacheMaxMemory, pageSize), storageLocal, checkMinSize);
        this.K_IN = this.maxSize >> 2;
        this.K_OUT = this.maxSize >> 1;
        this.am = new LRUList();
        this.a1out = new LRUList();
        this.a1in = new LRUList();
        this.syncObject = new Object();
    }

    LRUList getAm() {
        return this.am;
    }

    LRUList getA1out() {
        return this.a1out;
    }

    LRUList getA1in() {
        return this.a1in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openFile(String fileName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            long fileId = this.writeCache.isOpen(fileName);
            if (fileId >= 0L) {
                return fileId;
            }
            fileId = this.writeCache.openFile(fileName);
            this.filePages.put(fileId, new HashSet());
            return fileId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.writeCache.isOpen(fileId)) {
                return;
            }
            this.writeCache.openFile(fileId);
            this.filePages.put(fileId, new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(String fileName, long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            long existingFileId = this.writeCache.isOpen(fileName);
            if (fileId == existingFileId) {
                return;
            }
            if (existingFileId >= 0L) {
                throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            this.writeCache.openFile(fileName, fileId);
            this.filePages.put(fileId, new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fileName) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.writeCache.exists(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.writeCache.exists(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileNameById(long fileId) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.writeCache.fileNameById(fileId);
        }
    }

    @Override
    public void lock() throws IOException {
        this.writeCache.lock();
    }

    @Override
    public void unlock() throws IOException {
        this.writeCache.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinPage(OCacheEntry cacheEntry) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.remove(cacheEntry.fileId, cacheEntry.pageIndex);
            this.pinnedPages.put(new PinnedPage(cacheEntry.fileId, cacheEntry.pageIndex), cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadPinnedPage(OCacheEntry cacheEntry) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            ++cacheEntry.usagesCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry load(long fileId, long pageIndex, boolean checkPinnedPages) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            OCacheEntry cacheEntry = null;
            if (checkPinnedPages) {
                cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
            }
            if (cacheEntry == null) {
                cacheEntry = this.updateCache(fileId, pageIndex);
            }
            ++cacheEntry.usagesCount;
            return cacheEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry allocateNewPage(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            long filledUpTo = this.getFilledUpTo(fileId);
            return this.load(fileId, filledUpTo, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(OCacheEntry cacheEntry) {
        Future flushFuture = null;
        Object object = this.syncObject;
        synchronized (object) {
            if (cacheEntry != null) {
                --cacheEntry.usagesCount;
            } else {
                throw new IllegalStateException("record should be released is already free!");
            }
            if (cacheEntry.usagesCount == 0 && cacheEntry.isDirty) {
                flushFuture = this.writeCache.store(cacheEntry.fileId, cacheEntry.pageIndex, cacheEntry.dataPointer);
                cacheEntry.isDirty = false;
            }
        }
        if (flushFuture != null) {
            try {
                flushFuture.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new OException("File flush was interrupted", (Throwable)e);
            }
            catch (Exception e) {
                throw new OException("File flush was abnormally terminated", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            return this.writeCache.getFilledUpTo(fileId);
        }
    }

    @Override
    public void flushFile(long fileId) throws IOException {
        this.writeCache.flush(fileId);
    }

    @Override
    public void closeFile(long fileId) throws IOException {
        this.closeFile(fileId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(long fileId, boolean flush) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.writeCache.close(fileId, flush);
            Set<Long> pageIndexes = this.filePages.get(fileId);
            for (Long pageIndex : pageIndexes) {
                OCacheEntry cacheEntry = this.get(fileId, pageIndex, true);
                if (cacheEntry == null) {
                    cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
                }
                if (cacheEntry != null) {
                    if (cacheEntry.dataPointer == null) continue;
                    if (cacheEntry.usagesCount == 0) {
                        cacheEntry = this.remove(fileId, pageIndex);
                        if (cacheEntry == null) {
                            cacheEntry = (OCacheEntry)this.pinnedPages.remove(new PinnedPage(fileId, pageIndex));
                        }
                    } else {
                        throw new OStorageException("Page with index " + pageIndex + " for file with id " + fileId + " can not be freed because it is used.");
                    }
                    cacheEntry.dataPointer.decrementReferrer();
                    cacheEntry.dataPointer = null;
                    continue;
                }
                throw new OStorageException("Page with index " + pageIndex + " for file with id " + fileId + " was not found in cache");
            }
            pageIndexes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.isOpen(fileId)) {
                this.truncateFile(fileId);
            }
            this.writeCache.deleteFile(fileId);
            this.filePages.remove(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.writeCache.truncateFile(fileId);
            Set<Long> pageEntries = this.filePages.get(fileId);
            for (Long pageIndex : pageEntries) {
                OCacheEntry cacheEntry = this.get(fileId, pageIndex, true);
                if (cacheEntry == null) {
                    cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
                }
                if (cacheEntry != null) {
                    if (cacheEntry.usagesCount != 0) continue;
                    cacheEntry = this.remove(fileId, pageIndex);
                    if (cacheEntry == null) {
                        cacheEntry = (OCacheEntry)this.pinnedPages.remove(new PinnedPage(fileId, pageIndex));
                    }
                    if (cacheEntry.dataPointer == null) continue;
                    cacheEntry.dataPointer.decrementReferrer();
                    cacheEntry.dataPointer = null;
                    continue;
                }
                throw new OStorageException("Page with index " + pageIndex + " was  not found in cache for file with id " + fileId);
            }
            pageEntries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.writeCache.renameFile(fileId, oldFileName, newFileName);
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        this.writeCache.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        this.writeCache.flush();
        Object object = this.syncObject;
        synchronized (object) {
            this.clearCacheContent();
        }
    }

    private void clearCacheContent() {
        for (OCacheEntry oCacheEntry : this.am) {
            if (oCacheEntry.usagesCount == 0) {
                oCacheEntry.dataPointer.decrementReferrer();
                oCacheEntry.dataPointer = null;
                continue;
            }
            throw new OStorageException("Page with index " + oCacheEntry.pageIndex + " for file id " + oCacheEntry.fileId + " is used and can not be removed");
        }
        for (OCacheEntry oCacheEntry : this.a1in) {
            if (oCacheEntry.usagesCount == 0) {
                oCacheEntry.dataPointer.decrementReferrer();
                oCacheEntry.dataPointer = null;
                continue;
            }
            throw new OStorageException("Page with index " + oCacheEntry.pageIndex + " for file id " + oCacheEntry.fileId + " is used and can not be removed");
        }
        this.a1out.clear();
        this.am.clear();
        this.a1in.clear();
        for (Set set : this.filePages.values()) {
            set.clear();
        }
        this.clearPinnedPages();
    }

    private void clearPinnedPages() {
        for (OCacheEntry pinnedEntry : this.pinnedPages.values()) {
            if (pinnedEntry.usagesCount == 0) {
                pinnedEntry.dataPointer.decrementReferrer();
                pinnedEntry.dataPointer = null;
                continue;
            }
            throw new OStorageException("Page with index " + pinnedEntry.pageIndex + " for file with id " + pinnedEntry.fileId + "can not be freed because it is used.");
        }
        this.pinnedPages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.clear();
            this.writeCache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasSoftlyClosed(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            return this.writeCache.wasSoftlyClosed(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoftlyClosed(long fileId, boolean softlyClosed) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.writeCache.setSoftlyClosed(fileId, softlyClosed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.writeCache.setSoftlyClosed(softlyClosed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen(long fileId) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.writeCache.isOpen(fileId);
        }
    }

    private OCacheEntry updateCache(long fileId, long pageIndex) throws IOException {
        OProfilerMBean profiler = this.storageName != null ? Orient.instance().getProfiler() : null;
        long startTime = this.storageName != null ? System.currentTimeMillis() : 0L;
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            this.am.putToMRU(cacheEntry);
            if (profiler != null && profiler.isRecording()) {
                profiler.stopChrono(METRIC_HITS, "Requested item was found in Disk Cache", startTime, METRIC_HITS_METADATA);
            }
            return cacheEntry;
        }
        if (profiler != null && profiler.isRecording()) {
            profiler.stopChrono(METRIC_MISSED, "Requested item was not found in Disk Cache", startTime, METRIC_MISSED_METADATA);
        }
        if ((cacheEntry = this.a1out.remove(fileId, pageIndex)) != null) {
            this.removeColdestPageIfNeeded();
            OCachePointer dataPointer = this.writeCache.load(fileId, pageIndex);
            assert (cacheEntry.dataPointer == null);
            assert (!cacheEntry.isDirty);
            cacheEntry.dataPointer = dataPointer;
            this.am.putToMRU(cacheEntry);
            return cacheEntry;
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        this.removeColdestPageIfNeeded();
        OCachePointer dataPointer = this.writeCache.load(fileId, pageIndex);
        cacheEntry = new OCacheEntry(fileId, pageIndex, dataPointer, false);
        this.a1in.putToMRU(cacheEntry);
        Set<Long> pages = this.filePages.get(fileId);
        if (pages == null) {
            pages = new HashSet<Long>();
            this.filePages.put(fileId, pages);
        }
        pages.add(pageIndex);
        return cacheEntry;
    }

    private void removeColdestPageIfNeeded() throws IOException {
        if (this.am.size() + this.a1in.size() >= this.maxSize) {
            if (this.a1in.size() > this.K_IN) {
                OCacheEntry removedFromAInEntry = this.a1in.removeLRU();
                if (removedFromAInEntry == null) {
                    this.increaseCacheSize();
                } else {
                    assert (removedFromAInEntry.usagesCount == 0);
                    assert (!removedFromAInEntry.isDirty);
                    removedFromAInEntry.dataPointer.decrementReferrer();
                    removedFromAInEntry.dataPointer = null;
                    this.a1out.putToMRU(removedFromAInEntry);
                }
                if (this.a1out.size() > this.K_OUT) {
                    OCacheEntry removedEntry = this.a1out.removeLRU();
                    assert (removedEntry.dataPointer == null);
                    assert (!removedEntry.isDirty);
                    Set<Long> pageEntries = this.filePages.get(removedEntry.fileId);
                    pageEntries.remove(removedEntry.pageIndex);
                }
            } else {
                OCacheEntry removedEntry = this.am.removeLRU();
                if (removedEntry == null) {
                    this.increaseCacheSize();
                } else {
                    assert (removedEntry.usagesCount == 0);
                    assert (!removedEntry.isDirty);
                    removedEntry.dataPointer.decrementReferrer();
                    removedEntry.dataPointer = null;
                    Set<Long> pageEntries = this.filePages.get(removedEntry.fileId);
                    pageEntries.remove(removedEntry.pageIndex);
                }
            }
        }
    }

    private void increaseCacheSize() {
        String message = "All records in aIn queue in 2q cache are used!";
        OLogManager.instance().warn((Object)this, message, new Object[0]);
        if (!OGlobalConfiguration.SERVER_CACHE_INCREASE_ON_DEMAND.getValueAsBoolean()) {
            throw new OAllCacheEntriesAreUsedException(message);
        }
        OLogManager.instance().warn((Object)this, "Cache size will be increased.", new Object[0]);
        this.maxSize = (int)Math.ceil((float)this.maxSize * (1.0f + OGlobalConfiguration.SERVER_CACHE_INCREASE_STEP.getValueAsFloat()));
        this.K_IN = this.maxSize >> 2;
        this.K_OUT = this.maxSize >> 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.writeCache.checkStoredPages(commandOutputListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ODirtyPage> logDirtyPagesTable() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            return this.writeCache.logDirtyPagesTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.writeCache.delete();
            this.clearCacheContent();
        }
    }

    int getMaxSize() {
        return this.maxSize;
    }

    private OCacheEntry get(long fileId, long pageIndex, boolean useOutQueue) {
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        if (useOutQueue && (cacheEntry = this.a1out.get(fileId, pageIndex)) != null) {
            return cacheEntry;
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        return cacheEntry;
    }

    private OCacheEntry remove(long fileId, long pageIndex) {
        OCacheEntry cacheEntry = this.am.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            if (cacheEntry.usagesCount > 1) {
                throw new IllegalStateException("Record cannot be removed because it is used!");
            }
            return cacheEntry;
        }
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        cacheEntry = this.a1in.remove(fileId, pageIndex);
        if (cacheEntry != null && cacheEntry.usagesCount > 1) {
            throw new IllegalStateException("Record cannot be removed because it is used!");
        }
        return cacheEntry;
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)(pageSize + 16);
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    public void initProfiler() {
        if (this.storageName != null) {
            OProfilerMBean profiler = Orient.instance().getProfiler();
            METRIC_HITS = profiler.getDatabaseMetric(this.storageName, "diskCache.hits");
            METRIC_HITS_METADATA = profiler.getDatabaseMetric(null, "diskCache.hits");
            METRIC_MISSED = profiler.getDatabaseMetric(this.storageName, "diskCache.missed");
            METRIC_MISSED_METADATA = profiler.getDatabaseMetric(null, "diskCache.missed");
            profiler.registerHookValue(profiler.getDatabaseMetric(this.storageName, "diskCache.totalMemory"), "Total memory used by Disk Cache", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

                public Object getValue() {
                    return (OReadWriteDiskCache.this.am.size() + OReadWriteDiskCache.this.a1in.size()) * OReadWriteDiskCache.this.pageSize;
                }
            }, profiler.getDatabaseMetric(null, "diskCache.totalMemory"));
            profiler.registerHookValue(profiler.getDatabaseMetric(this.storageName, "diskCache.maxMemory"), "Maximum memory used by Disk Cache", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

                public Object getValue() {
                    return OReadWriteDiskCache.this.maxSize * OReadWriteDiskCache.this.pageSize;
                }
            }, profiler.getDatabaseMetric(null, "diskCache.maxMemory"));
        }
    }

    private class PinnedPage
    implements Comparable<PinnedPage> {
        private final long fileId;
        private final long pageIndex;

        private PinnedPage(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PinnedPage that = (PinnedPage)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.pageIndex == that.pageIndex;
        }

        public String toString() {
            return "PinnedPage{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        @Override
        public int compareTo(PinnedPage other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }
    }
}

