/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.sbtreebonsai.local;

import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketAbstract;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsaiBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.io.IOException;

public class OSysBucket
extends OBonsaiBucketAbstract {
    private static final int SYS_MAGIC_OFFSET = 28;
    private static final int FREE_SPACE_OFFSET = 29;
    private static final int FREE_LIST_HEAD_OFFSET = 41;
    private static final int FREE_LIST_LENGTH_OFFSET = 53;
    private static final byte SYS_MAGIC = 41;

    public OSysBucket(OCacheEntry cacheEntry, ODurablePage.TrackMode trackMode) {
        super(cacheEntry, trackMode);
    }

    public void init() throws IOException {
        this.setByteValue(28, (byte)41);
        this.setBucketPointer(29, new OBonsaiBucketPointer(0L, OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES));
        this.setBucketPointer(41, OBonsaiBucketPointer.NULL);
        this.setLongValue(53, 0L);
    }

    public boolean isInitialized() {
        return this.getByteValue(28) != 41;
    }

    public long freeListLength() {
        return this.getLongValue(53);
    }

    public void setFreeListLength(long length) throws IOException {
        this.setLongValue(53, length);
    }

    public OBonsaiBucketPointer getFreeSpacePointer() {
        return this.getBucketPointer(29);
    }

    public void setFreeSpacePointer(OBonsaiBucketPointer pointer) throws IOException {
        this.setBucketPointer(29, pointer);
    }

    public OBonsaiBucketPointer getFreeListHead() {
        return this.getBucketPointer(41);
    }

    public void setFreeListHead(OBonsaiBucketPointer pointer) throws IOException {
        this.setBucketPointer(41, pointer);
    }
}

