/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.intent;

import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.HashMap;
import java.util.Map;

public class OIntentMassiveInsert
implements OIntent {
    private boolean previousLevel1CacheEnabled;
    private boolean previousLevel2CacheEnabled;
    private boolean previousRetainRecords;
    private boolean previousRetainObjects;
    private Map<ORecordHook, ORecordHook.HOOK_POSITION> removedHooks;
    private OUser currentUser;

    @Override
    public void begin(ODatabaseRaw iDatabase, Object ... iArgs) {
        this.currentUser = iDatabase.getDatabaseOwner().getUser();
        iDatabase.getDatabaseOwner().setUser(null);
        this.previousLevel1CacheEnabled = iDatabase.getDatabaseOwner().getLevel1Cache().isEnabled();
        iDatabase.getDatabaseOwner().getLevel1Cache().setEnable(false);
        this.previousLevel2CacheEnabled = iDatabase.getDatabaseOwner().getLevel2Cache().isEnabled();
        iDatabase.getDatabaseOwner().getLevel2Cache().setEnable(false);
        ODatabaseComplex<ORecordInternal<?>> ownerDb = iDatabase.getDatabaseOwner();
        if (ownerDb instanceof ODatabaseRecord) {
            this.previousRetainRecords = ownerDb.isRetainRecords();
            ownerDb.setRetainRecords(false);
        }
        while (ownerDb.getDatabaseOwner() != ownerDb) {
            ownerDb = ownerDb.getDatabaseOwner();
        }
        if (ownerDb instanceof ODatabaseObject) {
            this.previousRetainObjects = ((ODatabaseObject)ownerDb).isRetainObjects();
            ((ODatabaseObject)ownerDb).setRetainObjects(false);
        }
        this.removedHooks = new HashMap<ORecordHook, ORecordHook.HOOK_POSITION>();
        HashMap<ORecordHook, ORecordHook.HOOK_POSITION> hooks = new HashMap<ORecordHook, ORecordHook.HOOK_POSITION>(ownerDb.getHooks());
        for (Map.Entry<ORecordHook, ORecordHook.HOOK_POSITION> hook : hooks.entrySet()) {
            if (hook.getKey() instanceof OClassIndexManager) continue;
            this.removedHooks.put(hook.getKey(), hook.getValue());
            ownerDb.unregisterHook(hook.getKey());
        }
    }

    @Override
    public void end(ODatabaseRaw iDatabase) {
        if (this.currentUser != null) {
            iDatabase.getDatabaseOwner().setUser(this.currentUser);
        }
        iDatabase.getDatabaseOwner().getLevel1Cache().setEnable(this.previousLevel1CacheEnabled);
        iDatabase.getDatabaseOwner().getLevel2Cache().setEnable(this.previousLevel2CacheEnabled);
        ODatabaseComplex<ORecordInternal<?>> ownerDb = iDatabase.getDatabaseOwner();
        if (ownerDb instanceof ODatabaseRecord) {
            ownerDb.setRetainRecords(this.previousRetainRecords);
        }
        while (ownerDb.getDatabaseOwner() != ownerDb) {
            ownerDb = ownerDb.getDatabaseOwner();
        }
        if (ownerDb instanceof ODatabaseObject) {
            ((ODatabaseObject)ownerDb).setRetainObjects(this.previousRetainObjects);
        }
        if (this.removedHooks != null) {
            for (Map.Entry<ORecordHook, ORecordHook.HOOK_POSITION> hook : this.removedHooks.entrySet()) {
                ownerDb.registerHook(hook.getKey(), hook.getValue());
            }
        }
    }
}

