/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.function;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.function.ODatabaseFunction;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import java.util.Set;

public class ODatabaseFunctionFactory
implements OSQLFunctionFactory {
    @Override
    public boolean hasFunction(String iName) {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
        return db.getMetadata().getFunctionLibrary().getFunction(iName) != null;
    }

    @Override
    public Set<String> getFunctionNames() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
        return db.getMetadata().getFunctionLibrary().getFunctionNames();
    }

    @Override
    public OSQLFunction createFunction(String name) throws OCommandExecutionException {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
        OFunction f = db.getMetadata().getFunctionLibrary().getFunction(name);
        return new ODatabaseFunction(f);
    }
}

