/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordTrackedList;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentComparator;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.core.version.ODistributedVersion;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ODocumentHelper {
    public static final String ATTRIBUTE_THIS = "@this";
    public static final String ATTRIBUTE_RID = "@rid";
    public static final String ATTRIBUTE_RID_ID = "@rid_id";
    public static final String ATTRIBUTE_RID_POS = "@rid_pos";
    public static final String ATTRIBUTE_VERSION = "@version";
    public static final String ATTRIBUTE_VERSION_TIMESTAMP = "@version_time";
    public static final String ATTRIBUTE_VERSION_MACADDRESS = "@version_mac";
    public static final String ATTRIBUTE_CLASS = "@class";
    public static final String ATTRIBUTE_TYPE = "@type";
    public static final String ATTRIBUTE_SIZE = "@size";
    public static final String ATTRIBUTE_FIELDS = "@fields";
    public static final String ATTRIBUTE_RAW = "@raw";

    public static void sort(List<? extends OIdentifiable> ioResultSet, List<OPair<String, String>> iOrderCriteria, OCommandContext context) {
        if (ioResultSet != null) {
            Collections.sort(ioResultSet, new ODocumentComparator(iOrderCriteria, context));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <RET> RET convertField(ODocument iDocument, String iFieldName, Class<?> iFieldType, Object iValue) {
        if (iFieldType == null) {
            return (RET)iValue;
        }
        if (ORID.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof ORID) {
                return (RET)iValue;
            }
            if (iValue instanceof String) {
                return (RET)new ORecordId((String)iValue);
            }
            if (iValue instanceof ORecord) {
                return (RET)((ORecord)iValue).getIdentity();
            }
        } else if (ORecord.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof ORID || iValue instanceof ORecord) {
                return (RET)iValue;
            }
            if (iValue instanceof String) {
                return (RET)new ORecordId((String)iValue);
            }
        } else if (Set.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof Set) return (RET)iValue;
            Set<OIdentifiable> newValue = iValue instanceof ORecordLazyList || iValue instanceof ORecordLazyMap ? new OMVRBTreeRIDSet(iDocument) : new OTrackedSet(iDocument);
            if (iValue instanceof Collection) {
                newValue.addAll((Collection)iValue);
                return (RET)newValue;
            }
            if (iValue instanceof Map) {
                newValue.addAll(((Map)iValue).values());
                return (RET)newValue;
            }
            if (iValue instanceof String) {
                String[] items;
                String stringValue = (String)iValue;
                if (stringValue == null || stringValue.isEmpty()) return (RET)newValue;
                for (String s : items = stringValue.split(",")) {
                    newValue.add((OIdentifiable)((Object)s));
                }
                return (RET)newValue;
            }
            if (OMultiValue.isMultiValue((Object)iValue)) {
                for (Object s : OMultiValue.getMultiValueIterable((Object)iValue)) {
                    newValue.add((OIdentifiable)s);
                }
                return (RET)newValue;
            }
        } else if (List.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof List) return (RET)iValue;
            OTrackedList newValue = iValue instanceof OMVRBTreeRIDSet || iValue instanceof ORecordLazyMap ? new ORecordLazyList(iDocument) : new OTrackedList(iDocument);
            if (iValue instanceof Collection) {
                newValue.addAll((Collection)iValue);
                return (RET)newValue;
            }
            if (iValue instanceof Map) {
                newValue.addAll(((Map)iValue).values());
                return (RET)newValue;
            }
            if (iValue instanceof String) {
                String[] items;
                String stringValue = (String)iValue;
                if (stringValue == null || stringValue.isEmpty()) return (RET)newValue;
                for (String s : items = stringValue.split(",")) {
                    newValue.add(s);
                }
                return (RET)newValue;
            }
            if (OMultiValue.isMultiValue((Object)iValue)) {
                for (Object s : OMultiValue.getMultiValueIterable((Object)iValue)) {
                    newValue.add(s);
                }
                return (RET)newValue;
            }
        } else if (iValue instanceof Enum) {
            iValue = Number.class.isAssignableFrom(iFieldType) ? Integer.valueOf(((Enum)iValue).ordinal()) : iValue.toString();
            if (!(iValue instanceof String) && !iFieldType.isAssignableFrom(iValue.getClass())) {
                throw new IllegalArgumentException("Property '" + iFieldName + "' of type '" + iFieldType + "' cannot accept value of type: " + iValue.getClass());
            }
        } else if (Date.class.isAssignableFrom(iFieldType) && iValue instanceof String && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            OStorageConfiguration config = iDocument.getDatabase().getStorage().getConfiguration();
            SimpleDateFormat formatter = config.getDateFormatInstance();
            if (((String)iValue).length() > config.dateFormat.length()) {
                formatter = config.getDateTimeFormatInstance();
            }
            try {
                Date newValue = formatter.parse((String)iValue);
                return (RET)newValue;
            }
            catch (ParseException pe) {
                String dateFormat = ((String)iValue).length() > config.dateFormat.length() ? config.dateTimeFormat : config.dateFormat;
                throw new OQueryParsingException("Error on conversion of date '" + iValue + "' using the format: " + dateFormat);
            }
        }
        iValue = OType.convert(iValue, iFieldType);
        return (RET)iValue;
    }

    public static <RET> RET getFieldValue(Object value, String iFieldName) {
        return ODocumentHelper.getFieldValue(value, iFieldName, null);
    }

    public static <RET> RET getFieldValue(Object value, String iFieldName, OCommandContext iContext) {
        if (value == null) {
            return null;
        }
        int fieldNameLength = iFieldName.length();
        if (fieldNameLength == 0) {
            return (RET)value;
        }
        OIdentifiable currentRecord = value instanceof OIdentifiable ? (OIdentifiable)value : null;
        int beginPos = iFieldName.charAt(0) == '.' ? 1 : 0;
        int nextSeparatorPos = iFieldName.charAt(0) == '.' ? 1 : 0;
        do {
            String fieldName;
            int nextSeparator = 32;
            while (nextSeparatorPos < fieldNameLength && (nextSeparator = (int)iFieldName.charAt(nextSeparatorPos)) != 46 && nextSeparator != 91) {
                ++nextSeparatorPos;
            }
            if (nextSeparatorPos < fieldNameLength) {
                fieldName = iFieldName.substring(beginPos, nextSeparatorPos);
            } else {
                nextSeparator = 32;
                fieldName = beginPos > 0 ? iFieldName.substring(beginPos) : iFieldName;
            }
            if (nextSeparator == 91) {
                Object index;
                int end;
                if (fieldName != null && fieldName.length() > 0) {
                    if (currentRecord != null) {
                        value = ODocumentHelper.getIdentifiableValue(currentRecord, fieldName);
                    } else if (value instanceof Map) {
                        value = ODocumentHelper.getMapEntry((Map)value, fieldName);
                    } else if (OMultiValue.isMultiValue((Object)value)) {
                        HashSet temp = new HashSet();
                        for (Object o : OMultiValue.getMultiValueIterable((Object)value)) {
                            RET r;
                            if (!(o instanceof OIdentifiable) || (r = ODocumentHelper.getFieldValue(o, iFieldName)) == null) continue;
                            OMultiValue.add(temp, r);
                        }
                        value = temp;
                    }
                }
                if (value == null) {
                    return null;
                }
                if (value instanceof OIdentifiable) {
                    currentRecord = (OIdentifiable)value;
                }
                if ((end = iFieldName.indexOf(93, nextSeparatorPos)) == -1) {
                    throw new IllegalArgumentException("Missed closed ']'");
                }
                String indexPart = iFieldName.substring(nextSeparatorPos + 1, end);
                if (indexPart.length() == 0) {
                    return null;
                }
                nextSeparatorPos = end;
                if (value instanceof OCommandContext) {
                    value = ((OCommandContext)value).getVariables();
                }
                if (value instanceof OIdentifiable) {
                    Object record = currentRecord != null && currentRecord instanceof OIdentifiable ? currentRecord.getRecord() : null;
                    index = ODocumentHelper.getIndexPart(iContext, indexPart);
                    String indexAsString = index != null ? index.toString() : null;
                    List<String> indexParts = OStringSerializerHelper.smartSplit(indexAsString, ',', new char[0]);
                    List<String> indexRanges = OStringSerializerHelper.smartSplit(indexAsString, '-', ' ');
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(indexAsString, '=', ' ');
                    if (indexParts.size() == 1 && indexCondition.size() == 1 && indexRanges.size() == 1) {
                        value = ((ODocument)record).field(indexAsString);
                    } else if (indexParts.size() > 1) {
                        Object[] values = new Object[indexParts.size()];
                        for (int i = 0; i < indexParts.size(); ++i) {
                            values[i] = ((ODocument)record).field(indexParts.get(i));
                        }
                        value = values;
                    } else if (indexRanges.size() > 1) {
                        String from = indexRanges.get(0);
                        String to = indexRanges.get(1);
                        ODocument doc = (ODocument)((OIdentifiable)value).getRecord();
                        String[] fieldNames = doc.fieldNames();
                        int rangeFrom = from != null && !from.isEmpty() ? Integer.parseInt(from) : 0;
                        int rangeTo = to != null && !to.isEmpty() ? Math.min(Integer.parseInt(to), fieldNames.length - 1) : fieldNames.length - 1;
                        Object[] values = new Object[rangeTo - rangeFrom + 1];
                        for (int i = rangeFrom; i <= rangeTo; ++i) {
                            values[i - rangeFrom] = doc.field(fieldNames[i]);
                        }
                        value = values;
                    } else if (!indexCondition.isEmpty()) {
                        String conditionFieldName = indexCondition.get(0);
                        Object conditionFieldValue = ORecordSerializerStringAbstract.getTypeValue(indexCondition.get(1));
                        if (conditionFieldValue instanceof String) {
                            conditionFieldValue = OStringSerializerHelper.getStringContent(conditionFieldValue);
                        }
                        RET fieldValue = ODocumentHelper.getFieldValue(currentRecord, conditionFieldName);
                        if (conditionFieldValue != null && fieldValue != null) {
                            conditionFieldValue = OType.convert(conditionFieldValue, fieldValue.getClass());
                        }
                        if (fieldValue == null && !conditionFieldValue.equals("null") || fieldValue != null & !fieldValue.equals(conditionFieldValue)) {
                            value = null;
                        }
                    }
                } else if (value instanceof Map) {
                    List<String> indexParts = OStringSerializerHelper.smartSplit(indexPart, ',', OStringSerializerHelper.DEFAULT_IGNORE_CHARS);
                    if (indexParts.size() == 1) {
                        index = ODocumentHelper.getIndexPart(iContext, indexPart);
                        value = ((Map)value).get(index);
                    } else {
                        Object[] values = new Object[indexParts.size()];
                        for (int i = 0; i < indexParts.size(); ++i) {
                            Object index2 = ODocumentHelper.getIndexPart(iContext, indexParts.get(i));
                            values[i] = ((Map)value).get(index2);
                        }
                        value = values;
                    }
                } else if (OMultiValue.isMultiValue((Object)value)) {
                    Object index3 = ODocumentHelper.getIndexPart(iContext, indexPart);
                    String indexAsString = index3 != null ? index3.toString() : null;
                    List<String> indexParts = OStringSerializerHelper.smartSplit(indexAsString, ',', new char[0]);
                    List<String> indexRanges = OStringSerializerHelper.smartSplit(indexAsString, '-', new char[0]);
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(indexAsString, '=', ' ');
                    if (indexParts.size() == 1 && indexRanges.size() == 1 && indexCondition.size() == 1) {
                        value = value instanceof Map ? ODocumentHelper.getMapEntry((Map)value, index3) : (Character.isDigit(indexAsString.charAt(0)) ? OMultiValue.getValue((Object)value, (int)Integer.parseInt(indexAsString)) : ODocumentHelper.getFieldValue(value, indexAsString, iContext));
                    } else if (indexParts.size() > 1) {
                        Object[] values = new Object[indexParts.size()];
                        for (int i = 0; i < indexParts.size(); ++i) {
                            values[i] = OMultiValue.getValue((Object)value, (int)Integer.parseInt(indexParts.get(i)));
                        }
                        value = values;
                    } else if (indexRanges.size() > 1) {
                        String from = indexRanges.get(0);
                        String to = indexRanges.get(1);
                        int rangeFrom = from != null && !from.isEmpty() ? Integer.parseInt(from) : 0;
                        int rangeTo = to != null && !to.isEmpty() ? Math.min(Integer.parseInt(to), OMultiValue.getSize((Object)value) - 1) : OMultiValue.getSize((Object)value) - 1;
                        Object[] values = new Object[rangeTo - rangeFrom + 1];
                        for (int i = rangeFrom; i <= rangeTo; ++i) {
                            values[i - rangeFrom] = OMultiValue.getValue((Object)value, (int)i);
                        }
                        value = values;
                    } else if (!indexCondition.isEmpty()) {
                        String conditionFieldName = indexCondition.get(0);
                        Object conditionFieldValue = ORecordSerializerStringAbstract.getTypeValue(indexCondition.get(1));
                        if (conditionFieldValue instanceof String) {
                            conditionFieldValue = OStringSerializerHelper.getStringContent(conditionFieldValue);
                        }
                        HashSet<Object> values = new HashSet<Object>();
                        for (Object v : OMultiValue.getMultiValueIterable((Object)value)) {
                            Object filtered = ODocumentHelper.filterItem(conditionFieldName, conditionFieldValue, v);
                            if (filtered == null) continue;
                            if (filtered instanceof Collection) {
                                values.addAll((Collection)filtered);
                                continue;
                            }
                            values.add(filtered);
                        }
                        value = values.isEmpty() ? null : (values.size() == 1 ? values.iterator().next() : values);
                    }
                }
            } else {
                if (fieldName.length() == 0) {
                    beginPos = ++nextSeparatorPos;
                    continue;
                }
                if (fieldName.startsWith("$")) {
                    value = iContext.getVariable(fieldName);
                } else if (fieldName.contains("(")) {
                    value = ODocumentHelper.evaluateFunction(value, fieldName, iContext);
                } else {
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(fieldName, '=', ' ');
                    if (indexCondition.size() == 2) {
                        String conditionFieldName = indexCondition.get(0);
                        Object conditionFieldValue = ORecordSerializerStringAbstract.getTypeValue(indexCondition.get(1));
                        if (conditionFieldValue instanceof String) {
                            conditionFieldValue = OStringSerializerHelper.getStringContent(conditionFieldValue);
                        }
                        value = ODocumentHelper.filterItem(conditionFieldName, conditionFieldValue, value);
                    } else if (currentRecord != null) {
                        value = ODocumentHelper.getIdentifiableValue(currentRecord, fieldName);
                        if (value != null && value instanceof ORecord && ((ORecord)value).getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                            ((ORecord)value).reload();
                        }
                    } else if (value instanceof Map) {
                        value = ODocumentHelper.getMapEntry((Map)value, fieldName);
                    } else if (OMultiValue.isMultiValue((Object)value)) {
                        HashSet<Object> values = new HashSet<Object>();
                        for (Object v : OMultiValue.getMultiValueIterable((Object)value)) {
                            Object item = v instanceof OIdentifiable ? ODocumentHelper.getIdentifiableValue((OIdentifiable)v, fieldName) : (v instanceof Map ? ((Map)v).get(fieldName) : null);
                            if (item == null) continue;
                            if (item instanceof Collection) {
                                values.addAll((Collection)item);
                                continue;
                            }
                            values.add(item);
                        }
                        value = values.isEmpty() ? null : values;
                    } else {
                        return null;
                    }
                }
            }
            currentRecord = value instanceof OIdentifiable ? (OIdentifiable)value : null;
            beginPos = ++nextSeparatorPos;
        } while (nextSeparatorPos < fieldNameLength && value != null);
        return (RET)value;
    }

    protected static Object getIndexPart(OCommandContext iContext, String indexPart) {
        Object index = indexPart;
        if (indexPart.charAt(0) == '\"' || indexPart.charAt(0) == '\'') {
            index = OStringSerializerHelper.getStringContent(indexPart);
        } else if (indexPart.charAt(0) == '$') {
            Object ctxValue = iContext.getVariable(indexPart);
            if (ctxValue == null) {
                return null;
            }
            index = ctxValue;
        } else if (!Character.isDigit(indexPart.charAt(0))) {
            index = indexPart;
        }
        return index;
    }

    protected static Object filterItem(String iConditionFieldName, Object iConditionFieldValue, Object iValue) {
        if (iValue instanceof OIdentifiable) {
            Object rec = ((OIdentifiable)iValue).getRecord();
            if (rec instanceof ODocument) {
                ODocument doc = (ODocument)rec;
                Object fieldValue = doc.field(iConditionFieldName);
                if (iConditionFieldValue == null) {
                    return fieldValue == null ? doc : null;
                }
                if ((fieldValue = OType.convert(fieldValue, iConditionFieldValue.getClass())) != null && fieldValue.equals(iConditionFieldValue)) {
                    return doc;
                }
            }
        } else if (iValue instanceof Map) {
            Map map = (Map)iValue;
            Object fieldValue = ODocumentHelper.getMapEntry(map, iConditionFieldName);
            if ((fieldValue = OType.convert(fieldValue, iConditionFieldValue.getClass())) != null && fieldValue.equals(iConditionFieldValue)) {
                return map;
            }
        }
        return null;
    }

    public static Object getMapEntry(Map<String, ?> iMap, Object iKey) {
        if (iMap == null || iKey == null) {
            return null;
        }
        if (iKey instanceof String) {
            Object value;
            String iName = (String)iKey;
            int pos = iName.indexOf(46);
            if (pos > -1) {
                iName = iName.substring(0, pos);
            }
            if ((value = iMap.get(iName)) == null) {
                return null;
            }
            if (pos > -1) {
                String restFieldName = iName.substring(pos + 1);
                if (value instanceof ODocument) {
                    return ODocumentHelper.getFieldValue(value, restFieldName);
                }
                if (value instanceof Map) {
                    return ODocumentHelper.getMapEntry((Map)value, restFieldName);
                }
            }
            return value;
        }
        return iMap.get(iKey);
    }

    public static Object getIdentifiableValue(OIdentifiable iCurrent, String iFieldName) {
        if (iFieldName == null || iFieldName.length() == 0) {
            return null;
        }
        char begin = iFieldName.charAt(0);
        if (begin == '@') {
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_THIS)) {
                return iCurrent.getRecord();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RID)) {
                return iCurrent.getIdentity();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RID_ID)) {
                return iCurrent.getIdentity().getClusterId();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RID_POS)) {
                return iCurrent.getIdentity().getClusterPosition();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_VERSION)) {
                return iCurrent.getRecord().getRecordVersion().getCounter();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_VERSION_TIMESTAMP) && OGlobalConfiguration.DB_USE_DISTRIBUTED_VERSION.getValueAsBoolean()) {
                return ((ODistributedVersion)iCurrent.getRecord().getRecordVersion()).getTimestamp();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_VERSION_MACADDRESS) && OGlobalConfiguration.DB_USE_DISTRIBUTED_VERSION.getValueAsBoolean()) {
                return ((ODistributedVersion)iCurrent.getRecord().getRecordVersion()).getMacAddress();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_CLASS)) {
                return ((ODocument)iCurrent.getRecord()).getClassName();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
                return Orient.instance().getRecordFactoryManager().getRecordTypeName(((ORecordInternal)iCurrent.getRecord()).getRecordType());
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_SIZE)) {
                byte[] stream = ((ORecordInternal)iCurrent.getRecord()).toStream();
                return stream != null ? stream.length : 0;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_FIELDS)) {
                return ((ODocument)iCurrent.getRecord()).fieldNames();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RAW)) {
                return new String(((ORecordInternal)iCurrent.getRecord()).toStream());
            }
        }
        if (iCurrent == null) {
            return null;
        }
        ODocument doc = (ODocument)iCurrent.getRecord();
        doc.checkForFields(iFieldName);
        return doc._fieldValues.get(iFieldName);
    }

    public static Object evaluateFunction(Object currentValue, String iFunction, OCommandContext iContext) {
        if (currentValue == null) {
            return null;
        }
        Object result = null;
        String function = iFunction.toUpperCase();
        if (function.startsWith("SIZE(")) {
            result = currentValue instanceof ORecord ? 1 : OMultiValue.getSize((Object)currentValue);
        } else if (function.startsWith("LENGTH(")) {
            result = currentValue.toString().length();
        } else if (function.startsWith("TOUPPERCASE(")) {
            result = currentValue.toString().toUpperCase();
        } else if (function.startsWith("TOLOWERCASE(")) {
            result = currentValue.toString().toLowerCase();
        } else if (function.startsWith("TRIM(")) {
            result = currentValue.toString().trim();
        } else if (function.startsWith("TOJSON(")) {
            result = currentValue instanceof ODocument ? ((ODocument)currentValue).toJSON() : null;
        } else if (function.startsWith("KEYS(")) {
            result = currentValue instanceof Map ? ((Map)currentValue).keySet() : null;
        } else if (function.startsWith("VALUES(")) {
            result = currentValue instanceof Map ? ((Map)currentValue).values() : null;
        } else if (function.startsWith("ASSTRING(")) {
            result = currentValue.toString();
        } else if (function.startsWith("ASINTEGER(")) {
            result = new Integer(currentValue.toString());
        } else if (function.startsWith("ASFLOAT(")) {
            result = new Float(currentValue.toString());
        } else if (function.startsWith("ASBOOLEAN(")) {
            if (currentValue instanceof String) {
                result = new Boolean((String)currentValue);
            } else if (currentValue instanceof Number) {
                int bValue = ((Number)currentValue).intValue();
                if (bValue == 0) {
                    result = Boolean.FALSE;
                } else if (bValue == 1) {
                    result = Boolean.TRUE;
                }
            }
        } else if (function.startsWith("ASDATE(")) {
            if (currentValue instanceof Date) {
                result = currentValue;
            } else if (currentValue instanceof Number) {
                result = new Date(((Number)currentValue).longValue());
            } else {
                try {
                    result = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateFormatInstance().parse(currentValue.toString());
                }
                catch (ParseException e) {}
            }
        } else if (function.startsWith("ASDATETIME(")) {
            if (currentValue instanceof Date) {
                result = currentValue;
            } else if (currentValue instanceof Number) {
                result = new Date(((Number)currentValue).longValue());
            } else {
                try {
                    result = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateTimeFormatInstance().parse(currentValue.toString());
                }
                catch (ParseException e) {}
            }
        } else {
            String stringValue;
            List<String> args = OStringSerializerHelper.getParameters(iFunction.substring(iFunction.indexOf(40)));
            ORecordInternal currentRecord = iContext != null ? (ORecordInternal)iContext.getVariable("$current") : null;
            for (int i = 0; i < args.size(); ++i) {
                String arg = args.get(i);
                Object o = OSQLHelper.getValue(arg, currentRecord, iContext);
                if (o == null) continue;
                args.set(i, o.toString());
            }
            if (function.startsWith("CHARAT(")) {
                result = Character.valueOf(currentValue.toString().charAt(Integer.parseInt(args.get(0))));
            } else if (function.startsWith("INDEXOF(")) {
                result = args.size() == 1 ? Integer.valueOf(currentValue.toString().indexOf(OStringSerializerHelper.getStringContent(args.get(0)))) : Integer.valueOf(currentValue.toString().indexOf(OStringSerializerHelper.getStringContent(args.get(0)), Integer.parseInt(args.get(1))));
            } else if (function.startsWith("SUBSTRING(")) {
                result = args.size() == 1 ? currentValue.toString().substring(Integer.parseInt(args.get(0))) : currentValue.toString().substring(Integer.parseInt(args.get(0)), Integer.parseInt(args.get(1)));
            } else if (function.startsWith("APPEND(")) {
                result = currentValue.toString() + OStringSerializerHelper.getStringContent(args.get(0));
            } else if (function.startsWith("PREFIX(")) {
                result = OStringSerializerHelper.getStringContent(args.get(0)) + currentValue.toString();
            } else if (function.startsWith("FORMAT(")) {
                result = currentValue instanceof Date ? new SimpleDateFormat(OStringSerializerHelper.getStringContent(args.get(0))).format(currentValue) : String.format(OStringSerializerHelper.getStringContent(args.get(0)), currentValue.toString());
            } else if (function.startsWith("LEFT(")) {
                int len = Integer.parseInt(args.get(0));
                result = stringValue.substring(0, len <= (stringValue = currentValue.toString()).length() ? len : stringValue.length());
            } else if (function.startsWith("RIGHT(")) {
                int offset = Integer.parseInt(args.get(0));
                result = stringValue.substring(offset < (stringValue = currentValue.toString()).length() ? stringValue.length() - offset : 0);
            } else {
                OSQLFunctionRuntime f = OSQLHelper.getFunction(null, iFunction);
                if (f != null) {
                    result = f.execute(currentRecord, currentRecord, null, iContext);
                }
            }
        }
        return result;
    }

    public static void copyFieldValue(ODocument iCloned, Map.Entry<String, Object> iEntry) {
        OProperty prop;
        Object fieldValue = iEntry.getValue();
        if (fieldValue != null) {
            if (fieldValue instanceof ODocument && !((ODocument)fieldValue).getIdentity().isValid()) {
                iCloned._fieldValues.put(iEntry.getKey(), ((ODocument)fieldValue).copy());
            } else if (fieldValue instanceof ORecordLazyList) {
                iCloned._fieldValues.put(iEntry.getKey(), ((ORecordLazyList)fieldValue).copy(iCloned));
            } else if (fieldValue instanceof ORecordTrackedList) {
                ORecordTrackedList newList = new ORecordTrackedList(iCloned);
                newList.addAll((ORecordTrackedList)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof OTrackedList) {
                OTrackedList newList = new OTrackedList(iCloned);
                newList.addAll((OTrackedList)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof List) {
                iCloned._fieldValues.put(iEntry.getKey(), new ArrayList((List)fieldValue));
            } else if (fieldValue instanceof OMVRBTreeRIDSet) {
                iCloned._fieldValues.put(iEntry.getKey(), ((OMVRBTreeRIDSet)fieldValue).copy(iCloned));
            } else if (fieldValue instanceof ORecordTrackedSet) {
                ORecordTrackedSet newList = new ORecordTrackedSet(iCloned);
                newList.addAll((ORecordTrackedSet)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof OTrackedSet) {
                OTrackedSet newList = new OTrackedSet(iCloned);
                newList.addAll((OTrackedSet)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof Set) {
                iCloned._fieldValues.put(iEntry.getKey(), new HashSet((Set)fieldValue));
            } else if (fieldValue instanceof ORecordLazyMap) {
                ORecordLazyMap newMap = new ORecordLazyMap(iCloned, ((ORecordLazyMap)fieldValue).getRecordType());
                newMap.putAll((ORecordLazyMap)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newMap);
            } else if (fieldValue instanceof OTrackedMap) {
                OTrackedMap newMap = new OTrackedMap(iCloned);
                newMap.putAll((OTrackedMap)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newMap);
            } else if (fieldValue instanceof Map) {
                iCloned._fieldValues.put(iEntry.getKey(), new LinkedHashMap((Map)fieldValue));
            } else {
                iCloned._fieldValues.put(iEntry.getKey(), fieldValue);
            }
        } else if (iCloned.getSchemaClass() != null && (prop = iCloned.getSchemaClass().getProperty(iEntry.getKey())) != null && prop.isMandatory()) {
            iCloned._fieldValues.put(iEntry.getKey(), fieldValue);
        }
    }

    public static boolean hasSameContentItem(Object iCurrent, ODatabaseRecord iMyDb, Object iOther, ODatabaseRecord iOtherDb, RIDMapper ridMapper) {
        if (iCurrent instanceof ODocument) {
            ODocument otherDoc;
            ODocument current = (ODocument)iCurrent;
            if (iOther instanceof ORID ? (!current.isDirty() ? !current.getIdentity().equals(iOther) : !ODocumentHelper.hasSameContentOf(current, iMyDb, otherDoc = (ODocument)iOtherDb.load((ORID)iOther), iOtherDb, ridMapper)) : !ODocumentHelper.hasSameContentOf(current, iMyDb, (ODocument)iOther, iOtherDb, ridMapper)) {
                return false;
            }
        } else if (!ODocumentHelper.compareScalarValues(iCurrent, iOther, ridMapper)) {
            return false;
        }
        return true;
    }

    public static boolean hasSameContentOf(final ODocument iCurrent, ODatabaseRecord iMyDb, final ODocument iOther, ODatabaseRecord iOtherDb, RIDMapper ridMapper) {
        if (iOther == null) {
            return false;
        }
        if (!iCurrent.equals(iOther) && iCurrent.getIdentity().isValid()) {
            return false;
        }
        if (iMyDb != null) {
            ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                @Override
                public Object call() {
                    if (iCurrent.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                        iCurrent.reload();
                    }
                    return null;
                }
            });
        }
        if (iOtherDb != null) {
            ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                @Override
                public Object call() {
                    if (iOther.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                        iOther.reload();
                    }
                    return null;
                }
            });
        }
        if (iMyDb != null) {
            ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                @Override
                public Object call() {
                    iCurrent.checkForFields(new String[0]);
                    return null;
                }
            });
        } else {
            iCurrent.checkForFields(new String[0]);
        }
        if (iOtherDb != null) {
            ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                @Override
                public Object call() {
                    iOther.checkForFields(new String[0]);
                    return null;
                }
            });
        } else {
            iOther.checkForFields(new String[0]);
        }
        if (iCurrent._fieldValues.size() != iOther._fieldValues.size()) {
            return false;
        }
        for (Map.Entry<String, Object> f : iCurrent._fieldValues.entrySet()) {
            Object otherFieldValue;
            Object myFieldValue = f.getValue();
            if (myFieldValue == (otherFieldValue = iOther._fieldValues.get(f.getKey()))) continue;
            if (myFieldValue == null ? otherFieldValue != null : otherFieldValue == null) {
                return false;
            }
            if (myFieldValue == null || !(myFieldValue instanceof Set && otherFieldValue instanceof Set ? !ODocumentHelper.compareSets(iMyDb, (Set)myFieldValue, iOtherDb, (Set)otherFieldValue, ridMapper) : (myFieldValue instanceof Collection && otherFieldValue instanceof Collection ? !ODocumentHelper.compareCollections(iMyDb, (Collection)myFieldValue, iOtherDb, (Collection)otherFieldValue, ridMapper) : (myFieldValue instanceof ORidBag && otherFieldValue instanceof ORidBag ? !ODocumentHelper.compareBags(iMyDb, (ORidBag)myFieldValue, iOtherDb, (ORidBag)otherFieldValue, ridMapper) : (myFieldValue instanceof Map && otherFieldValue instanceof Map ? !ODocumentHelper.compareMaps(iMyDb, (Map)myFieldValue, iOtherDb, (Map)otherFieldValue, ridMapper) : (myFieldValue instanceof ODocument && otherFieldValue instanceof ODocument ? !ODocumentHelper.hasSameContentOf((ODocument)myFieldValue, iMyDb, (ODocument)otherFieldValue, iOtherDb, ridMapper) : !ODocumentHelper.compareScalarValues(myFieldValue, otherFieldValue, ridMapper))))))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareMaps(ODatabaseRecord iMyDb, Map<Object, Object> myFieldValue, ODatabaseRecord iOtherDb, Map<Object, Object> otherFieldValue, RIDMapper ridMapper) {
        final Map<Object, Object> myMap = myFieldValue;
        final Map<Object, Object> otherMap = otherFieldValue;
        if (myMap.size() != otherMap.size()) {
            return false;
        }
        boolean oldMyAutoConvert = false;
        boolean oldOtherAutoConvert = false;
        if (myMap instanceof ORecordLazyMultiValue) {
            oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)myMap)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(false);
        }
        if (otherMap instanceof ORecordLazyMultiValue) {
            oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherMap)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(false);
        }
        try {
            final Iterator<Map.Entry<Object, Object>> myEntryIterator = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<Map.Entry<Object, Object>>>(){

                @Override
                public Iterator<Map.Entry<Object, Object>> call() {
                    return myMap.entrySet().iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call() {
                    return myEntryIterator.hasNext();
                }
            }).booleanValue()) {
                Object otherValue;
                final Map.Entry<Object, Object> myEntry = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Map.Entry<Object, Object>>(){

                    @Override
                    public Map.Entry<Object, Object> call() {
                        return (Map.Entry)myEntryIterator.next();
                    }
                });
                final Object myKey = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return myEntry.getKey();
                    }
                });
                if (ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Boolean>(){

                    @Override
                    public Boolean call() {
                        return !otherMap.containsKey(myKey);
                    }
                }).booleanValue()) {
                    boolean bl = false;
                    return bl;
                }
                if (myEntry.getValue() instanceof ODocument) {
                    if (ODocumentHelper.hasSameContentOf(ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<ODocument>(){

                        @Override
                        public ODocument call() {
                            return (ODocument)myEntry.getValue();
                        }
                    }), iMyDb, ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<ODocument>(){

                        @Override
                        public ODocument call() {
                            return (ODocument)otherMap.get(myEntry.getKey());
                        }
                    }), iOtherDb, ridMapper)) continue;
                    boolean bl = false;
                    return bl;
                }
                Object myValue = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return myEntry.getValue();
                    }
                });
                if (ODocumentHelper.compareScalarValues(myValue, otherValue = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return otherMap.get(myEntry.getKey());
                    }
                }), ridMapper)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (myMap instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (otherMap instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(oldOtherAutoConvert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareCollections(ODatabaseRecord iMyDb, Collection<?> myFieldValue, ODatabaseRecord iOtherDb, Collection<?> otherFieldValue, RIDMapper ridMapper) {
        final Collection<?> myCollection = myFieldValue;
        final Collection<?> otherCollection = otherFieldValue;
        if (myCollection.size() != otherCollection.size()) {
            return false;
        }
        boolean oldMyAutoConvert = false;
        boolean oldOtherAutoConvert = false;
        if (myCollection instanceof ORecordLazyMultiValue) {
            oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)myCollection)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)myCollection)).setAutoConvertToRecord(false);
        }
        if (otherCollection instanceof ORecordLazyMultiValue) {
            oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherCollection)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)otherCollection)).setAutoConvertToRecord(false);
        }
        try {
            final Iterator myIterator = (Iterator)ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<?>>(){

                @Override
                public Iterator<?> call() {
                    return myCollection.iterator();
                }
            });
            final Iterator otherIterator = (Iterator)ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Iterator<?>>(){

                @Override
                public Iterator<?> call() {
                    return otherCollection.iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call() {
                    return myIterator.hasNext();
                }
            }).booleanValue()) {
                Object otherNextVal;
                Object myNextVal = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return myIterator.next();
                    }
                });
                if (ODocumentHelper.hasSameContentItem(myNextVal, iMyDb, otherNextVal = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return otherIterator.next();
                    }
                }), iOtherDb, ridMapper)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (myCollection instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)myCollection)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (otherCollection instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)otherCollection)).setAutoConvertToRecord(oldOtherAutoConvert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareSets(ODatabaseRecord iMyDb, Set<?> myFieldValue, ODatabaseRecord iOtherDb, Set<?> otherFieldValue, RIDMapper ridMapper) {
        int otherSize;
        final Set<?> mySet = myFieldValue;
        final Set<?> otherSet = otherFieldValue;
        int mySize = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Integer>(){

            @Override
            public Integer call() {
                return mySet.size();
            }
        });
        if (mySize != (otherSize = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Integer>(){

            @Override
            public Integer call() {
                return otherSet.size();
            }
        }).intValue())) {
            return false;
        }
        boolean oldMyAutoConvert = false;
        boolean oldOtherAutoConvert = false;
        if (mySet instanceof ORecordLazyMultiValue) {
            oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)mySet)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)mySet)).setAutoConvertToRecord(false);
        }
        if (otherSet instanceof ORecordLazyMultiValue) {
            oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherSet)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)otherSet)).setAutoConvertToRecord(false);
        }
        try {
            final Iterator myIterator = (Iterator)ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<?>>(){

                @Override
                public Iterator<?> call() {
                    return mySet.iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call() {
                    return myIterator.hasNext();
                }
            }).booleanValue()) {
                final Iterator otherIterator = (Iterator)ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Iterator<?>>(){

                    @Override
                    public Iterator<?> call() {
                        return otherSet.iterator();
                    }
                });
                Object myNextVal = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return myIterator.next();
                    }
                });
                boolean found = false;
                while (!found && ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Boolean>(){

                    @Override
                    public Boolean call() {
                        return otherIterator.hasNext();
                    }
                }).booleanValue()) {
                    Object otherNextVal = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                        @Override
                        public Object call() {
                            return otherIterator.next();
                        }
                    });
                    found = ODocumentHelper.hasSameContentItem(myNextVal, iMyDb, otherNextVal, iOtherDb, ridMapper);
                }
                if (found) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (mySet instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)mySet)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (otherSet instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)otherSet)).setAutoConvertToRecord(oldOtherAutoConvert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareBags(ODatabaseRecord iMyDb, ORidBag myFieldValue, ODatabaseRecord iOtherDb, ORidBag otherFieldValue, RIDMapper ridMapper) {
        int otherSize;
        final ORidBag myBag = myFieldValue;
        final ORidBag otherBag = otherFieldValue;
        int mySize = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Integer>(){

            @Override
            public Integer call() {
                return myBag.size();
            }
        });
        if (mySize != (otherSize = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Integer>(){

            @Override
            public Integer call() {
                return otherBag.size();
            }
        }).intValue())) {
            return false;
        }
        boolean oldMyAutoConvert = myBag.isAutoConvertToRecord();
        myBag.setAutoConvertToRecord(false);
        boolean oldOtherAutoConvert = otherBag.isAutoConvertToRecord();
        otherBag.setAutoConvertToRecord(false);
        final ORidBag otherBagCopy = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<ORidBag>(){

            @Override
            public ORidBag call() {
                ORidBag otherRidBag = new ORidBag();
                otherRidBag.setAutoConvertToRecord(false);
                for (OIdentifiable identifiable : otherBag) {
                    otherRidBag.add(identifiable);
                }
                return otherRidBag;
            }
        });
        try {
            final Iterator<OIdentifiable> myIterator = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<OIdentifiable>>(){

                @Override
                public Iterator<OIdentifiable> call() {
                    return myBag.iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call() {
                    return myIterator.hasNext();
                }
            }).booleanValue()) {
                ORID convertedRid;
                OIdentifiable myIdentifiable = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<OIdentifiable>(){

                    @Override
                    public OIdentifiable call() {
                        return (OIdentifiable)myIterator.next();
                    }
                });
                final ORID otherRid = ridMapper != null ? ((convertedRid = ridMapper.map(myIdentifiable.getIdentity())) != null ? convertedRid : myIdentifiable.getIdentity()) : myIdentifiable.getIdentity();
                ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        otherBagCopy.remove(otherRid);
                        return null;
                    }
                });
            }
            boolean bl = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call() {
                    return otherBagCopy.isEmpty();
                }
            });
            return bl;
        }
        finally {
            myBag.setAutoConvertToRecord(oldMyAutoConvert);
            otherBag.setAutoConvertToRecord(oldOtherAutoConvert);
        }
    }

    private static boolean compareScalarValues(Object myValue, Object otherValue, RIDMapper ridMapper) {
        ORID convertedValue;
        if (myValue == null && otherValue != null || myValue != null && otherValue == null) {
            return false;
        }
        if (myValue == null) {
            return true;
        }
        if (myValue.getClass().isArray() && !otherValue.getClass().isArray() || !myValue.getClass().isArray() && otherValue.getClass().isArray()) {
            return false;
        }
        if (myValue.getClass().isArray() && otherValue.getClass().isArray()) {
            int otherArraySize;
            int myArraySize = Array.getLength(myValue);
            if (myArraySize != (otherArraySize = Array.getLength(otherValue))) {
                return false;
            }
            for (int i = 0; i < myArraySize; ++i) {
                if (Array.get(myValue, i).equals(Array.get(otherValue, i))) continue;
                return false;
            }
            return true;
        }
        if (myValue instanceof Number && otherValue instanceof Number) {
            Number myNumberValue = (Number)myValue;
            Number otherNumberValue = (Number)otherValue;
            if (ODocumentHelper.isInteger(myNumberValue) && ODocumentHelper.isInteger(otherNumberValue)) {
                return myNumberValue.longValue() == otherNumberValue.longValue();
            }
            if (ODocumentHelper.isFloat(myNumberValue) && ODocumentHelper.isFloat(otherNumberValue)) {
                return myNumberValue.doubleValue() == otherNumberValue.doubleValue();
            }
        }
        if (ridMapper != null && myValue instanceof ORID && otherValue instanceof ORID && ((ORID)myValue).isPersistent() && (convertedValue = ridMapper.map((ORID)myValue)) != null) {
            myValue = convertedValue;
        }
        return myValue.equals(otherValue);
    }

    private static boolean isInteger(Number value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
    }

    private static boolean isFloat(Number value) {
        return value instanceof Float || value instanceof Double;
    }

    public static void deleteCrossRefs(ORID iRid, ODocument iContent) {
        for (String fieldName : iContent.fieldNames()) {
            Object fieldValue = iContent.field(fieldName);
            if (fieldValue == null) continue;
            if (fieldValue.equals(iRid)) {
                iContent.field(fieldName, (Object)null);
                iContent.save();
                continue;
            }
            if (fieldValue instanceof ODocument && ((ODocument)fieldValue).isEmbedded()) {
                ODocumentHelper.deleteCrossRefs(iRid, (ODocument)fieldValue);
                continue;
            }
            if (!OMultiValue.isMultiValue(fieldValue)) continue;
            Iterator it = OMultiValue.getMultiValueIterator(fieldValue);
            while (it.hasNext()) {
                Object item = it.next();
                if (fieldValue.equals(iRid)) {
                    it.remove();
                    continue;
                }
                if (!(item instanceof ODocument) || !((ODocument)item).isEmbedded()) continue;
                ODocumentHelper.deleteCrossRefs(iRid, (ODocument)item);
            }
        }
    }

    public static <T> T makeDbCall(ODatabaseRecord databaseRecord, ODbRelatedCall<T> function) {
        ODatabaseRecordThreadLocal.INSTANCE.set(databaseRecord);
        return function.call();
    }

    public static interface RIDMapper {
        public ORID map(ORID var1);
    }

    public static interface ODbRelatedCall<T> {
        public T call();
    }
}

