/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptDocumentDatabaseWrapper;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.command.script.OScriptOrientWrapper;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OSchedulerListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class OScheduler
implements Runnable {
    public static final String CLASSNAME = "OSchedule";
    public static String PROP_NAME = "name";
    public static String PROP_RULE = "rule";
    public static String PROP_ARGUMENTS = "arguments";
    public static String PROP_STATUS = "status";
    public static String PROP_FUNC = "function";
    public static String PROP_STARTTIME = "starttime";
    public static String PROP_STARTED = "start";
    private String name;
    private String rule;
    private Map<Object, Object> iArgs;
    private String status;
    private OFunction function;
    private Date startTime;
    private ODocument document;
    private ODatabaseRecord db;
    private boolean started;
    private boolean isRunning = false;

    public OScheduler(ODocument doc) {
        this.name = (String)doc.field(PROP_NAME);
        this.rule = (String)doc.field(PROP_RULE);
        this.iArgs = (Map)doc.field(PROP_ARGUMENTS);
        this.status = (String)doc.field(PROP_STATUS);
        this.started = doc.field(PROP_STARTED) == null ? false : (Boolean)doc.field(PROP_STARTED);
        ODocument funcDoc = (ODocument)doc.field(PROP_FUNC);
        if (funcDoc == null) {
            throw new OCommandScriptException("function cannot be null");
        }
        this.function = new OFunction(funcDoc);
        this.startTime = (Date)doc.field(PROP_STARTTIME);
        this.document = doc;
        this.db = doc.getDatabase();
    }

    public String getSchedulingRule() {
        return this.rule;
    }

    public String getSchduleName() {
        return this.name;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<Object, Object> arguments() {
        return this.iArgs;
    }

    public OFunction getFunction() {
        return this.function;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void resetDocument(ODocument doc) {
        this.document = doc;
        this.name = (String)doc.field(PROP_NAME);
        this.rule = (String)doc.field(PROP_RULE);
        this.iArgs = (Map)doc.field(PROP_ARGUMENTS);
        this.status = (String)doc.field(PROP_STATUS);
        this.started = doc.field(PROP_STARTED) == null ? false : (Boolean)doc.field(PROP_STARTED);
        ODocument funcDoc = (ODocument)doc.field(PROP_FUNC);
        if (funcDoc == null) {
            throw new OCommandScriptException("function cannot be null");
        }
        this.function = new OFunction(funcDoc);
        this.startTime = (Date)doc.field(PROP_STARTTIME);
        this.db = doc.getDatabase();
    }

    public String toString() {
        String str = "OSchedule <name:" + this.name + ",rule:" + this.rule + ",current status:" + this.status + ",func:" + this.function.getName() + ",start:" + this.isStarted() + ">";
        return str;
    }

    @Override
    public void run() {
        this.isRunning = true;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        Date date = new Date(System.currentTimeMillis());
        OLogManager.instance().warn((Object)this, "execute : " + this.toString() + " at " + sdf.format(date), new Object[0]);
        ODatabaseRecordThreadLocal.INSTANCE.set(this.db);
        this.document.field(PROP_STATUS, (Object)OSchedulerListener.SCHEDULER_STATUS.RUNNING);
        this.document.field(PROP_STARTTIME, System.currentTimeMillis());
        this.document.save();
        OScriptManager scriptManager = null;
        Bindings binding = null;
        try {
            if (this.function == null) {
                return;
            }
            if (this.db != null && !(this.db instanceof ODatabaseRecordTx)) {
                this.db = (ODatabaseRecord)this.db.getUnderlying();
            }
            scriptManager = Orient.instance().getScriptManager();
            ScriptEngine scriptEngine = scriptManager.getEngine(this.function.getLanguage());
            binding = scriptEngine.getBindings(100);
            for (OScriptInjection oScriptInjection : scriptManager.getInjections()) {
                oScriptInjection.bind(binding);
            }
            binding.put("doc", (Object)this.document);
            if (this.db != null) {
                binding.put("db", (Object)new OScriptDocumentDatabaseWrapper((ODatabaseRecordTx)this.db));
            }
            binding.put("orient", (Object)new OScriptOrientWrapper(this.db));
            if (this.iArgs != null) {
                for (Map.Entry entry : this.iArgs.entrySet()) {
                    binding.put(entry.getKey().toString(), entry.getValue());
                }
                binding.put("params", (Object)this.iArgs.values().toArray());
            } else {
                binding.put("params", (Object)new Object[0]);
            }
            if (this.function.getLanguage() == null) {
                throw new OConfigurationException("Database function '" + this.function.getName() + "' has no language");
            }
            String funcStr = scriptManager.getFunctionDefinition(this.function);
            if (funcStr != null) {
                try {
                    scriptEngine.eval(funcStr);
                }
                catch (ScriptException scriptException) {
                    scriptManager.getErrorMessage(scriptException, funcStr);
                }
            }
            if (scriptEngine instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)scriptEngine);
                Object[] args = null;
                if (this.iArgs != null) {
                    args = new Object[this.iArgs.size()];
                    int i = 0;
                    for (Map.Entry<Object, Object> arg : this.iArgs.entrySet()) {
                        args[i++] = arg.getValue();
                    }
                }
                invocable.invokeFunction(this.function.getName(), args);
            }
            if (scriptManager != null && binding != null) {
                scriptManager.unbind(binding);
            }
        }
        catch (ScriptException e) {
            throw new OCommandScriptException("Error on execution of the script", this.function.getName(), e.getColumnNumber(), e);
        }
        catch (NoSuchMethodException e) {
            throw new OCommandScriptException("Error on execution of the script", this.function.getName(), 0, e);
        }
        catch (OCommandScriptException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new OCommandScriptException("Unknown Exception", this.function.getName(), 0, ex);
        }
        finally {
            if (scriptManager != null && binding != null) {
                scriptManager.unbind(binding);
            }
            OLogManager.instance().warn((Object)this, "Job : " + this.toString() + " Finished!", new Object[0]);
            this.isRunning = false;
            this.document.field(PROP_STATUS, (Object)OSchedulerListener.SCHEDULER_STATUS.WAITING);
            this.document.save();
        }
        OLogManager.instance().warn((Object)this, "Job : " + this.toString() + " Finished!", new Object[0]);
        this.isRunning = false;
        this.document.field(PROP_STATUS, (Object)OSchedulerListener.SCHEDULER_STATUS.WAITING);
        this.document.save();
    }
}

