/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.schedule.OSchedulerListener;

public class OSchedulerTrigger
extends ODocumentHookAbstract {
    public OSchedulerTrigger() {
        this.setIncludeClasses("OSchedule");
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        boolean start;
        String name = (String)iDocument.field(OScheduler.PROP_NAME);
        OScheduler scheduler = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchedulerListener().getScheduler(name);
        if (scheduler != null) {
            throw new OException("Duplicate Scheduler");
        }
        boolean bl = start = iDocument.field(OScheduler.PROP_STARTED) == null ? false : (Boolean)iDocument.field(OScheduler.PROP_STARTED);
        if (start) {
            iDocument.field(OScheduler.PROP_STATUS, OSchedulerListener.SCHEDULER_STATUS.WAITING.name());
        } else {
            iDocument.field(OScheduler.PROP_STATUS, OSchedulerListener.SCHEDULER_STATUS.STOPPED.name());
        }
        iDocument.field(OScheduler.PROP_STARTED, start);
        return ORecordHook.RESULT.RECORD_CHANGED;
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        OScheduler scheduler = new OScheduler(iDocument);
        ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchedulerListener().addScheduler(scheduler);
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        try {
            boolean isStart = iDocument.field(OScheduler.PROP_STARTED) == null ? false : (Boolean)iDocument.field(OScheduler.PROP_STARTED);
            String schedulerName = (String)iDocument.field(OScheduler.PROP_NAME);
            OScheduler scheduler = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchedulerListener().getScheduler(schedulerName);
            if (isStart) {
                String currentStatus;
                if (scheduler == null) {
                    scheduler = new OScheduler(iDocument);
                    ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchedulerListener().addScheduler(scheduler);
                }
                if ((currentStatus = (String)iDocument.field(OScheduler.PROP_STATUS)).equals(OSchedulerListener.SCHEDULER_STATUS.STOPPED.name())) {
                    iDocument.field(OScheduler.PROP_STATUS, OSchedulerListener.SCHEDULER_STATUS.WAITING.name());
                }
            } else if (scheduler != null) {
                iDocument.field(OScheduler.PROP_STATUS, OSchedulerListener.SCHEDULER_STATUS.STOPPED.name());
            }
            scheduler.resetDocument(iDocument);
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "Error when updating scheduler - " + ex.getMessage(), new Object[0]);
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        return ORecordHook.RESULT.RECORD_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        String schedulerName = (String)iDocument.field(OScheduler.PROP_NAME);
        OScheduler scheduler = null;
        scheduler = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchedulerListener().getScheduler(schedulerName);
        if (scheduler != null) {
            ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchedulerListener().removeScheduler(scheduler);
        }
        return ORecordHook.RESULT.RECORD_CHANGED;
    }
}

