/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.types.OBinary;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializerAnyStreamable;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OStringSerializerHelper {
    public static final char RECORD_SEPARATOR = ',';
    public static final String CLASS_SEPARATOR = "@";
    public static final char LINK = '#';
    public static final char EMBEDDED_BEGIN = '(';
    public static final char EMBEDDED_END = ')';
    public static final char LIST_BEGIN = '[';
    public static final char LIST_END = ']';
    public static final char SET_BEGIN = '<';
    public static final String LINKSET_PREFIX = "<#@";
    public static final char SET_END = '>';
    public static final char MAP_BEGIN = '{';
    public static final char MAP_END = '}';
    public static final char BAG_BEGIN = '%';
    public static final char BAG_END = ';';
    public static final char BINARY_BEGINEND = '_';
    public static final char CUSTOM_TYPE = '^';
    public static final char ENTRY_SEPARATOR = ':';
    public static final char PARAMETER_NAMED = ':';
    public static final char PARAMETER_POSITIONAL = '?';
    public static final char[] PARAMETER_SEPARATOR = new char[]{','};
    public static final char[] PARAMETER_EXT_SEPARATOR = new char[]{' ', '.'};
    public static final char[] DEFAULT_IGNORE_CHARS = new char[]{'\n', '\r', ' '};
    public static final char[] DEFAULT_FIELD_SEPARATOR = new char[]{',', ' '};
    public static final char COLLECTION_SEPARATOR = ',';

    public static Object fieldTypeFromStream(ODocument iDocument, OType iType, Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iType == null) {
            iType = OType.EMBEDDED;
        }
        switch (iType) {
            case STRING: {
                if (iValue instanceof String) {
                    String s = (String)iValue;
                    return OStringSerializerHelper.decode(s.substring(1, s.length() - 1));
                }
                return iValue.toString();
            }
            case INTEGER: {
                if (iValue instanceof Integer) {
                    return iValue;
                }
                return new Integer(OStringSerializerHelper.getStringContent(iValue));
            }
            case BOOLEAN: {
                if (iValue instanceof Boolean) {
                    return iValue;
                }
                return new Boolean(OStringSerializerHelper.getStringContent(iValue));
            }
            case DECIMAL: {
                if (iValue instanceof BigDecimal) {
                    return iValue;
                }
                return new BigDecimal(OStringSerializerHelper.getStringContent(iValue));
            }
            case FLOAT: {
                if (iValue instanceof Float) {
                    return iValue;
                }
                return new Float(OStringSerializerHelper.getStringContent(iValue));
            }
            case LONG: {
                if (iValue instanceof Long) {
                    return iValue;
                }
                return new Long(OStringSerializerHelper.getStringContent(iValue));
            }
            case DOUBLE: {
                if (iValue instanceof Double) {
                    return iValue;
                }
                return new Double(OStringSerializerHelper.getStringContent(iValue));
            }
            case SHORT: {
                if (iValue instanceof Short) {
                    return iValue;
                }
                return new Short(OStringSerializerHelper.getStringContent(iValue));
            }
            case BYTE: {
                if (iValue instanceof Byte) {
                    return iValue;
                }
                return new Byte(OStringSerializerHelper.getStringContent(iValue));
            }
            case BINARY: {
                return OStringSerializerHelper.getBinaryContent(iValue);
            }
            case DATE: 
            case DATETIME: {
                if (iValue instanceof Date) {
                    return iValue;
                }
                return new Date(Long.parseLong(OStringSerializerHelper.getStringContent(iValue)));
            }
            case LINK: {
                if (iValue instanceof ORID) {
                    return iValue.toString();
                }
                if (iValue instanceof String) {
                    return new ORecordId((String)iValue);
                }
                return ((ORecord)iValue).getIdentity().toString();
            }
            case EMBEDDED: {
                return OStringSerializerAnyStreamable.INSTANCE.fromStream((String)iValue);
            }
            case EMBEDDEDMAP: {
                String value = (String)iValue;
                return ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedMapFromStream(iDocument, null, value, null);
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " does not support converting value: " + iValue);
    }

    public static String smartTrim(String iSource, boolean iRemoveLeadingSpaces, boolean iRemoveTailingSpaces) {
        StringBuilder buffer = new StringBuilder();
        boolean spaced = iRemoveLeadingSpaces;
        for (int i = 0; i < iSource.length(); ++i) {
            char c = iSource.charAt(i);
            if (c != ' ') {
                spaced = false;
                buffer.append(c);
                continue;
            }
            if (spaced) continue;
            spaced = true;
            buffer.append(c);
        }
        int len = buffer.length();
        if (iRemoveTailingSpaces && buffer.charAt(len - 1) == ' ') {
            buffer.setLength(len - 1);
        }
        return buffer.toString();
    }

    public static List<String> smartSplit(String iSource, char iRecordSeparator, char ... iJumpChars) {
        return OStringSerializerHelper.smartSplit(iSource, new char[]{iRecordSeparator}, 0, -1, true, true, false, false, iJumpChars);
    }

    public static List<String> smartSplit(String iSource, char iRecordSeparator, boolean iConsiderSets, boolean considerBags, char ... iJumpChars) {
        return OStringSerializerHelper.smartSplit(iSource, new char[]{iRecordSeparator}, 0, -1, false, true, iConsiderSets, considerBags, iJumpChars);
    }

    public static List<String> smartSplit(String iSource, char[] iRecordSeparator, int beginIndex, int endIndex, boolean iStringSeparatorExtended, boolean iConsiderBraces, boolean iConsiderSets, boolean considerBags, char ... iJumpChars) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> parts = new ArrayList<String>();
        if (iSource != null && !iSource.isEmpty()) {
            char[] source = iSource.toCharArray();
            while ((beginIndex = OStringSerializerHelper.parse(source, buffer, beginIndex, endIndex, iRecordSeparator, iStringSeparatorExtended, iConsiderBraces, iConsiderSets, -1, considerBags, iJumpChars)) > -1) {
                parts.add(buffer.toString());
                buffer.setLength(0);
            }
            if (buffer.length() > 0 || OStringSerializerHelper.isCharPresent(iSource.charAt(iSource.length() - 1), iRecordSeparator)) {
                parts.add(buffer.toString());
            }
        }
        return parts;
    }

    public static List<String> smartSplit(String iSource, char[] iRecordSeparator, boolean[] iRecordSeparatorIncludeAsPrefix, boolean[] iRecordSeparatorIncludeAsPostfix, int beginIndex, int endIndex, boolean iStringSeparatorExtended, boolean iConsiderBraces, boolean iConsiderSets, boolean considerBags, char ... iJumpChars) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> parts = new ArrayList<String>();
        int startSeparatorAt = -1;
        if (iSource != null && !iSource.isEmpty()) {
            char[] source = iSource.toCharArray();
            block0: while ((beginIndex = OStringSerializerHelper.parse(source, buffer, beginIndex, endIndex, iRecordSeparator, iStringSeparatorExtended, iConsiderBraces, iConsiderSets, startSeparatorAt, considerBags, iJumpChars)) > -1) {
                int i;
                char lastSeparator;
                if (beginIndex > -1) {
                    lastSeparator = source[beginIndex - 1];
                    for (i = 0; i < iRecordSeparator.length; ++i) {
                        if (iRecordSeparator[i] != lastSeparator) continue;
                        if (!iRecordSeparatorIncludeAsPrefix[i]) break;
                        buffer.append(lastSeparator);
                        break;
                    }
                }
                if (buffer.length() > 0) {
                    parts.add(buffer.toString());
                    buffer.setLength(0);
                }
                startSeparatorAt = beginIndex;
                if (beginIndex <= -1) continue;
                lastSeparator = source[beginIndex - 1];
                for (i = 0; i < iRecordSeparator.length; ++i) {
                    if (iRecordSeparator[i] != lastSeparator) continue;
                    if (!iRecordSeparatorIncludeAsPostfix[i]) continue block0;
                    startSeparatorAt = --beginIndex + 1;
                    continue block0;
                }
            }
            if (buffer.length() > 0) {
                parts.add(buffer.toString());
            }
        }
        return parts;
    }

    public static int parse(String iSource, StringBuilder iBuffer, int beginIndex, int endIndex, char[] iSeparator, boolean iStringSeparatorExtended, boolean iConsiderBraces, boolean iConsiderSets, int iMinPosSeparatorAreValid, boolean considerBags, char ... iJumpChars) {
        return OStringSerializerHelper.parse(iSource.toCharArray(), iBuffer, beginIndex, endIndex, iSeparator, iStringSeparatorExtended, iConsiderBraces, iConsiderSets, iMinPosSeparatorAreValid, considerBags, iJumpChars);
    }

    public static int parse(char[] iSource, StringBuilder iBuffer, int beginIndex, int endIndex, char[] iSeparator, boolean iStringSeparatorExtended, boolean iConsiderBraces, boolean iConsiderSets, int iMinPosSeparatorAreValid, boolean considerBags, char ... iJumpChars) {
        char c;
        int i;
        if (beginIndex < 0) {
            return beginIndex;
        }
        char stringBeginChar = ' ';
        boolean encodeMode = false;
        int insideParenthesis = 0;
        int insideList = 0;
        int insideSet = 0;
        int insideMap = 0;
        int insideLinkPart = 0;
        int insideBag = 0;
        int max = endIndex > -1 ? endIndex + 1 : iSource.length;
        iBuffer.ensureCapacity(max);
        for (i = beginIndex; i < max && OStringSerializerHelper.isCharPresent(c = iSource[i], iJumpChars); ++i) {
        }
        while (i < max) {
            block43: {
                block50: {
                    block44: {
                        block49: {
                            char nextChar;
                            block48: {
                                block47: {
                                    block46: {
                                        block45: {
                                            block42: {
                                                block41: {
                                                    c = iSource[i];
                                                    if (stringBeginChar != 32) break block41;
                                                    if (iConsiderBraces) {
                                                        if (c == '[') {
                                                            if (i < iMinPosSeparatorAreValid || insideParenthesis > 0 || insideList > 0 || !OStringSerializerHelper.isCharPresent(c, iSeparator)) {
                                                                ++insideList;
                                                            }
                                                        } else if (c == ']') {
                                                            if (i < iMinPosSeparatorAreValid || insideParenthesis > 0 || insideList > 0 || !OStringSerializerHelper.isCharPresent(c, iSeparator)) {
                                                                if (insideList == 0) {
                                                                    throw new OSerializationException("Found invalid ] character at position " + i + " of text " + new String(iSource) + ". Ensure it is opened and closed correctly.");
                                                                }
                                                                --insideList;
                                                            }
                                                        } else if (c == '(') {
                                                            ++insideParenthesis;
                                                        } else if (c == ')') {
                                                            if (insideParenthesis == 0) {
                                                                throw new OSerializationException("Found invalid ) character at position " + i + " of text " + new String(iSource) + ". Ensure it is opened and closed correctly.");
                                                            }
                                                            --insideParenthesis;
                                                        } else if (c == '{') {
                                                            ++insideMap;
                                                        } else if (c == '}') {
                                                            if (i < iMinPosSeparatorAreValid || !OStringSerializerHelper.isCharPresent(c, iSeparator)) {
                                                                if (insideMap == 0) {
                                                                    throw new OSerializationException("Found invalid } character at position " + i + " of text " + new String(iSource) + ". Ensure it is opened and closed correctly.");
                                                                }
                                                                --insideMap;
                                                            }
                                                        } else if (c == '#') {
                                                            insideLinkPart = 1;
                                                        } else if (insideLinkPart == 1 && c == ':') {
                                                            insideLinkPart = 2;
                                                        } else {
                                                            if (iConsiderSets) {
                                                                if (c == '<') {
                                                                    ++insideSet;
                                                                } else if (!(c != '>' || i >= iMinPosSeparatorAreValid && OStringSerializerHelper.isCharPresent(c, iSeparator))) {
                                                                    if (insideSet == 0) {
                                                                        throw new OSerializationException("Found invalid > character at position " + i + " of text " + new String(iSource) + ". Ensure it is opened and closed correctly.");
                                                                    }
                                                                    --insideSet;
                                                                }
                                                            }
                                                            if (considerBags) {
                                                                if (c == '%') {
                                                                    ++insideBag;
                                                                } else if (c == ';' && !OStringSerializerHelper.isCharPresent(c, iSeparator)) {
                                                                    if (insideBag == 0) {
                                                                        throw new OSerializationException("Found invalid % character. Ensure it is opened and closed correctly.");
                                                                    }
                                                                    --insideBag;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    if (insideLinkPart > 0 && c != '-' && !Character.isDigit(c) && c != ':' && c != '#') {
                                                        insideLinkPart = 0;
                                                    }
                                                    if ((c == '\"' || iStringSeparatorExtended && c == '\'') && !encodeMode) {
                                                        stringBeginChar = c;
                                                    }
                                                    if (insideParenthesis == 0 && insideList == 0 && insideSet == 0 && insideMap == 0 && insideLinkPart == 0 && insideBag == 0 && i >= iMinPosSeparatorAreValid && OStringSerializerHelper.isCharPresent(c, iSeparator)) {
                                                        return i + 1;
                                                    }
                                                    if (iJumpChars.length <= 0 || i < iMinPosSeparatorAreValid || !OStringSerializerHelper.isCharPresent(c, iJumpChars)) break block42;
                                                    break block43;
                                                }
                                                if ((c == '\"' || iStringSeparatorExtended && c == '\'') && !encodeMode && stringBeginChar == c) {
                                                    stringBeginChar = ' ';
                                                }
                                            }
                                            if (c != '\\' || encodeMode) break block44;
                                            nextChar = iSource[i + 1];
                                            if (nextChar != 'u') break block45;
                                            i = OStringParser.readUnicode((char[])iSource, (int)(i + 2), (StringBuilder)iBuffer);
                                            break block43;
                                        }
                                        if (nextChar != 'n') break block46;
                                        iBuffer.append("\n");
                                        ++i;
                                        break block43;
                                    }
                                    if (nextChar != 'r') break block47;
                                    iBuffer.append("\r");
                                    ++i;
                                    break block43;
                                }
                                if (nextChar != 't') break block48;
                                iBuffer.append("\t");
                                ++i;
                                break block43;
                            }
                            if (nextChar != 'f') break block49;
                            iBuffer.append("\f");
                            ++i;
                            break block43;
                        }
                        encodeMode = true;
                        break block50;
                    }
                    encodeMode = false;
                }
                if (c != '\\' && encodeMode) {
                    encodeMode = false;
                }
                iBuffer.append(c);
            }
            ++i;
        }
        return -1;
    }

    public static boolean isCharPresent(char iCharacter, char[] iCharacters) {
        int len = iCharacters.length;
        for (int i = 0; i < len; ++i) {
            if (iCharacter != iCharacters[i]) continue;
            return true;
        }
        return false;
    }

    public static List<String> split(String iSource, char iRecordSeparator, char ... iJumpCharacters) {
        return OStringSerializerHelper.split(iSource, 0, iSource.length(), iRecordSeparator, iJumpCharacters);
    }

    public static Collection<String> split(Collection<String> iParts, String iSource, char iRecordSeparator, char ... iJumpCharacters) {
        return OStringSerializerHelper.split(iParts, iSource, 0, iSource.length(), iRecordSeparator, iJumpCharacters);
    }

    public static List<String> split(String iSource, int iStartPosition, int iEndPosition, char iRecordSeparator, char ... iJumpCharacters) {
        return (List)OStringSerializerHelper.split(new ArrayList<String>(), iSource, iStartPosition, iSource.length(), iRecordSeparator, iJumpCharacters);
    }

    public static Collection<String> split(Collection<String> iParts, String iSource, int iStartPosition, int iEndPosition, char iRecordSeparator, char ... iJumpCharacters) {
        return OStringSerializerHelper.split(iParts, iSource, iStartPosition, iEndPosition, String.valueOf(iRecordSeparator), iJumpCharacters);
    }

    public static Collection<String> split(Collection<String> iParts, String iSource, int iStartPosition, int iEndPosition, String iRecordSeparators, char ... iJumpCharacters) {
        if (iEndPosition == -1) {
            iEndPosition = iSource.length();
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = iStartPosition; i < iEndPosition; ++i) {
            char c = iSource.charAt(i);
            if (iRecordSeparators.indexOf(c) > -1) {
                iParts.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (iJumpCharacters.length > 0 && buffer.length() == 0) {
                if (OStringSerializerHelper.isCharPresent(c, iJumpCharacters)) continue;
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        if (iJumpCharacters.length > 0 && buffer.length() > 0) {
            int newSize = 0;
            for (int i = buffer.length() - 1; i >= 0; --i) {
                char b = buffer.charAt(i);
                boolean found = false;
                for (char j : iJumpCharacters) {
                    if (j != b) continue;
                    found = true;
                    ++newSize;
                    break;
                }
                if (!found) break;
            }
            if (newSize > 0) {
                buffer.setLength(buffer.length() - newSize);
            }
        }
        iParts.add(buffer.toString());
        return iParts;
    }

    public static String joinIntArray(int[] iArray) {
        StringBuilder ids = new StringBuilder();
        for (int id : iArray) {
            if (ids.length() > 0) {
                ids.append(',');
            }
            ids.append(id);
        }
        return ids.toString();
    }

    public static int[] splitIntArray(String iInput) {
        List<String> items = OStringSerializerHelper.split(iInput, ',', new char[0]);
        int[] values = new int[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            values[i] = Integer.parseInt(items.get(i).trim());
        }
        return values;
    }

    public static boolean contains(String iText, char iSeparator) {
        if (iText == null) {
            return false;
        }
        int max = iText.length();
        for (int i = 0; i < max; ++i) {
            if (iText.charAt(i) != iSeparator) continue;
            return true;
        }
        return false;
    }

    public static int getCollection(String iText, int iStartPosition, Collection<String> iCollection) {
        return OStringSerializerHelper.getCollection(iText, iStartPosition, iCollection, '[', ']', ',');
    }

    public static int getCollection(String iText, int iStartPosition, Collection<String> iCollection, char iCollectionBegin, char iCollectionEnd, char iCollectionSeparator) {
        StringBuilder buffer = new StringBuilder();
        int openPos = iText.indexOf(iCollectionBegin, iStartPosition);
        if (openPos == -1) {
            return -1;
        }
        boolean escape = false;
        int maxPos = iText.length() - 1;
        int currentPos = openPos + 1;
        int deep = 1;
        while (deep > 0) {
            if (currentPos > maxPos) {
                return -1;
            }
            char c = iText.charAt(currentPos);
            if (buffer.length() != 0 || c != ' ') {
                if (c == iCollectionBegin) {
                    buffer.append(c);
                    ++deep;
                } else if (c == iCollectionEnd) {
                    if (deep > 1) {
                        buffer.append(c);
                    }
                    --deep;
                } else if (c == iCollectionSeparator) {
                    if (deep > 1) {
                        buffer.append(c);
                    } else {
                        iCollection.add(buffer.toString().trim());
                        buffer.setLength(0);
                    }
                } else if (!escape && c == '\\' && currentPos + 1 <= maxPos) {
                    char nextChar = iText.charAt(currentPos + 1);
                    if (nextChar == 'u') {
                        currentPos = OStringParser.readUnicode((String)iText, (int)(currentPos + 2), (StringBuilder)buffer);
                    } else if (nextChar == 'n') {
                        buffer.append("\n");
                        ++currentPos;
                    } else if (nextChar == 'r') {
                        buffer.append("\r");
                        ++currentPos;
                    } else if (nextChar == 't') {
                        buffer.append("\t");
                        ++currentPos;
                    } else if (nextChar == 'f') {
                        buffer.append("\f");
                        ++currentPos;
                    } else {
                        escape = true;
                    }
                } else {
                    escape = false;
                    buffer.append(c);
                }
            }
            ++currentPos;
        }
        if (buffer.length() > 0) {
            iCollection.add(buffer.toString().trim());
        }
        return --currentPos;
    }

    public static int getParameters(String iText, int iBeginPosition, int iEndPosition, List<String> iParameters) {
        iParameters.clear();
        int openPos = iText.indexOf(40, iBeginPosition);
        if (openPos == -1 || iEndPosition > -1 && openPos > iEndPosition) {
            return iBeginPosition;
        }
        StringBuilder buffer = new StringBuilder();
        OStringSerializerHelper.parse(iText, buffer, openPos, iEndPosition, PARAMETER_EXT_SEPARATOR, true, true, false, -1, false, new char[0]);
        if (buffer.length() == 0) {
            return iBeginPosition;
        }
        String t = buffer.substring(1, buffer.length() - 1).trim();
        List<String> pars = OStringSerializerHelper.smartSplit(t, PARAMETER_SEPARATOR, 0, -1, true, true, false, false, new char[0]);
        for (int i = 0; i < pars.size(); ++i) {
            iParameters.add(pars.get(i).trim());
        }
        return iBeginPosition + buffer.length();
    }

    public static int getEmbedded(String iText, int iBeginPosition, int iEndPosition, StringBuilder iEmbedded) {
        int openPos = iText.indexOf(40, iBeginPosition);
        if (openPos == -1 || iEndPosition > -1 && openPos > iEndPosition) {
            return iBeginPosition;
        }
        StringBuilder buffer = new StringBuilder();
        OStringSerializerHelper.parse(iText, buffer, openPos, iEndPosition, PARAMETER_EXT_SEPARATOR, true, true, false, -1, false, new char[0]);
        if (buffer.length() == 0) {
            return iBeginPosition;
        }
        String t = buffer.substring(1, buffer.length() - 1).trim();
        iEmbedded.append(t);
        return iBeginPosition + buffer.length();
    }

    public static List<String> getParameters(String iText) {
        ArrayList<String> params = new ArrayList<String>();
        try {
            OStringSerializerHelper.getParameters(iText, 0, -1, params);
        }
        catch (Exception e) {
            throw new OCommandSQLParsingException("Error on reading parameters in: " + iText);
        }
        return params;
    }

    public static Map<String, String> getMap(String iText) {
        int openPos = iText.indexOf(123);
        if (openPos == -1) {
            return Collections.emptyMap();
        }
        int closePos = iText.indexOf(125, openPos + 1);
        if (closePos == -1) {
            return Collections.emptyMap();
        }
        List<String> entries = OStringSerializerHelper.smartSplit(iText.substring(openPos + 1, closePos), ',', new char[0]);
        if (entries.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : entries) {
            if (item == null || item.isEmpty()) continue;
            List<String> entry = OStringSerializerHelper.split(item, ':', new char[0]);
            map.put((String)OStringSerializerHelper.fieldTypeFromStream(null, OType.STRING, entry.get(0)), entry.get(1));
        }
        return map;
    }

    public static String encode(String iText) {
        char c;
        int pos = -1;
        int newSize = iText.length();
        for (int i = 0; i < newSize; ++i) {
            c = iText.charAt(i);
            if (c != '\"' && c != '\\') continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            StringBuilder iOutput = new StringBuilder();
            for (int i = 0; i < iText.length(); ++i) {
                c = iText.charAt(i);
                if (c == '\"' || c == '\\') {
                    iOutput.append('\\');
                }
                iOutput.append(c);
            }
            return iOutput.toString();
        }
        return iText;
    }

    public static String decode(String iText) {
        int pos = -1;
        int textSize = iText.length();
        for (int i = 0; i < textSize; ++i) {
            if (iText.charAt(i) != '\"' && iText.charAt(i) != '\\') continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return iText;
        }
        StringBuilder buffer = new StringBuilder(textSize);
        buffer.append(iText.substring(0, pos));
        boolean escaped = false;
        for (int i = pos; i < textSize; ++i) {
            char c = iText.charAt(i);
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static OClass getRecordClassName(String iValue, OClass iLinkedClass) {
        int classSeparatorPos = OStringParser.indexOfOutsideStrings((String)iValue, (char)CLASS_SEPARATOR.charAt(0), (int)0, (int)-1);
        if (classSeparatorPos > -1) {
            String className = iValue.substring(0, classSeparatorPos);
            ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
            if (className != null && database != null) {
                iLinkedClass = database.getMetadata().getSchema().getClass(className);
            }
        }
        return iLinkedClass;
    }

    public static String getStringContent(Object iValue) {
        return OIOUtils.getStringContent((Object)iValue);
    }

    public static byte[] getBinaryContent(Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue instanceof OBinary) {
            return ((OBinary)iValue).toByteArray();
        }
        if (iValue instanceof byte[]) {
            return (byte[])iValue;
        }
        if (iValue instanceof String) {
            String s = (String)iValue;
            if (s.length() > 1 && s.charAt(0) == '_' && s.charAt(s.length() - 1) == '_' || s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
                s = s.substring(1, s.length() - 1);
            }
            return OBase64Utils.decode(s);
        }
        throw new IllegalArgumentException("Cannot parse binary as the same type as the value (class=" + iValue.getClass().getName() + "): " + iValue);
    }

    public static boolean isAlphanumeric(String iContent) {
        int tot = iContent.length();
        for (int i = 0; i < tot; ++i) {
            if (Character.isLetterOrDigit(iContent.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String removeQuotationMarks(String iValue) {
        if (iValue != null && iValue.length() > 1 && (iValue.charAt(0) == '\'' && iValue.charAt(iValue.length() - 1) == '\'' || iValue.charAt(0) == '\"' && iValue.charAt(iValue.length() - 1) == '\"')) {
            return iValue.substring(1, iValue.length() - 1);
        }
        return iValue;
    }

    public static boolean startsWithIgnoreCase(String iFirst, String iSecond) {
        if (iFirst == null) {
            throw new IllegalArgumentException("Origin string to compare is null");
        }
        if (iSecond == null) {
            throw new IllegalArgumentException("String to match is null");
        }
        int iSecondLength = iSecond.length();
        if (iSecondLength > iFirst.length()) {
            return false;
        }
        for (int i = 0; i < iSecondLength; ++i) {
            if (Character.toUpperCase(iFirst.charAt(i)) == Character.toUpperCase(iSecond.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(String iSource, int iBegin, char ... iChars) {
        if (iChars.length == 1) {
            return iSource.indexOf(iChars[0], iBegin);
        }
        int len = iSource.length();
        for (int i = iBegin; i < len; ++i) {
            for (int k = 0; k < iChars.length; ++k) {
                char c = iSource.charAt(i);
                if (c != iChars[k]) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findEndBlock(String iOrigin, char iBeginChar, char iEndChar, int iBeginOffset) {
        int inc = 0;
        for (int i = iBeginOffset; i < iOrigin.length(); ++i) {
            char c = iOrigin.charAt(i);
            if (c == '\'') {
                int tend = i;
                do {
                    if ((tend = iOrigin.indexOf(39, tend + 1)) >= 0) continue;
                    throw new OCommandSQLParsingException("Could not find end of text area.", iOrigin, i);
                } while (iOrigin.charAt(tend - 1) == '\\');
                i = tend;
                continue;
            }
            if (c != iBeginChar && c != iEndChar) continue;
            if (c == iBeginChar) {
                ++inc;
                continue;
            }
            if (c != iEndChar || --inc != 0) continue;
            return i;
        }
        return -1;
    }

    public static int getLowerIndexOf(String iText, int iBeginOffset, String ... iToSearch) {
        int lowest = -1;
        for (String toSearch : iToSearch) {
            int index = iText.indexOf(toSearch, iBeginOffset);
            if (index <= -1 || lowest != -1 && index >= lowest) continue;
            lowest = index;
        }
        return lowest;
    }

    public static int getHigherIndexOf(String iText, int iBeginOffset, String ... iToSearch) {
        int lowest = -1;
        for (String toSearch : iToSearch) {
            int index = iText.indexOf(toSearch, iBeginOffset);
            if (index <= -1 || lowest != -1 && index <= lowest) continue;
            lowest = index;
        }
        return lowest;
    }
}

