/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OBinaryTypeSerializer;
import com.orientechnologies.common.serialization.types.OBooleanSerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OCharSerializer;
import com.orientechnologies.common.serialization.types.ODateSerializer;
import com.orientechnologies.common.serialization.types.ODateTimeSerializer;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.ODoubleSerializer;
import com.orientechnologies.common.serialization.types.OFloatSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.ONullSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.common.serialization.types.OStringSerializer;
import com.orientechnologies.common.serialization.types.legacy.OStringSerializer_1_5_1;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerOldRIDContainer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerSBTreeIndexRIDContainer;
import com.orientechnologies.orient.core.storage.impl.local.eh.OClusterPositionSerializer;
import com.orientechnologies.orient.core.storage.impl.local.eh.OPhysicalPositionSerializer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OBinarySerializerFactory {
    private final ConcurrentMap<Byte, OBinarySerializer<?>> serializerIdMap = new ConcurrentHashMap();
    private final ConcurrentMap<Byte, Class<? extends OBinarySerializer<?>>> serializerClassesIdMap = new ConcurrentHashMap();
    private final ConcurrentMap<OType, OBinarySerializer<?>> serializerTypeMap = new ConcurrentHashMap();
    public static final int TYPE_IDENTIFIER_SIZE = 1;

    private OBinarySerializerFactory() {
    }

    public void registerSerializer(OBinarySerializer<?> iInstance, OType iType) {
        if (this.serializerIdMap.containsKey(iInstance.getId())) {
            throw new IllegalArgumentException("Binary serializer with id " + iInstance.getId() + " has been already registered.");
        }
        this.serializerIdMap.put(iInstance.getId(), iInstance);
        if (iType != null) {
            this.serializerTypeMap.put(iType, iInstance);
        }
    }

    public void registerSerializer(byte iId, Class<? extends OBinarySerializer> iClass) {
        if (this.serializerClassesIdMap.containsKey(iId)) {
            throw new IllegalStateException("Serializer with id " + iId + " has been already registered.");
        }
        this.serializerClassesIdMap.put(iId, iClass);
    }

    public OBinarySerializer<?> getObjectSerializer(byte identifier) {
        Class cls;
        OBinarySerializer impl = (OBinarySerializer)this.serializerIdMap.get(identifier);
        if (impl == null && (cls = (Class)this.serializerClassesIdMap.get(identifier)) != null) {
            try {
                impl = (OBinarySerializer)cls.newInstance();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot create an instance of class %s invoking the empty constructor", new Object[]{cls});
            }
        }
        return impl;
    }

    public <T> OBinarySerializer<T> getObjectSerializer(OType type) {
        return (OBinarySerializer)this.serializerTypeMap.get((Object)type);
    }

    public static OBinarySerializerFactory create(int binaryFormatVersion) {
        OBinarySerializerFactory factory = new OBinarySerializerFactory();
        factory.registerSerializer((OBinarySerializer<?>)new ONullSerializer(), null);
        factory.registerSerializer((OBinarySerializer<?>)OBooleanSerializer.INSTANCE, OType.BOOLEAN);
        factory.registerSerializer((OBinarySerializer<?>)OIntegerSerializer.INSTANCE, OType.INTEGER);
        factory.registerSerializer((OBinarySerializer<?>)OShortSerializer.INSTANCE, OType.SHORT);
        factory.registerSerializer((OBinarySerializer<?>)OLongSerializer.INSTANCE, OType.LONG);
        factory.registerSerializer((OBinarySerializer<?>)OFloatSerializer.INSTANCE, OType.FLOAT);
        factory.registerSerializer((OBinarySerializer<?>)ODoubleSerializer.INSTANCE, OType.DOUBLE);
        factory.registerSerializer((OBinarySerializer<?>)ODateTimeSerializer.INSTANCE, OType.DATETIME);
        factory.registerSerializer((OBinarySerializer<?>)OCharSerializer.INSTANCE, null);
        if (binaryFormatVersion <= 8) {
            factory.registerSerializer((OBinarySerializer<?>)OStringSerializer_1_5_1.INSTANCE, OType.STRING);
        } else {
            factory.registerSerializer((OBinarySerializer<?>)OStringSerializer.INSTANCE, OType.STRING);
        }
        factory.registerSerializer((OBinarySerializer<?>)OByteSerializer.INSTANCE, OType.BYTE);
        factory.registerSerializer((OBinarySerializer<?>)ODateSerializer.INSTANCE, OType.DATE);
        factory.registerSerializer(OLinkSerializer.INSTANCE, OType.LINK);
        factory.registerSerializer(OCompositeKeySerializer.INSTANCE, null);
        factory.registerSerializer(OStreamSerializerRID.INSTANCE, null);
        factory.registerSerializer((OBinarySerializer<?>)OBinaryTypeSerializer.INSTANCE, OType.BINARY);
        factory.registerSerializer((OBinarySerializer<?>)ODecimalSerializer.INSTANCE, OType.DECIMAL);
        factory.registerSerializer(OStreamSerializerListRID.INSTANCE, null);
        factory.registerSerializer(OStreamSerializerOldRIDContainer.INSTANCE, null);
        factory.registerSerializer(OStreamSerializerSBTreeIndexRIDContainer.INSTANCE, null);
        factory.registerSerializer(OPhysicalPositionSerializer.INSTANCE, null);
        factory.registerSerializer(OClusterPositionSerializer.INSTANCE, null);
        factory.registerSerializer((byte)15, OSimpleKeySerializer.class);
        return factory;
    }

    public static OBinarySerializerFactory getInstance() {
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (database != null) {
            return database.getSerializerFactory();
        }
        return OBinarySerializerFactory.create(Integer.MAX_VALUE);
    }
}

