/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;

public class OStreamSerializerRID
implements OStreamSerializer,
OBinarySerializer<OIdentifiable> {
    public static final String NAME = "p";
    public static final OStreamSerializerRID INSTANCE = new OStreamSerializerRID();
    public static final byte ID = 16;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null) {
            return null;
        }
        return new ORecordId().fromStream(iStream);
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        return ((OIdentifiable)iObject).getIdentity().toStream();
    }

    public int getObjectSize(OIdentifiable object, Object ... hints) {
        return OLinkSerializer.INSTANCE.getObjectSize(object.getIdentity(), new Object[0]);
    }

    public void serialize(OIdentifiable object, byte[] stream, int startPosition, Object ... hints) {
        OLinkSerializer.INSTANCE.serialize(object.getIdentity(), stream, startPosition, new Object[0]);
    }

    public ORID deserialize(byte[] stream, int startPosition) {
        return OLinkSerializer.INSTANCE.deserialize(stream, startPosition);
    }

    public int getObjectSize(byte[] stream, int startPosition) {
        return OLinkSerializer.INSTANCE.getObjectSize(stream, startPosition);
    }

    public byte getId() {
        return 16;
    }

    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OLinkSerializer.INSTANCE.getObjectSizeNative(stream, startPosition);
    }

    public void serializeNative(OIdentifiable object, byte[] stream, int startPosition, Object ... hints) {
        OLinkSerializer.INSTANCE.serializeNative(object.getIdentity(), stream, startPosition, new Object[0]);
    }

    public OIdentifiable deserializeNative(byte[] stream, int startPosition) {
        return OLinkSerializer.INSTANCE.deserializeNative(stream, startPosition);
    }

    public void serializeInDirectMemory(OIdentifiable object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        OLinkSerializer.INSTANCE.serializeInDirectMemory(object, pointer, offset, new Object[0]);
    }

    public OIdentifiable deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return OLinkSerializer.INSTANCE.deserializeFromDirectMemory(pointer, offset);
    }

    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return OLinkSerializer.INSTANCE.getObjectSizeInDirectMemory(pointer, offset);
    }

    public boolean isFixedLength() {
        return true;
    }

    public int getFixedLength() {
        return OLinkSerializer.RID_SIZE;
    }

    public OIdentifiable preprocess(OIdentifiable value, Object ... hints) {
        return value;
    }
}

