/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Map;

public class OCommandExecutorSQLExplain
extends OCommandExecutorSQLDelegate {
    public static final String KEYWORD_EXPLAIN = "EXPLAIN";

    @Override
    public OCommandExecutorSQLExplain parse(OCommandRequest iCommand) {
        String cmd = ((OCommandSQL)iCommand).getText();
        super.parse(new OCommandSQL(cmd.substring(KEYWORD_EXPLAIN.length())));
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        this.delegate.getContext().setRecordingMetrics(true);
        long startTime = System.nanoTime();
        Object result = super.execute(iArgs);
        ODocument report = new ODocument(this.delegate.getContext().getVariables());
        report.field("elapsed", Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f));
        if (result instanceof Collection) {
            report.field("resultType", "collection");
            report.field("resultSize", ((Collection)result).size());
        } else if (result instanceof ODocument) {
            report.field("resultType", "document");
            report.field("resultSize", 1);
        } else if (result instanceof Number) {
            report.field("resultType", "number");
        }
        return report;
    }
}

