/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class OCommandExecutorSQLInsert
extends OCommandExecutorSQLSetAware
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String KEYWORD_INSERT = "INSERT";
    protected static final String KEYWORD_RETURN = "RETURN";
    private static final String KEYWORD_VALUES = "VALUES";
    private String className = null;
    private String clusterName = null;
    private String indexName = null;
    private List<Map<String, Object>> newRecords;
    private OSQLAsynchQuery<OIdentifiable> subQuery = null;
    private AtomicLong saved = new AtomicLong(0L);
    private Object returnExpression = null;
    private List<ODocument> queryResult = null;

    public OCommandExecutorSQLInsert parse(OCommandRequest iRequest) {
        String temp;
        ODatabaseRecord database = OCommandExecutorSQLInsert.getDatabase();
        this.init((OCommandRequestText)iRequest);
        this.className = null;
        this.newRecords = null;
        this.content = null;
        this.parserRequiredKeyword(new String[]{KEYWORD_INSERT});
        this.parserRequiredKeyword(new String[]{"INTO"});
        String subjectName = this.parserRequiredWord(true, "Invalid subject name. Expected cluster, class or index");
        if (subjectName.startsWith("CLUSTER:")) {
            this.clusterName = subjectName.substring("CLUSTER:".length());
        } else if (subjectName.startsWith("INDEX:")) {
            this.indexName = subjectName.substring("INDEX:".length());
        } else {
            OClass cls;
            if (subjectName.startsWith("CLASS:")) {
                subjectName = subjectName.substring("CLASS:".length());
            }
            if ((cls = database.getMetadata().getSchema().getClass(subjectName)) == null) {
                this.throwParsingException("Class " + subjectName + " not found in database");
            }
            this.className = cls.getName();
        }
        this.parserSkipWhiteSpaces();
        if (this.parserIsEnded()) {
            this.throwSyntaxErrorException("Set of fields is missed. Example: (name, surname) or SET name = 'Bill'");
        }
        if ((temp = this.parseOptionalWord(true, new String[0])).equals("CLUSTER")) {
            this.clusterName = this.parserRequiredWord(false);
            this.parserSkipWhiteSpaces();
            if (this.parserIsEnded()) {
                this.throwSyntaxErrorException("Set of fields is missed. Example: (name, surname) or SET name = 'Bill'");
            }
        } else {
            this.parserGoBack();
        }
        this.newRecords = new ArrayList<Map<String, Object>>();
        Boolean sourceClauseProcessed = false;
        if (this.parserGetCurrentChar() == '(') {
            this.parseValues();
            this.parserNextWord(true, " \r\n");
            sourceClauseProcessed = true;
        } else {
            this.parserNextWord(true, " ,\r\n");
            if (this.parserGetLastWord().equals("CONTENT")) {
                this.newRecords = null;
                this.parseContent();
                sourceClauseProcessed = true;
            } else if (this.parserGetLastWord().equals("SET")) {
                LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
                this.newRecords.add(fields);
                this.parseSetFields(fields);
                sourceClauseProcessed = true;
            }
        }
        if (sourceClauseProcessed.booleanValue()) {
            this.parserNextWord(true, " \r\n");
        }
        if (this.parserGetLastWord().equals(KEYWORD_RETURN)) {
            this.parseReturn(sourceClauseProcessed == false);
            this.parserNextWord(true, " \r\n");
        }
        if (!sourceClauseProcessed.booleanValue() && this.parserGetLastWord().equals("FROM")) {
            this.newRecords = null;
            this.subQuery = new OSQLAsynchQuery(this.parserText.substring(this.parserGetCurrentPosition()), this);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.newRecords == null && this.content == null && this.subQuery == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        OCommandParameters commandParameters = new OCommandParameters(iArgs);
        if (this.indexName != null) {
            if (this.newRecords == null) {
                throw new OCommandExecutionException("No key/value found");
            }
            OIndex<?> index = OCommandExecutorSQLInsert.getDatabase().getMetadata().getIndexManager().getIndex(this.indexName);
            if (index == null) {
                throw new OCommandExecutionException("Target index '" + this.indexName + "' not found");
            }
            Map<String, Object> result = null;
            for (Map<String, Object> candidate : this.newRecords) {
                index.put(this.getIndexKeyValue(commandParameters, candidate), this.getIndexValue(commandParameters, candidate));
                result = candidate;
            }
            return this.prepareReturnItem(new ODocument(result));
        }
        ArrayList<ODocument> docs = new ArrayList<ODocument>();
        if (this.newRecords != null) {
            for (Map<String, Object> candidate : this.newRecords) {
                ODocument doc = this.className != null ? new ODocument(this.className) : new ODocument();
                OSQLHelper.bindParameters(doc, candidate, commandParameters, this.context);
                this.saveRecord(doc);
                docs.add(doc);
            }
            if (docs.size() == 1) {
                return this.prepareReturnItem((ODocument)docs.get(0));
            }
            return this.prepareReturnResult(docs);
        }
        if (this.content != null) {
            ODocument doc = this.className != null ? new ODocument(this.className) : new ODocument();
            doc.merge(this.content, true, false);
            this.saveRecord(doc);
            return this.prepareReturnItem(doc);
        }
        if (this.subQuery != null) {
            this.subQuery.execute(new Object[0]);
            if (this.queryResult != null) {
                return this.prepareReturnResult(this.queryResult);
            }
            return this.saved.longValue();
        }
        return null;
    }

    @Override
    public boolean isReplicated() {
        return this.indexName != null;
    }

    public String getSyntax() {
        return "INSERT INTO [class:]<class>|cluster:<cluster>|index:<index> [(<field>[,]*) VALUES (<expression>[,]*)[,]*]|[SET <field> = <expression>|<sub-command>[,]*]|CONTENT {<JSON>} [RETURN <expression>] [FROM select-query]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean result(Object iRecord) {
        Object rec = ((OIdentifiable)iRecord).getRecord().copy();
        rec.getIdentity().reset();
        if (rec instanceof ODocument && this.className != null) {
            ((ODocument)rec).setClassName(this.className);
        }
        rec.setDirty();
        OCommandExecutorSQLInsert oCommandExecutorSQLInsert = this;
        synchronized (oCommandExecutorSQLInsert) {
            this.saveRecord((ORecord<?>)rec);
            if (this.queryResult != null) {
                this.queryResult.add((ODocument)rec);
            }
        }
        return true;
    }

    @Override
    public void end() {
    }

    protected Object prepareReturnResult(List<ODocument> res) {
        if (this.returnExpression == null) {
            return res;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (ODocument resItem : res) {
            ret.add(this.prepareReturnItem(resItem));
        }
        return ret;
    }

    protected Object prepareReturnItem(ODocument item) {
        if (this.returnExpression == null) {
            return item;
        }
        this.getContext().setVariable("current", item);
        Object res = OSQLHelper.getValue(this.returnExpression, item, this.getContext());
        if (res instanceof OIdentifiable) {
            return res;
        }
        ODocument wrappingDoc = new ODocument("result", res, new Object[0]);
        wrappingDoc.field("rid", item.getIdentity());
        wrappingDoc.field("version", item.getVersion());
        return wrappingDoc;
    }

    protected void saveRecord(ORecord<?> rec) {
        if (this.clusterName != null) {
            rec.save(this.clusterName);
        } else {
            rec.save();
        }
        this.saved.incrementAndGet();
    }

    protected void parseValues() {
        int beginFields = this.parserGetCurrentPosition();
        int endFields = this.parserText.indexOf(41, beginFields + 1);
        if (endFields == -1) {
            this.throwSyntaxErrorException("Missed closed brace");
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        this.parserSetCurrentPosition(OStringSerializerHelper.getParameters(this.parserText, beginFields, endFields, fieldNames));
        if (fieldNames.size() == 0) {
            this.throwSyntaxErrorException("Set of fields is empty. Example: (name, surname)");
        }
        for (int i = 0; i < fieldNames.size(); ++i) {
            fieldNames.set(i, OStringSerializerHelper.removeQuotationMarks(fieldNames.get(i)));
        }
        this.parserRequiredKeyword(new String[]{KEYWORD_VALUES});
        this.parserSkipWhiteSpaces();
        if (this.parserIsEnded() || this.parserText.charAt(this.parserGetCurrentPosition()) != '(') {
            this.throwParsingException("Set of values is missed. Example: ('Bill', 'Stuart', 300)");
        }
        int blockStart = this.parserGetCurrentPosition();
        int blockEnd = this.parserGetCurrentPosition();
        List<String> records = OStringSerializerHelper.smartSplit(this.parserText, new char[]{','}, blockStart, -1, true, true, false, false, new char[0]);
        for (String record : records) {
            ArrayList<String> values;
            if ((blockEnd += OStringSerializerHelper.getParameters(record, 0, -1, values = new ArrayList<String>())) == -1) {
                throw new OCommandSQLParsingException("Missed closed brace. Use " + this.getSyntax(), this.parserText, blockStart);
            }
            if (values.isEmpty()) {
                throw new OCommandSQLParsingException("Set of values is empty. Example: ('Bill', 'Stuart', 300). Use " + this.getSyntax(), this.parserText, blockStart);
            }
            if (values.size() != fieldNames.size()) {
                throw new OCommandSQLParsingException("Fields not match with values", this.parserText, blockStart);
            }
            LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
            for (int i = 0; i < values.size(); ++i) {
                fields.put(fieldNames.get(i), OSQLHelper.parseValue(this, OStringSerializerHelper.decode(((String)values.get(i)).trim()), this.context));
            }
            this.newRecords.add(fields);
            blockStart = blockEnd;
        }
    }

    protected void parseReturn(Boolean subQueryExpected) throws OCommandSQLParsingException {
        this.parserNextWord(false, " ");
        String returning = this.parserGetLastWord().trim();
        if (returning.startsWith("$") || returning.startsWith("@")) {
            if (subQueryExpected.booleanValue()) {
                this.queryResult = new ArrayList<ODocument>();
            }
            this.returnExpression = returning.length() > 0 ? OSQLHelper.parseValue(this, returning, this.getContext()) : null;
        } else {
            this.throwSyntaxErrorException("record attribute (@attributes) or functions with $current variable expected");
        }
    }

    private Object getIndexKeyValue(OCommandParameters commandParameters, Map<String, Object> candidate) {
        Object parsedKey = candidate.get("key");
        if (parsedKey instanceof OSQLFilterItemField) {
            OSQLFilterItemField f = (OSQLFilterItemField)parsedKey;
            if (f.getRoot().equals("?")) {
                return commandParameters.getNext();
            }
            if (f.getRoot().startsWith(":")) {
                return commandParameters.getByName(f.getRoot().substring(1));
            }
        }
        return parsedKey;
    }

    private OIdentifiable getIndexValue(OCommandParameters commandParameters, Map<String, Object> candidate) {
        Object parsedRid = candidate.get("rid");
        if (parsedRid instanceof OSQLFilterItemField) {
            OSQLFilterItemField f = (OSQLFilterItemField)parsedRid;
            if (f.getRoot().equals("?")) {
                return (OIdentifiable)commandParameters.getNext();
            }
            if (f.getRoot().startsWith(":")) {
                return (OIdentifiable)commandParameters.getByName(f.getRoot().substring(1));
            }
        }
        return (OIdentifiable)parsedRid;
    }
}

