/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OChainedIndexProxy;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OFilterAnalyzer;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.OMetricRecorder;
import com.orientechnologies.orient.core.sql.OOrderByOptimizer;
import com.orientechnologies.orient.core.sql.ORuntimeResult;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OFilterOptimizer;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCount;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.sql.query.OResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OCommandExecutorSQLSelect
extends OCommandExecutorSQLResultsetAbstract {
    public static final String KEYWORD_SELECT = "SELECT";
    public static final String KEYWORD_ASC = "ASC";
    public static final String KEYWORD_DESC = "DESC";
    public static final String KEYWORD_ORDER = "ORDER";
    public static final String KEYWORD_BY = "BY";
    public static final String KEYWORD_GROUP = "GROUP";
    public static final String KEYWORD_FETCHPLAN = "FETCHPLAN";
    private static final String KEYWORD_AS = "AS";
    private static final String KEYWORD_PARALLEL = "PARALLEL";
    private final OOrderByOptimizer orderByOptimizer = new OOrderByOptimizer();
    private final OMetricRecorder metricRecorder = new OMetricRecorder();
    private final OFilterOptimizer filterOptimizer = new OFilterOptimizer();
    private final OFilterAnalyzer filterAnalyzer = new OFilterAnalyzer();
    private Map<String, String> projectionDefinition = null;
    private Map<String, Object> projections = null;
    private List<OPair<String, String>> orderedFields = new ArrayList<OPair<String, String>>();
    private List<String> groupByFields;
    private Map<Object, ORuntimeResult> groupedResult;
    private Object expandTarget;
    private int fetchLimit = -1;
    private OIdentifiable lastRecord;
    private String fetchPlan;
    private volatile boolean executing;
    private boolean fullySortedByIndex = false;
    private OStorage.LOCKING_STRATEGY lockingStrategy = OStorage.LOCKING_STRATEGY.DEFAULT;
    private boolean parallel = false;
    private Lock parallelLock = new ReentrantLock();

    private static Object getIndexKey(OIndexDefinition indexDefinition, Object value, OCommandContext context) {
        if (indexDefinition instanceof OCompositeIndexDefinition || indexDefinition.getParamCount() > 1) {
            if (value instanceof List) {
                List values = (List)value;
                ArrayList<Object> keyParams = new ArrayList<Object>(values.size());
                for (Object o : values) {
                    keyParams.add(OSQLHelper.getValue(o, null, context));
                }
                return indexDefinition.createValue(keyParams);
            }
            if ((value = OSQLHelper.getValue(value)) instanceof OCompositeKey) {
                return value;
            }
            return indexDefinition.createValue(value);
        }
        return indexDefinition.createValue(OSQLHelper.getValue(value));
    }

    private static ODocument createIndexEntryAsDocument(Object iKey, OIdentifiable iValue) {
        ODocument doc = new ODocument().setOrdered(true);
        doc.field("key", iKey);
        doc.field("rid", iValue);
        doc.unsetDirty();
        return doc;
    }

    @Override
    public OCommandExecutorSQLSelect parse(OCommandRequest iRequest) {
        super.parse(iRequest);
        this.initContext();
        int pos = this.parseProjections();
        if (pos == -1) {
            return this;
        }
        int endPosition = this.parserText.length();
        this.parserNextWord(true);
        if (this.parserGetLastWord().equalsIgnoreCase("FROM")) {
            this.parsedTarget = OSQLEngine.getInstance().parseTarget(this.parserText.substring(this.parserGetCurrentPosition(), endPosition), this.getContext(), "WHERE");
            this.parserSetCurrentPosition(this.parsedTarget.parserIsEnded() ? endPosition : this.parsedTarget.parserGetCurrentPosition() + this.parserGetCurrentPosition());
        } else {
            this.parserGoBack();
        }
        if (!this.parserIsEnded()) {
            this.parserSkipWhiteSpaces();
            while (!this.parserIsEnded()) {
                this.parserNextWord(true);
                String w = this.parserGetLastWord();
                if (w.isEmpty()) continue;
                if (w.equals("WHERE")) {
                    this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition(), endPosition), this.getContext(), "WHERE");
                    this.optimize();
                    this.parserSetCurrentPosition(this.compiledFilter.parserIsEnded() ? endPosition : this.compiledFilter.parserGetCurrentPosition() + this.parserGetCurrentPosition());
                    continue;
                }
                if (w.equals("LET")) {
                    this.parseLet();
                    continue;
                }
                if (w.equals(KEYWORD_GROUP)) {
                    this.parseGroupBy();
                    continue;
                }
                if (w.equals(KEYWORD_ORDER)) {
                    this.parseOrderBy();
                    continue;
                }
                if (w.equals("LIMIT")) {
                    this.parseLimit(w);
                    continue;
                }
                if (w.equals("SKIP") || w.equals("OFFSET")) {
                    this.parseSkip(w);
                    continue;
                }
                if (w.equals(KEYWORD_FETCHPLAN)) {
                    this.parseFetchplan(w);
                    continue;
                }
                if (w.equals("TIMEOUT")) {
                    this.parseTimeout(w);
                    continue;
                }
                if (w.equals("LOCK")) {
                    String lock = this.parseLock();
                    if (lock.equalsIgnoreCase("DEFAULT")) {
                        this.lockingStrategy = OStorage.LOCKING_STRATEGY.DEFAULT;
                        continue;
                    }
                    if (lock.equals("NONE")) {
                        this.lockingStrategy = OStorage.LOCKING_STRATEGY.NONE;
                        continue;
                    }
                    if (!lock.equals("RECORD")) continue;
                    this.lockingStrategy = OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK;
                    continue;
                }
                if (w.equals(KEYWORD_PARALLEL)) {
                    this.parallel = this.parseParallel(w);
                    continue;
                }
                this.throwParsingException("Invalid keyword '" + w + "'");
            }
        }
        if (this.limit == 0 || this.limit < -1) {
            throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
        }
        return this;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        HashSet<String> clusters = new HashSet<String>();
        if (this.parsedTarget != null) {
            String string;
            OIndex<?> idx;
            OClass cls;
            String c;
            ODatabaseRecord db = OCommandExecutorSQLSelect.getDatabase();
            if (this.parsedTarget.getTargetQuery() != null) {
                Iterator<String> clIds = this.parsedTarget.getTargetQuery().getInvolvedClusters();
                Iterator<String> iterator = clIds.iterator();
                while (iterator.hasNext()) {
                    c = iterator.next();
                    if (!this.checkClusterAccess(db, c)) continue;
                    clusters.add(c);
                }
            } else if (this.parsedTarget.getTargetRecords() != null) {
                for (OIdentifiable oIdentifiable : this.parsedTarget.getTargetRecords()) {
                    c = db.getClusterNameById(oIdentifiable.getIdentity().getClusterId()).toLowerCase();
                    if (!this.checkClusterAccess(db, c)) continue;
                    clusters.add(c);
                }
            }
            if (this.parsedTarget.getTargetClasses() != null) {
                for (String string2 : this.parsedTarget.getTargetClasses().values()) {
                    cls = db.getMetadata().getSchema().getClass(string2);
                    if (cls == null) continue;
                    for (int clId : cls.getClusterIds()) {
                        if (clId <= -1 || !this.checkClusterAccess(db, db.getClusterNameById(clId))) continue;
                        clusters.add(db.getClusterNameById(clId).toLowerCase());
                    }
                }
            }
            if (this.parsedTarget.getTargetClusters() != null) {
                for (String string3 : this.parsedTarget.getTargetClusters().keySet()) {
                    c = string3.toLowerCase();
                    if (!this.checkClusterAccess(db, c)) continue;
                    clusters.add(c);
                }
            }
            if (this.parsedTarget.getTargetIndex() != null && (idx = db.getMetadata().getIndexManager().getIndex(this.parsedTarget.getTargetIndex())) != null && (string = idx.getDefinition().getClassName()) != null && (cls = db.getMetadata().getSchema().getClass(string)) != null) {
                for (int clId : cls.getClusterIds()) {
                    clusters.add(db.getClusterNameById(clId).toLowerCase());
                }
            }
        }
        return clusters;
    }

    public boolean isAnyFunctionAggregates() {
        if (this.projections != null) {
            for (Map.Entry<String, Object> p : this.projections.entrySet()) {
                if (!(p.getValue() instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)p.getValue()).aggregateResults()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this.iterator(null);
    }

    @Override
    public Iterator<OIdentifiable> iterator(Map<Object, Object> iArgs) {
        Iterator subIterator;
        if (this.target == null) {
            this.executeSearch(iArgs);
            this.applyExpand();
            this.handleNoTarget();
            this.handleGroupBy();
            this.applyOrderBy();
            subIterator = new ArrayList((List)this.getResult()).iterator();
            this.lastRecord = null;
            this.tempResult = null;
            this.groupedResult = null;
        } else {
            subIterator = this.target;
        }
        return subIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Map<Object, Object> iArgs) {
        try {
            if (iArgs != null) {
                for (Map.Entry<Object, Object> arg : iArgs.entrySet()) {
                    this.context.setVariable(arg.getKey().toString(), arg.getValue());
                }
            }
            if (this.timeoutMs > 0L) {
                this.getContext().beginExecution(this.timeoutMs, this.timeoutStrategy);
            }
            if (!this.optimizeExecution()) {
                this.fetchLimit = this.getQueryFetchLimit();
                this.executeSearch(iArgs);
                this.applyExpand();
                this.handleNoTarget();
                this.handleGroupBy();
                this.applyOrderBy();
                this.applyLimitAndSkip();
            }
            Object object = this.getResult();
            return object;
        }
        finally {
            if (this.request.getResultListener() != null) {
                this.request.getResultListener().end();
            }
        }
    }

    public Map<String, Object> getProjections() {
        return this.projections;
    }

    public String getSyntax() {
        return "SELECT [<Projections>] FROM <Target> [LET <Assignment>*] [WHERE <Condition>*] [ORDER BY <Fields>* [ASC|DESC]*] [LIMIT <MaxRecords>] [TIMEOUT <TimeoutInMs>] [LOCK none|record]";
    }

    @Override
    public String getFetchPlan() {
        return this.fetchPlan != null ? this.fetchPlan : this.request.getFetchPlan();
    }

    protected boolean checkClusterAccess(ODatabaseRecord db, String iClusterName) {
        return db.getUser() != null && db.getUser().checkIfAllowed("database.cluster." + iClusterName, this.getSecurityOperationType()) != null;
    }

    protected void executeSearch(Map<Object, Object> iArgs) {
        this.assignTarget(iArgs);
        if (this.target == null) {
            if (this.let != null) {
                this.assignLetClauses(this.lastRecord != null ? (ORecord<?>)this.lastRecord.getRecord() : null);
            }
            return;
        }
        this.fetchFromTarget(this.target);
    }

    @Override
    protected boolean assignTarget(Map<Object, Object> iArgs) {
        if (!super.assignTarget(iArgs)) {
            if (this.parsedTarget.getTargetIndex() != null) {
                this.searchInIndex();
            } else {
                throw new OQueryParsingException("No source found in query: specify class, cluster(s), index or single record(s). Use " + this.getSyntax());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSearchRecord(OIdentifiable id) {
        if (Thread.interrupted()) {
            throw new OCommandExecutionException("The select execution has been interrupted");
        }
        if (!this.context.checkTimeout()) {
            return false;
        }
        OStorage.LOCKING_STRATEGY contextLockingStrategy = this.context.getVariable("$locking") != null ? (OStorage.LOCKING_STRATEGY)((Object)this.context.getVariable("$locking")) : null;
        OStorage.LOCKING_STRATEGY localLockingStrategy = contextLockingStrategy != null ? contextLockingStrategy : this.lockingStrategy;
        ORecordInternal record = null;
        try {
            boolean bl;
            if (id instanceof ORecordInternal) {
                record = (ORecordInternal)id;
                if (localLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
                    record.lock(true);
                } else if (localLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK) {
                    record.lock(false);
                }
            } else {
                boolean noCache = false;
                if (localLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK || localLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK) {
                    noCache = true;
                }
                record = (ORecordInternal)OCommandExecutorSQLSelect.getDatabase().load(id.getIdentity(), (String)null, noCache, false, localLockingStrategy);
            }
            this.context.updateMetric("recordReads", 1L);
            if (record == null || record.getRecordType() != 100) {
                bl = true;
                return bl;
            }
            this.context.updateMetric("documentReads", 1L);
            this.context.setVariable("current", record);
            this.assignLetClauses(record);
            if (this.filter(record) && !this.handleResult(record)) {
                bl = false;
                return bl;
            }
        }
        finally {
            if (record != null && localLockingStrategy != null && (localLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK || localLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK)) {
                record.unlock();
            }
        }
        return true;
    }

    @Override
    protected boolean handleResult(OIdentifiable iRecord) {
        if (this.parallel) {
            this.parallelLock.lock();
        }
        try {
            if ((this.orderedFields.isEmpty() || this.fullySortedByIndex) && this.skip > 0) {
                this.lastRecord = null;
                --this.skip;
                boolean bl = true;
                return bl;
            }
            this.lastRecord = iRecord;
            ++this.resultCount;
            if (!this.addResult(this.lastRecord)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.orderedFields.isEmpty() && !this.fullySortedByIndex || this.isAnyFunctionAggregates() || this.fetchLimit <= -1 || this.resultCount < this.fetchLimit;
            return bl;
        }
        finally {
            if (this.parallel) {
                this.parallelLock.unlock();
            }
        }
    }

    protected boolean addResult(OIdentifiable iRecord) {
        if (iRecord == null) {
            return true;
        }
        if (this.projections != null || this.groupByFields != null && !this.groupByFields.isEmpty()) {
            if (this.groupedResult == null) {
                if ((iRecord = ORuntimeResult.getProjectionResult(this.resultCount, this.projections, this.context, iRecord)) == null) {
                    return true;
                }
            } else {
                Object fieldValue = null;
                if (this.groupByFields != null && !this.groupByFields.isEmpty()) {
                    if (this.groupByFields.size() > 1) {
                        ODocument doc = (ODocument)iRecord.getRecord();
                        Object[] fields = new Object[this.groupByFields.size()];
                        for (int i = 0; i < this.groupByFields.size(); ++i) {
                            String field = this.groupByFields.get(i);
                            fields[i] = field.startsWith("$") ? this.context.getVariable(field) : doc.field(field);
                        }
                        fieldValue = fields;
                    } else {
                        String field = this.groupByFields.get(0);
                        if (field != null) {
                            fieldValue = field.startsWith("$") ? this.context.getVariable(field) : ((ODocument)iRecord.getRecord()).field(field);
                        }
                    }
                }
                this.getProjectionGroup(fieldValue).applyRecord(iRecord);
                return true;
            }
        }
        boolean result = true;
        if ((this.fullySortedByIndex || this.orderedFields.isEmpty()) && this.expandTarget == null) {
            if (this.request.getResultListener() != null) {
                result = this.request.getResultListener().result(iRecord);
            }
        } else {
            if (this.tempResult == null) {
                this.tempResult = new ArrayList();
            }
            ((Collection)this.tempResult).add(iRecord);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ORuntimeResult getProjectionGroup(Object fieldValue) {
        long projectionElapsed = (Long)this.context.getVariable("projectionElapsed", 0L);
        long begin = System.currentTimeMillis();
        try {
            ORuntimeResult group;
            Object key = null;
            if (this.groupedResult == null) {
                this.groupedResult = new LinkedHashMap<Object, ORuntimeResult>();
            }
            if (fieldValue != null) {
                if (fieldValue.getClass().isArray()) {
                    Object[] array = (Object[])fieldValue;
                    StringBuilder keyArray = new StringBuilder();
                    for (Object o : array) {
                        if (keyArray.length() > 0) {
                            keyArray.append(",");
                        }
                        if (o != null) {
                            keyArray.append(o instanceof OIdentifiable ? ((OIdentifiable)o).getIdentity().toString() : o.toString());
                            continue;
                        }
                        keyArray.append("null");
                    }
                    key = keyArray.toString();
                } else {
                    key = fieldValue;
                }
            }
            if ((group = this.groupedResult.get(key)) == null) {
                group = new ORuntimeResult(fieldValue, this.createProjectionFromDefinition(), this.resultCount, this.context);
                this.groupedResult.put(key, group);
            }
            ORuntimeResult oRuntimeResult = group;
            return oRuntimeResult;
        }
        finally {
            this.context.setVariable("projectionElapsed", projectionElapsed + (System.currentTimeMillis() - begin));
        }
    }

    protected void parseGroupBy() {
        this.parserRequiredKeyword(new String[]{KEYWORD_BY});
        this.groupByFields = new ArrayList<String>();
        while (!(this.parserIsEnded() || this.groupByFields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.groupByFields.add(fieldName);
            this.parserSkipWhiteSpaces();
        }
        if (this.groupByFields.size() == 0) {
            this.throwParsingException("Group by field set was missed. Example: GROUP BY name, salary");
        }
        this.getProjectionGroup(null);
    }

    protected void parseOrderBy() {
        this.parserRequiredKeyword(new String[]{KEYWORD_BY});
        String fieldOrdering = null;
        this.orderedFields = new ArrayList<OPair<String, String>>();
        while (!(this.parserIsEnded() || this.orderedFields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserOptionalWord(true);
            String word = this.parserGetLastWord();
            if (word.length() == 0) {
                fieldOrdering = KEYWORD_ASC;
            } else if (word.equals("LIMIT") || word.equals("SKIP") || word.equals("OFFSET")) {
                fieldOrdering = KEYWORD_ASC;
                this.parserGoBack();
            } else if (word.equals(KEYWORD_ASC)) {
                fieldOrdering = KEYWORD_ASC;
            } else if (word.equals(KEYWORD_DESC)) {
                fieldOrdering = KEYWORD_DESC;
            } else {
                this.throwParsingException("Ordering mode '" + word + "' not supported. Valid is 'ASC', 'DESC' or nothing ('ASC' by default)");
            }
            this.orderedFields.add((OPair<String, String>)new OPair((Comparable)((Object)fieldName), (Object)fieldOrdering));
            this.parserSkipWhiteSpaces();
        }
        if (this.orderedFields.size() == 0) {
            this.throwParsingException("Order by field set was missed. Example: ORDER BY name ASC, salary DESC");
        }
    }

    @Override
    protected void searchInClasses() {
        OClass cls = this.parsedTarget.getTargetClasses().keySet().iterator().next();
        if (!this.searchForIndexes(cls)) {
            super.searchInClasses();
        }
    }

    protected int parseProjections() {
        if (!this.parserOptionalKeyword(new String[]{KEYWORD_SELECT})) {
            return -1;
        }
        int upperBound = OStringSerializerHelper.getLowerIndexOf(this.parserTextUpperCase, this.parserGetCurrentPosition(), " FROM ", " LET ");
        if (upperBound == -1) {
            upperBound = this.parserText.length();
        }
        int lastRealPositionProjection = -1;
        int currPos = this.parserGetCurrentPosition();
        if (currPos == -1) {
            return -1;
        }
        String projectionString = this.parserText.substring(currPos, upperBound);
        if (projectionString.trim().length() > 0) {
            this.projections = new LinkedHashMap<String, Object>();
            this.projectionDefinition = new LinkedHashMap<String, String>();
            List<String> items = OStringSerializerHelper.smartSplit(projectionString, ',', new char[0]);
            for (String projectionItem : items) {
                String fieldName;
                String projection = OStringSerializerHelper.smartTrim(projectionItem.trim(), true, true);
                if (this.projectionDefinition == null) {
                    throw new OCommandSQLParsingException("Projection not allowed with FLATTEN() and EXPAND() operators");
                }
                List<String> words = OStringSerializerHelper.smartSplit(projection, ' ', new char[0]);
                if (words.size() > 1 && words.get(1).trim().equalsIgnoreCase(KEYWORD_AS)) {
                    if (words.size() < 3) {
                        throw new OCommandSQLParsingException("Found 'AS' without alias");
                    }
                    fieldName = words.get(2).trim();
                    if (this.projectionDefinition.containsKey(fieldName)) {
                        throw new OCommandSQLParsingException("Field '" + fieldName + "' is duplicated in current SELECT, choose a different name");
                    }
                    projection = words.get(0).trim();
                    lastRealPositionProjection = words.size() > 3 ? projectionString.indexOf(words.get(3)) : (lastRealPositionProjection += projectionItem.length() + 1);
                } else {
                    int endPos;
                    fieldName = projection = words.get(0);
                    lastRealPositionProjection = projectionString.indexOf(fieldName) + fieldName.length() + 1;
                    if (fieldName.charAt(0) == '@') {
                        fieldName = fieldName.substring(1);
                    }
                    if ((endPos = this.extractProjectionNameSubstringEndPosition(fieldName)) > -1) {
                        fieldName = fieldName.substring(0, endPos);
                    }
                    int fieldIndex = 2;
                    while (this.projectionDefinition.containsKey(fieldName)) {
                        fieldName = fieldName + fieldIndex;
                        ++fieldIndex;
                    }
                }
                String p = projection.toUpperCase(Locale.ENGLISH);
                if (p.startsWith("FLATTEN(") || p.startsWith("EXPAND(")) {
                    List<String> pars;
                    if (p.startsWith("FLATTEN(")) {
                        OLogManager.instance().debug((Object)this, "FLATTEN() operator has been replaced by EXPAND()", new Object[0]);
                    }
                    if ((pars = OStringSerializerHelper.getParameters(projection)).size() != 1) {
                        throw new OCommandSQLParsingException("EXPAND/FLATTEN operators expects the field name as parameter. Example EXPAND( out )");
                    }
                    this.expandTarget = OSQLHelper.parseValue(this, pars.get(0).trim(), this.context);
                    this.projectionDefinition = null;
                    this.projections = null;
                    if (this.groupedResult != null || !(this.expandTarget instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)this.expandTarget).aggregateResults()) continue;
                    this.getProjectionGroup(null);
                    continue;
                }
                fieldName = OStringSerializerHelper.getStringContent(fieldName);
                this.projectionDefinition.put(fieldName, projection);
            }
            if (!(this.projectionDefinition == null || this.projectionDefinition.size() <= 1 && this.projectionDefinition.values().iterator().next().equals("*"))) {
                this.projections = this.createProjectionFromDefinition();
                for (Object p : this.projections.values()) {
                    if (this.groupedResult != null || !(p instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)p).aggregateResults()) continue;
                    this.getProjectionGroup(null);
                    break;
                }
            } else {
                this.projectionDefinition = null;
                this.projections = null;
            }
        }
        if (upperBound < this.parserText.length() - 1) {
            this.parserSetCurrentPosition(upperBound);
        } else if (lastRealPositionProjection > -1) {
            this.parserMoveCurrentPosition(lastRealPositionProjection);
        } else {
            this.parserSetEndOfText();
        }
        return this.parserGetCurrentPosition();
    }

    protected Map<String, Object> createProjectionFromDefinition() {
        if (this.projectionDefinition == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> projections = new LinkedHashMap<String, Object>(this.projectionDefinition.size());
        for (Map.Entry<String, String> p : this.projectionDefinition.entrySet()) {
            Object projectionValue = OSQLHelper.parseValue(this, p.getValue(), this.context);
            projections.put(p.getKey(), projectionValue);
        }
        return projections;
    }

    protected int extractProjectionNameSubstringEndPosition(String projection) {
        int endPos;
        int pos1 = projection.indexOf(46);
        int pos2 = projection.indexOf(40);
        int pos3 = projection.indexOf(91);
        if (pos1 > -1 && pos2 == -1 && pos3 == -1) {
            endPos = pos1;
        } else if (pos2 > -1 && pos1 == -1 && pos3 == -1) {
            endPos = pos2;
        } else if (pos3 > -1 && pos1 == -1 && pos2 == -1) {
            endPos = pos3;
        } else if (pos1 > -1 && pos2 > -1 && pos3 == -1) {
            endPos = Math.min(pos1, pos2);
        } else if (pos2 > -1 && pos3 > -1 && pos1 == -1) {
            endPos = Math.min(pos2, pos3);
        } else if (pos1 > -1 && pos3 > -1 && pos2 == -1) {
            endPos = Math.min(pos1, pos3);
        } else if (pos1 > -1 && pos2 > -1 && pos3 > -1) {
            endPos = Math.min(pos1, pos2);
            endPos = Math.min(endPos, pos3);
        } else {
            endPos = -1;
        }
        return endPos;
    }

    protected boolean parseFetchplan(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_FETCHPLAN)) {
            return false;
        }
        this.parserSkipWhiteSpaces();
        int start = this.parserGetCurrentPosition();
        this.parserNextWord(true);
        int end = this.parserGetCurrentPosition();
        this.parserSkipWhiteSpaces();
        int position = this.parserGetCurrentPosition();
        while (!this.parserIsEnded()) {
            this.parserNextWord(true);
            String word = OStringSerializerHelper.getStringContent(this.parserGetLastWord());
            if (!word.matches(".*:-?\\d+")) break;
            end = this.parserGetCurrentPosition();
            this.parserSkipWhiteSpaces();
            position = this.parserGetCurrentPosition();
        }
        this.parserSetCurrentPosition(position);
        this.fetchPlan = end < 0 ? OStringSerializerHelper.getStringContent(this.parserText.substring(start)) : OStringSerializerHelper.getStringContent(this.parserText.substring(start, end));
        this.request.setFetchPlan(this.fetchPlan);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean optimizeExecution() {
        block16: {
            if ((this.compiledFilter == null || this.compiledFilter.getRootCondition() == null) && this.groupByFields == null && this.projections != null && this.projections.size() == 1) {
                long startOptimization = System.currentTimeMillis();
                try {
                    Map.Entry<String, Object> entry = this.projections.entrySet().iterator().next();
                    if (!(entry.getValue() instanceof OSQLFunctionRuntime)) break block16;
                    OSQLFunctionRuntime rf = (OSQLFunctionRuntime)entry.getValue();
                    if (!(rf.function instanceof OSQLFunctionCount) || rf.configuredParameters.length != 1 || !"*".equals(rf.configuredParameters[0])) break block16;
                    long count = 0L;
                    if (this.parsedTarget.getTargetClasses() != null) {
                        OClass cls = this.parsedTarget.getTargetClasses().keySet().iterator().next();
                        count = cls.count();
                    } else if (this.parsedTarget.getTargetClusters() != null) {
                        for (String cluster : this.parsedTarget.getTargetClusters().keySet()) {
                            count += OCommandExecutorSQLSelect.getDatabase().countClusterElements(cluster);
                        }
                    } else if (this.parsedTarget.getTargetIndex() != null) {
                        count += OCommandExecutorSQLSelect.getDatabase().getMetadata().getIndexManager().getIndex(this.parsedTarget.getTargetIndex()).getSize();
                    } else {
                        Iterable<? extends OIdentifiable> recs = this.parsedTarget.getTargetRecords();
                        if (recs != null) {
                            if (recs instanceof Collection) {
                                count += (long)((Collection)recs).size();
                            } else {
                                for (OIdentifiable oIdentifiable : recs) {
                                    ++count;
                                }
                            }
                        }
                    }
                    if (this.tempResult == null) {
                        this.tempResult = new ArrayList();
                    }
                    ((Collection)this.tempResult).add(new ODocument().field(entry.getKey(), count));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.context.setVariable("optimizationElapsed", System.currentTimeMillis() - startOptimization);
                }
            }
        }
        return false;
    }

    private void initContext() {
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        this.metricRecorder.setContext(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFromTarget(Iterator<? extends OIdentifiable> iTarget) {
        block7: {
            long startFetching = System.currentTimeMillis();
            try {
                if (this.parallel) {
                    this.parallelExec(iTarget);
                    break block7;
                }
                while (iTarget.hasNext()) {
                    OIdentifiable next = iTarget.next();
                    if (next == null) {
                    } else if (this.executeSearchRecord(next)) continue;
                    break;
                }
            }
            finally {
                this.context.setVariable("fetchingFromTargetElapsed", System.currentTimeMillis() - startFetching);
            }
        }
    }

    private boolean parseParallel(String w) {
        return w.equals(KEYWORD_PARALLEL);
    }

    private void parallelExec(Iterator<? extends OIdentifiable> iTarget) {
        OIdentifiable next;
        OResultSet result = (OResultSet)this.getResult();
        final ODatabaseRecord db = OCommandExecutorSQLSelect.getDatabase();
        if (this.limit > -1 && result != null) {
            result.setLimit(this.limit);
        }
        int cores = Runtime.getRuntime().availableProcessors();
        OLogManager.instance().debug((Object)this, "Parallel query against %d threads", new Object[]{cores});
        ThreadPoolExecutor workers = Orient.instance().getWorkers();
        this.executing = true;
        ArrayList jobs = new ArrayList();
        while (this.executing && iTarget.hasNext() && (next = iTarget.next()) != null) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ODatabaseRecordThreadLocal.INSTANCE.set(db);
                    if (!OCommandExecutorSQLSelect.this.executeSearchRecord(next)) {
                        OCommandExecutorSQLSelect.this.executing = false;
                    }
                }
            };
            jobs.add(workers.submit(job));
        }
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Parallel query '%s' split in %d jobs, waiting for completion...", new Object[]{this.parserText, jobs.size()});
        }
        int processed = 0;
        int total = jobs.size();
        try {
            for (Future future : jobs) {
                future.get();
                if (!OLogManager.instance().isDebugEnabled() || ++processed % (total / 10) != 0) continue;
                OLogManager.instance().debug((Object)this, "Executed parallel query %d/%d", new Object[]{processed, total});
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on executing parallel query: %s", (Throwable)e, new Object[]{this.parserText});
        }
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Parallel query '%s' completed", new Object[]{this.parserText});
        }
    }

    private int getQueryFetchLimit() {
        int sqlLimit = this.limit > -1 ? this.limit : -1;
        int requestLimit = this.request.getLimit() > -1 ? this.request.getLimit() : -1;
        if (sqlLimit == -1) {
            return requestLimit;
        }
        if (requestLimit == -1) {
            return sqlLimit;
        }
        return Math.min(sqlLimit, requestLimit);
    }

    private boolean tryOptimizeSort(OClass iSchemaClass) {
        if (this.orderedFields.size() == 0) {
            return false;
        }
        return this.optimizeSort(iSchemaClass);
    }

    private boolean searchForIndexes(OClass iSchemaClass) {
        ODatabaseRecord database = OCommandExecutorSQLSelect.getDatabase();
        database.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)iSchemaClass.getName().toLowerCase());
        if (this.compiledFilter == null) {
            return this.tryOptimizeSort(iSchemaClass);
        }
        List<OIndexSearchResult> indexSearchResults = this.filterAnalyzer.analyzeCondition(this.compiledFilter.getRootCondition(), iSchemaClass, this.context);
        for (OIndexSearchResult searchResult : indexSearchResults) {
            List<OIndex<?>> involvedIndexes = this.filterAnalyzer.getInvolvedIndexes(iSchemaClass, searchResult);
            Collections.sort(involvedIndexes, new IndexComparator());
            for (OIndex<?> index : involvedIndexes) {
                OIndexCursor cursor;
                String relatedIndexField;
                String lastFiled;
                OQueryOperator operator;
                if (index.isRebuiding()) continue;
                OIndexDefinition indexDefinition = index.getDefinition();
                if (searchResult.containsNullValues && indexDefinition.isNullValuesIgnored() || !OIndexSearchResult.isIndexEqualityOperator(operator = searchResult.lastOperator) && !(lastFiled = searchResult.lastField.getItemName(searchResult.lastField.getItemCount() - 1)).equals(relatedIndexField = indexDefinition.getFields().get(searchResult.fieldValuePairs.size()))) continue;
                int searchResultFieldsCount = searchResult.fields().size();
                ArrayList<Object> keyParams = new ArrayList<Object>(searchResultFieldsCount);
                for (String fieldName : indexDefinition.getFields().subList(0, searchResultFieldsCount)) {
                    Object fieldValue = searchResult.fieldValuePairs.get(fieldName);
                    if (fieldValue instanceof OSQLQuery) {
                        return false;
                    }
                    if (fieldValue != null) {
                        keyParams.add(fieldValue);
                        continue;
                    }
                    if (searchResult.lastValue instanceof OSQLQuery) {
                        return false;
                    }
                    keyParams.add(searchResult.lastValue);
                }
                this.metricRecorder.recordInvolvedIndexesMetric(index);
                boolean indexIsUsedInOrderBy = this.orderByOptimizer.canBeUsedByOrderBy(index, this.orderedFields) && !(index.getInternal() instanceof OChainedIndexProxy);
                try {
                    boolean ascSortOrder;
                    boolean bl = ascSortOrder = !indexIsUsedInOrderBy || ((String)this.orderedFields.get(0).getValue()).equals(KEYWORD_ASC);
                    if (indexIsUsedInOrderBy) {
                        this.fullySortedByIndex = indexDefinition.getFields().size() >= this.orderedFields.size();
                    }
                    this.context.setVariable("$limit", this.limit);
                    cursor = operator.executeIndexQuery(this.context, index, keyParams, ascSortOrder);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on using index %s in query '%s'. Probably you need to rebuild indexes. Now executing query using cluster scan", (Throwable)e, new Object[]{index.getName(), this.request != null && this.request.getText() != null ? this.request.getText() : ""});
                    this.fullySortedByIndex = false;
                    return false;
                }
                if (cursor == null) continue;
                this.filterOptimizer.optimize(this.compiledFilter, searchResult);
                this.fetchValuesFromIndexCursor(cursor);
                this.metricRecorder.recordOrderByOptimizationMetric(indexIsUsedInOrderBy, this.fullySortedByIndex);
                return true;
            }
        }
        return this.tryOptimizeSort(iSchemaClass);
    }

    private boolean optimizeSort(OClass iSchemaClass) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (OPair<String, String> pair : this.orderedFields) {
            fieldNames.add((String)((Object)pair.getKey()));
        }
        Set<OIndex<?>> indexes = iSchemaClass.getInvolvedIndexes(fieldNames);
        for (OIndex<?> index : indexes) {
            if (!this.orderByOptimizer.canBeUsedByOrderBy(index, this.orderedFields)) continue;
            boolean ascSortOrder = ((String)this.orderedFields.get(0).getValue()).equals(KEYWORD_ASC);
            Object key = ascSortOrder ? index.getFirstKey() : index.getLastKey();
            if (key == null) {
                return false;
            }
            this.fullySortedByIndex = true;
            if (this.context.isRecordingMetrics()) {
                this.context.setVariable("indexIsUsedInOrderBy", true);
                this.context.setVariable("fullySortedByIndex", this.fullySortedByIndex);
                HashSet<String> idxNames = (HashSet<String>)this.context.getVariable("involvedIndexes");
                if (idxNames == null) {
                    idxNames = new HashSet<String>();
                    this.context.setVariable("involvedIndexes", idxNames);
                }
                idxNames.add(index.getName());
            }
            OIndexCursor cursor = ascSortOrder ? index.iterateEntriesMajor(key, true, true) : index.iterateEntriesMinor(key, true, false);
            this.fetchValuesFromIndexCursor(cursor);
            return true;
        }
        this.metricRecorder.recordOrderByOptimizationMetric(false, this.fullySortedByIndex);
        return false;
    }

    private void fetchValuesFromIndexCursor(OIndexCursor cursor) {
        int needsToFetch = this.fetchLimit > 0 ? this.fetchLimit + this.skip : -1;
        cursor.setPrefetchSize(needsToFetch);
        this.fetchFromTarget(cursor);
    }

    private void fetchEntriesFromIndexCursor(OIndexCursor cursor) {
        int needsToFetch = this.fetchLimit > 0 ? this.fetchLimit + this.skip : -1;
        cursor.setPrefetchSize(needsToFetch);
        Map.Entry<Object, OIdentifiable> entryRecord = cursor.nextEntry();
        if (needsToFetch > 0) {
            --needsToFetch;
        }
        while (entryRecord != null) {
            ODocument doc = new ODocument().setOrdered(true);
            doc.field("key", entryRecord.getKey());
            doc.field("rid", entryRecord.getValue().getIdentity());
            doc.unsetDirty();
            if (!this.handleResult(doc)) break;
            if (needsToFetch > 0) {
                cursor.setPrefetchSize(--needsToFetch);
            }
            entryRecord = cursor.nextEntry();
        }
    }

    private boolean isRidOnlySort() {
        return this.parsedTarget.getTargetClasses() != null && this.orderedFields.size() == 1 && ((String)((Object)this.orderedFields.get(0).getKey())).toLowerCase().equals("@rid") && this.target != null && (this.target instanceof ORecordIteratorClass || this.target instanceof ORecordIteratorCluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyOrderBy() {
        if (this.orderedFields.isEmpty() || this.fullySortedByIndex || this.isRidOnlySort()) {
            return;
        }
        long startOrderBy = System.currentTimeMillis();
        try {
            if (this.tempResult instanceof OMultiCollectionIterator) {
                ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                for (OIdentifiable o : this.tempResult) {
                    list.add(o);
                }
                this.tempResult = list;
            }
            ODocumentHelper.sort((List)this.tempResult, this.orderedFields, this.context);
            this.orderedFields.clear();
        }
        finally {
            this.metricRecorder.orderByElapsed(startOrderBy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyExpand() {
        if (this.expandTarget == null) {
            return;
        }
        long startExpand = System.currentTimeMillis();
        try {
            if (this.tempResult == null) {
                Object r;
                this.tempResult = new ArrayList();
                if (this.expandTarget instanceof OSQLFilterItemVariable && (r = ((OSQLFilterItemVariable)this.expandTarget).getValue(null, null, this.context)) != null) {
                    if (r instanceof OIdentifiable) {
                        ((Collection)this.tempResult).add((OIdentifiable)r);
                    } else if (OMultiValue.isMultiValue((Object)r)) {
                        for (Object o : OMultiValue.getMultiValueIterable((Object)r)) {
                            ((Collection)this.tempResult).add((OIdentifiable)o);
                        }
                    }
                }
            } else {
                OMultiCollectionIterator finalResult = new OMultiCollectionIterator();
                finalResult.setLimit(this.limit);
                for (OIdentifiable id : this.tempResult) {
                    Object fieldValue = this.expandTarget instanceof OSQLFilterItem ? ((OSQLFilterItem)this.expandTarget).getValue((OIdentifiable)id.getRecord(), null, this.context) : (this.expandTarget instanceof OSQLFunctionRuntime ? ((OSQLFunctionRuntime)this.expandTarget).getResult() : this.expandTarget.toString());
                    if (fieldValue == null) continue;
                    if (fieldValue instanceof Collection || fieldValue.getClass().isArray() || fieldValue instanceof Iterator || fieldValue instanceof OIdentifiable || fieldValue instanceof ORidBag) {
                        finalResult.add(fieldValue);
                        continue;
                    }
                    if (!(fieldValue instanceof Map)) continue;
                    finalResult.add(((Map)fieldValue).values());
                }
                this.tempResult = finalResult;
            }
        }
        finally {
            this.context.setVariable("expandElapsed", System.currentTimeMillis() - startExpand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchInIndex() {
        OIndex index = OCommandExecutorSQLSelect.getDatabase().getMetadata().getIndexManager().getIndex(this.parsedTarget.getTargetIndex());
        if (index == null) {
            throw new OCommandExecutionException("Target index '" + this.parsedTarget.getTargetIndex() + "' not found");
        }
        boolean ascOrder = true;
        if (!this.orderedFields.isEmpty()) {
            if (this.orderedFields.size() != 1) {
                throw new OCommandExecutionException("Index can be ordered only by key field");
            }
            String fieldName = (String)((Object)this.orderedFields.get(0).getKey());
            if (!fieldName.equalsIgnoreCase("key")) {
                throw new OCommandExecutionException("Index can be ordered only by key field");
            }
            String order = (String)this.orderedFields.get(0).getValue();
            ascOrder = order.equalsIgnoreCase(KEYWORD_ASC);
        }
        if (index.getDefinition() == null) {
            return;
        }
        if (this.compiledFilter != null && this.compiledFilter.getRootCondition() != null) {
            Object value;
            if (!"KEY".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
                throw new OCommandExecutionException("'Key' field is required for queries against indexes");
            }
            OQueryOperator indexOperator = this.compiledFilter.getRootCondition().getOperator();
            if (indexOperator instanceof OQueryOperatorBetween) {
                Object[] values = (Object[])this.compiledFilter.getRootCondition().getRight();
                OIndexCursor cursor = index.iterateEntriesBetween(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), values[0], this.context), true, OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), values[2], this.context), true, ascOrder);
                this.fetchEntriesFromIndexCursor(cursor);
            } else if (indexOperator instanceof OQueryOperatorMajor) {
                value = this.compiledFilter.getRootCondition().getRight();
                OIndexCursor cursor = index.iterateEntriesMajor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value, this.context), false, ascOrder);
                this.fetchEntriesFromIndexCursor(cursor);
            } else if (indexOperator instanceof OQueryOperatorMajorEquals) {
                value = this.compiledFilter.getRootCondition().getRight();
                OIndexCursor cursor = index.iterateEntriesMajor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value, this.context), true, ascOrder);
                this.fetchEntriesFromIndexCursor(cursor);
            } else if (indexOperator instanceof OQueryOperatorMinor) {
                value = this.compiledFilter.getRootCondition().getRight();
                OIndexCursor cursor = index.iterateEntriesMinor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value, this.context), false, ascOrder);
                this.fetchEntriesFromIndexCursor(cursor);
            } else if (indexOperator instanceof OQueryOperatorMinorEquals) {
                value = this.compiledFilter.getRootCondition().getRight();
                OIndexCursor cursor = index.iterateEntriesMinor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value, this.context), true, ascOrder);
                this.fetchEntriesFromIndexCursor(cursor);
            } else if (indexOperator instanceof OQueryOperatorIn) {
                List origValues = (List)this.compiledFilter.getRootCondition().getRight();
                ArrayList values = new ArrayList(origValues.size());
                for (Object val : origValues) {
                    if (index.getDefinition() instanceof OCompositeIndexDefinition) {
                        throw new OCommandExecutionException("Operator IN not supported yet.");
                    }
                    val = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), val, this.context);
                    values.add(val);
                }
                OIndexCursor cursor = index.iterateEntries(values, true);
                this.fetchEntriesFromIndexCursor(cursor);
            } else {
                Object res;
                Object right = this.compiledFilter.getRootCondition().getRight();
                Object keyValue = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), right, this.context);
                if (keyValue == null) {
                    return;
                }
                if (index.getDefinition().getParamCount() == 1) {
                    OType type = index.getDefinition().getTypes()[0];
                    keyValue = OType.convert(keyValue, type.getDefaultJavaType());
                    res = index.get(keyValue);
                } else {
                    Object secondKey = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), right, this.context);
                    if (keyValue instanceof OCompositeKey && secondKey instanceof OCompositeKey && ((OCompositeKey)keyValue).getKeys().size() == index.getDefinition().getParamCount() && ((OCompositeKey)secondKey).getKeys().size() == index.getDefinition().getParamCount()) {
                        res = index.get(keyValue);
                    } else {
                        OIndexCursor cursor = index.iterateEntriesBetween(keyValue, true, secondKey, true, true);
                        this.fetchEntriesFromIndexCursor(cursor);
                        return;
                    }
                }
                if (res != null) {
                    if (res instanceof Collection) {
                        OIdentifiable r;
                        Iterator iterator = ((Collection)res).iterator();
                        while (iterator.hasNext() && this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(keyValue, (r = (OIdentifiable)iterator.next()).getIdentity()))) {
                        }
                    } else {
                        this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(keyValue, ((OIdentifiable)res).getIdentity()));
                    }
                }
            }
        } else {
            if (this.isIndexSizeQuery()) {
                this.getProjectionGroup(null).applyValue(this.projections.keySet().iterator().next(), index.getSize());
                return;
            }
            if (this.isIndexKeySizeQuery()) {
                this.getProjectionGroup(null).applyValue(this.projections.keySet().iterator().next(), index.getKeySize());
                return;
            }
            OIndexInternal<?> indexInternal = index.getInternal();
            if (indexInternal instanceof OSharedResource) {
                ((OSharedResource)indexInternal).acquireExclusiveLock();
            }
            try {
                if (ascOrder) {
                    Object firstKey = index.getFirstKey();
                    if (firstKey == null) {
                        return;
                    }
                    OIndexCursor cursor = index.iterateEntriesMajor(firstKey, true, true);
                    this.fetchEntriesFromIndexCursor(cursor);
                } else {
                    Object lastKey = index.getLastKey();
                    if (lastKey == null) {
                        return;
                    }
                    OIndexCursor cursor = index.iterateEntriesMinor(lastKey, true, false);
                    this.fetchEntriesFromIndexCursor(cursor);
                }
            }
            finally {
                if (indexInternal instanceof OSharedResource) {
                    ((OSharedResource)indexInternal).releaseExclusiveLock();
                }
            }
        }
    }

    private boolean isIndexSizeQuery() {
        if (this.groupedResult == null || this.projections.entrySet().size() != 1) {
            return false;
        }
        Object projection = this.projections.values().iterator().next();
        if (!(projection instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
        return f.getRoot().equals("count") && (f.configuredParameters == null || f.configuredParameters.length == 0 || f.configuredParameters.length == 1 && f.configuredParameters[0].equals("*"));
    }

    private boolean isIndexKeySizeQuery() {
        if (this.groupedResult == null || this.projections.entrySet().size() != 1) {
            return false;
        }
        Object projection = this.projections.values().iterator().next();
        if (!(projection instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
        if (!f.getRoot().equals("count")) {
            return false;
        }
        if (f.configuredParameters == null || f.configuredParameters.length != 1 || !(f.configuredParameters[0] instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime fConfigured = (OSQLFunctionRuntime)f.configuredParameters[0];
        if (!fConfigured.getRoot().equals("distinct")) {
            return false;
        }
        if (fConfigured.configuredParameters == null || fConfigured.configuredParameters.length != 1 || !(fConfigured.configuredParameters[0] instanceof OSQLFilterItemField)) {
            return false;
        }
        OSQLFilterItemField field = (OSQLFilterItemField)fConfigured.configuredParameters[0];
        return field.getRoot().equals("key");
    }

    private void handleNoTarget() {
        if (this.parsedTarget == null && this.expandTarget == null) {
            this.addResult(ORuntimeResult.createProjectionDocument(this.resultCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGroupBy() {
        if (this.groupedResult != null && this.tempResult == null) {
            long startGroupBy = System.currentTimeMillis();
            try {
                this.tempResult = new ArrayList();
                for (Map.Entry<Object, ORuntimeResult> g : this.groupedResult.entrySet()) {
                    ODocument doc;
                    if (g.getKey() == null && (this.groupedResult.size() != 1 || this.groupByFields != null) || (doc = g.getValue().getResult()) == null || doc.isEmpty()) continue;
                    ((List)this.tempResult).add(doc);
                }
            }
            finally {
                this.context.setVariable("groupByElapsed", System.currentTimeMillis() - startGroupBy);
            }
        }
    }

    private final class IndexComparator
    implements Comparator<OIndex<?>> {
        private IndexComparator() {
        }

        @Override
        public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
            int secondParamCount;
            OIndexDefinition definitionOne = indexOne.getDefinition();
            OIndexDefinition definitionTwo = indexTwo.getDefinition();
            int firstParamCount = definitionOne.getParamCount();
            int result = firstParamCount - (secondParamCount = definitionTwo.getParamCount());
            if (result == 0 && !OCommandExecutorSQLSelect.this.orderedFields.isEmpty()) {
                if (!(indexOne instanceof OChainedIndexProxy) && OCommandExecutorSQLSelect.this.orderByOptimizer.canBeUsedByOrderBy(indexOne, OCommandExecutorSQLSelect.this.orderedFields)) {
                    return 1;
                }
                if (!(indexTwo instanceof OChainedIndexProxy) && OCommandExecutorSQLSelect.this.orderByOptimizer.canBeUsedByOrderBy(indexTwo, OCommandExecutorSQLSelect.this.orderedFields)) {
                    return -1;
                }
            }
            return result;
        }
    }
}

