/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.methods.OSQLMethodRuntime;
import java.util.Set;

public class OSQLFilterItemField
extends OSQLFilterItemAbstract {
    protected Set<String> preLoadedFields;
    protected String[] preLoadedFieldsArray;
    protected String name;
    protected OCollate collate;

    public OSQLFilterItemField(OBaseParser iQueryToParse, String iName) {
        super(iQueryToParse, iName);
    }

    @Override
    public Object getValue(OIdentifiable iRecord, Object iCurrentResult, OCommandContext iContext) {
        if (iRecord == null) {
            throw new OCommandExecutionException("expression item '" + this.name + "' cannot be resolved because current record is NULL");
        }
        ODocument doc = (ODocument)iRecord.getRecord();
        if (this.preLoadedFieldsArray == null && this.preLoadedFields != null && this.preLoadedFields.size() > 0 && this.preLoadedFields.size() < 5) {
            this.preLoadedFieldsArray = new String[this.preLoadedFields.size()];
            this.preLoadedFields.toArray(this.preLoadedFieldsArray);
        }
        if (doc.deserializeFields(this.preLoadedFieldsArray)) {
            Object v = ODocumentHelper.getFieldValue(doc, this.name);
            this.collate = this.getCollateForField(doc, this.name);
            return this.transformValue(iRecord, iContext, v);
        }
        return null;
    }

    @Override
    public String getRoot() {
        return this.name;
    }

    @Override
    public void setRoot(OBaseParser iQueryToParse, String iRoot) {
        this.name = iRoot;
    }

    public boolean isFieldChain() {
        if (this.operationsChain == null) {
            return true;
        }
        for (OPair pair : this.operationsChain) {
            if (((OSQLMethodRuntime)pair.getKey()).getMethod().getName().equals("field")) continue;
            return false;
        }
        return true;
    }

    public FieldChain getFieldChain() {
        if (!this.isFieldChain()) {
            throw new IllegalStateException("Filter item field contains not only field operators");
        }
        return new FieldChain();
    }

    public void setPreLoadedFields(Set<String> iPrefetchedFieldList) {
        this.preLoadedFields = iPrefetchedFieldList;
    }

    public OCollate getCollate() {
        return this.collate;
    }

    public class FieldChain {
        private FieldChain() {
        }

        public String getItemName(int fieldIndex) {
            if (fieldIndex == 0) {
                return OSQLFilterItemField.this.name;
            }
            return ((Object[])((OPair)OSQLFilterItemField.this.operationsChain.get(fieldIndex - 1)).getValue())[0].toString();
        }

        public int getItemCount() {
            if (OSQLFilterItemField.this.operationsChain == null) {
                return 1;
            }
            return OSQLFilterItemField.this.operationsChain.size() + 1;
        }

        public boolean isLong() {
            return OSQLFilterItemField.this.operationsChain != null && OSQLFilterItemField.this.operationsChain.size() > 0;
        }

        public boolean belongsTo(OSQLFilterItemField filterItemField) {
            return OSQLFilterItemField.this == filterItemField;
        }
    }
}

